%define _name hargyllcms

Name: argyllcms
Version: 1.6.0
Release: alt1

Summary: ICC compatible color management system
Group: Graphics
License: GPLv3 and MIT

URL: http://gitorious.org/%_name
Source: http://people.freedesktop.org/~hughsient/releases/%_name-%version.tar.xz

BuildRequires: libusb-devel libtiff-devel zlib-devel libjpeg-devel libX11-devel libXext-devel
BuildRequires: libXxf86vm-devel libXinerama-devel libXScrnSaver-devel libXrandr-devel

%description
The Argyll color management system supports accurate ICC profile
creation for scanners, CMYK printers, film recorders and calibration and
profiling of displays.

Spectral sample data is supported, allowing a selection of illuminants
observer types, and paper fluorescent whitener additive compensation.
Profiles can also incorporate source specific gamut mappings for
perceptual and saturation intents. Gamut mapping and profile linking
uses the CIECAM02 appearance model, a unique gamut mapping algorithm,
and a wide selection of rendering intents. It also includes code for the
fastest portable 8 bit raster color conversion engine available
anywhere, as well as support for fast, fully accurate 16 bit conversion.
Device color gamuts can also be viewed and compared using a VRML viewer.

%package doc
Summary: Argyll CMS documentation
Group: Graphics
BuildArch: noarch
Conflicts: %name < %version

%description doc
The Argyll color management system supports accurate ICC profile
creation for scanners, CMYK printers, film recorders and calibration and
profiling of displays.

This package contains the Argyll color management system documentation.

%prep
%setup -n %_name-%version

%build
%autoreconf
%configure --disable-static

# SMP-incompatible build
%make

%check
%make check

%install
%make DESTDIR=%buildroot install

%files
%_bindir/*
%_libdir/libargyll.so.*
%_libdir/libargyllicc.so.*
%exclude %_libdir/libargyll.so
%exclude %_libdir/libargyllicc.so
%_datadir/color/argyll/
%doc README *.txt

%files doc
%doc doc/*.html doc/*.jpg doc/*.txt

%exclude %_datadir/doc

%changelog
