Name: aria2
Version: 1.18.3
Release: alt0.M70P.1

Summary: aria2 - a simple utility for downloading files faster
License: GPL
Group: Networking/File transfer
Url: http://aria2.sourceforge.net/
Packager: Ilya Mashkin <oddity@altlinux.ru>

Source: %name-%version.tar.bz2

# Automatically added by buildreq on Thu Mar 23 2006
BuildRequires: gcc-c++ libssl-devel libstdc++-devel
BuildRequires: bison
BuildRequires: cppunit-devel
BuildRequires: gettext
BuildRequires: libcares-devel
BuildRequires: libgcrypt-devel
BuildRequires: libgnutls-devel
BuildRequires: libsqlite3-devel
BuildRequires: libxml2-devel
BuildRequires: zlib-devel

%description
aria2 is a download utility with resuming and segmented downloading.
Supported protocols are HTTP/HTTPS/FTP/BitTorrent. It also supports Metalink
version 3.0.

Currently it has following features:
- HTTP/HTTPS GET support
- HTTP Proxy support
- HTTP BASIC authentication support
- HTTP Proxy authentication support
- FTP support (active, passive mode)
- FTP through HTTP proxy (GET command or tunneling)
- Segmented download
- Cookie support
- It can run as a daemon process.
- BitTorrent protocol support with fast extension.
- Selective download in multi-file torrent
- Metalink version 3.0 support (HTTP/FTP/BitTorrent).
- Limiting download/upload speed

%prep
%setup -n %name-%version

%build
%configure --enable-bittorrent \
           --enable-metalink \
           --enable-epoll\
           --disable-rpath \
           --with-gnutls \
           --with-libcares \
           --with-libxml2 \
           --with-openssl \
           --with-libz \
           --with-sqlite3
%make

%install
#mkdir -p %buildroot%_bindir
#__install -pD -m755 src/aria2c %buildroot%_bindir/aria2c

%makeinstall
%find_lang aria2c

ln -s aria2c  %buildroot%_bindir/%name

%files -f aria2c.lang
%doc AUTHORS ChangeLog README
%_bindir/%name
%_bindir/aria2c
%_man1dir/aria2c.1.bz2
#_mandir/*/man1/aria2c.1.gz
%_datadir/locale/*/LC_MESSAGES/aria2.mo

%changelog
