%define somver 0
%define sover %somver.0.0
Name: arprec
Version: 2.2.16
Release: alt1
Summary: C++/Fortran-90 arbitrary precision package
License: BSD
Group: Sciences/Mathematics
Url: http://crd.lbl.gov/~dhbailey/mpdist/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar.gz

BuildPreReq: gcc-fortran libgfortran-devel gcc-c++ libqd-devel

Conflicts: Io-language

%description
This package supports a flexible, arbitrarily high level of numeric precision --
the equivalent of hundreds or even thousands of decimal digits (up to
approximately ten million digits if needed). Special routines are provided for
extra-high precision (above 1000 digits). The entire library is written in C++.
High-precision real, integer and complex datatypes are supported. Both C++ and
Fortran-90 translation modules modules are also provided that permit one to
convert an existing C++ or Fortran-90 program to use the library with only minor
changes to the source code. In most cases only the type statements and (in the
case of Fortran-90 programs) read/write statements need be changed. Six
implementations of PSLQ (one-, two- and three-level, regular and multi-pair) are
included, as well as three high-precision quadrature programs. New users are
encouraged to use this package, rather than MPFUN90 or MPFUN77 (see below).

%package -n lib%name
Summary: Shared libraries of ARPREC
Group: System/Libraries

%description -n lib%name
This package supports a flexible, arbitrarily high level of numeric precision --
the equivalent of hundreds or even thousands of decimal digits (up to
approximately ten million digits if needed). Special routines are provided for
extra-high precision (above 1000 digits). The entire library is written in C++.
High-precision real, integer and complex datatypes are supported. Both C++ and
Fortran-90 translation modules modules are also provided that permit one to
convert an existing C++ or Fortran-90 program to use the library with only minor
changes to the source code. In most cases only the type statements and (in the
case of Fortran-90 programs) read/write statements need be changed. Six
implementations of PSLQ (one-, two- and three-level, regular and multi-pair) are
included, as well as three high-precision quadrature programs. New users are
encouraged to use this package, rather than MPFUN90 or MPFUN77 (see below).

This package contains static libraries and headers of ARPREC.

%package -n lib%name-devel
Summary: Development files of ARPREC
Group: Development/Other
Requires: libqd-devel
Requires: lib%name = %version-%release
Conflicts: lib%name-devel < %version-%release
Obsoletes: lib%name-devel < %version-%release

%description -n lib%name-devel
This package supports a flexible, arbitrarily high level of numeric precision --
the equivalent of hundreds or even thousands of decimal digits (up to
approximately ten million digits if needed). Special routines are provided for
extra-high precision (above 1000 digits). The entire library is written in C++.
High-precision real, integer and complex datatypes are supported. Both C++ and
Fortran-90 translation modules modules are also provided that permit one to
convert an existing C++ or Fortran-90 program to use the library with only minor
changes to the source code. In most cases only the type statements and (in the
case of Fortran-90 programs) read/write statements need be changed. Six
implementations of PSLQ (one-, two- and three-level, regular and multi-pair) are
included, as well as three high-precision quadrature programs. New users are
encouraged to use this package, rather than MPFUN90 or MPFUN77 (see below).

This package contains development files of ARPREC.

%package -n lib%name-devel-doc
Summary: Documentation for ARPREC
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
This package supports a flexible, arbitrarily high level of numeric precision --
the equivalent of hundreds or even thousands of decimal digits (up to
approximately ten million digits if needed). Special routines are provided for
extra-high precision (above 1000 digits). The entire library is written in C++.
High-precision real, integer and complex datatypes are supported. Both C++ and
Fortran-90 translation modules modules are also provided that permit one to
convert an existing C++ or Fortran-90 program to use the library with only minor
changes to the source code. In most cases only the type statements and (in the
case of Fortran-90 programs) read/write statements need be changed. Six
implementations of PSLQ (one-, two- and three-level, regular and multi-pair) are
included, as well as three high-precision quadrature programs. New users are
encouraged to use this package, rather than MPFUN90 or MPFUN77 (see below).

This package contains documentation for ARPREC.

%package toolkit
Summary: ARPREC's Experimental Mathematician's Toolkit
Group: Development/Other

%description toolkit
This package supports a flexible, arbitrarily high level of numeric precision --
the equivalent of hundreds or even thousands of decimal digits (up to
approximately ten million digits if needed). Special routines are provided for
extra-high precision (above 1000 digits). The entire library is written in C++.
High-precision real, integer and complex datatypes are supported. Both C++ and
Fortran-90 translation modules modules are also provided that permit one to
convert an existing C++ or Fortran-90 program to use the library with only minor
changes to the source code. In most cases only the type statements and (in the
case of Fortran-90 programs) read/write statements need be changed. Six
implementations of PSLQ (one-, two- and three-level, regular and multi-pair) are
included, as well as three high-precision quadrature programs. New users are
encouraged to use this package, rather than MPFUN90 or MPFUN77 (see below).

This verion of the ARPREC package now includes "The Experimental Mathematician's
Toolkit". This is a complete interactive high-precision arithmetic computing
environment. One enters expressions in a Mathematica-style syntax, and the
operations are performed using the ARPREC package, with a level of precision
that can be set from 100 to 1000 decimal digit accuracy. Variables and vector
arrays can be defined and referenced. This program supports all basic arithmetic
operations, common transcendental and combinatorial functions, multi-pair PSLQ
(one-, two- or three-level versions), high-precision quadrature, i.e. numeric
integration (Gaussian, error function or tanh-sinh), and summation of series.

%prep
%setup

%build
%add_optflags %optflags_shared
%autoreconf
%configure \
	--enable-shared \
	--enable-static=no \
	--enable-qd \
	--enable-fortran \
	--enable-debug
%make_build
#make check
%make cpp-demo fortran-demo toolkit

%install
%makeinstall_std

pushd tests/.libs
for i in $(ls pslq?); do
	mv $i cpp$i
done
popd
install -m755 \
	fortran/.libs/pslq? fortran/.libs/pslqm? fortran/.libs/quaderf \
	fortran/.libs/quad?s fortran/.libs/roots tests/.libs/mp_ex \
	tests/.libs/mp_timer tests/.libs/mpslq? tests/.libs/quads \
	tests/.libs/cpppslq? toolkit/.libs/math???? \
	%buildroot%_bindir

# shared libraries

#pushd %buildroot%_libdir
#mkdir tmp
#pushd tmp
#for i in libarprec libarprec_f_main libarprecmod; do
#	if [ "$i" != "libarprec" ]; then
#		ADDLIB="-L.. -larprec"
#	else
#		ADDLIB=
#	fi
#	ar x ../$i.a
#	f77 -shared *.o $ADDLIB -lqd_f_main -lstdc++ -lc \
#		-Wl,-soname,$i.so.%somver -o ../$i.so.%sover
#	ln -s $i.so.%sover ../$i.so.%somver
#	ln -s $i.so.%somver ../$i.so
#	rm -f *
#done
#popd
#rmdir tmp
#popd

# There is a file in the package with a name starting with <tt>._</tt>, 
# the file name pattern used by Mac OS X to store resource forks in non-native 
# file systems. Such files are generally useless in packages and were usually 
# accidentally included by copying complete directories from the source tarball.
find $RPM_BUILD_ROOT -name '._*' -size 1 -print0 | xargs -0 grep -lZ 'Mac OS X' -- | xargs -0 rm -f
# for ones installed as %%doc
find . -name '._*' -size 1 -print0 | xargs -0 grep -lZ 'Mac OS X' -- | xargs -0 rm -f


%files
%doc AUTHORS ChangeLog COPYING NEWS README* TODO
%_bindir/*
%exclude %_bindir/%name-config
%exclude %_bindir/math*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_bindir/%name-config
%_libdir/*.so
%_includedir/*

%files -n lib%name-devel-doc
%_docdir/%name

%files toolkit
%_bindir/math*

%changelog
