Name: asciidoc
Version: 8.6.8
Release: alt1

Summary: asciidoc converts an AsciiDoc text file to DocBook, HTML or LinuxDoc
Group: Text tools
License: GPLv2+
Url: http://www.methods.co.nz/asciidoc/
Packager: Artem Zolochevskiy <azol@altlinux.ru>
BuildArch: noarch

# http://www.methods.co.nz/asciidoc/%name-%version.tar.gz
Source: %name-%version.tar

Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-vim
%define _unpackaged_files_terminate_build 1
%define docdir %_docdir/%name-%version

BuildRequires: rpm-build-texmf

%description
The asciidoc(1) command translates the AsciiDoc text file to the backend
formatted file.

AsciiDoc is a text document format for writing short documents, articles,
books and UNIX man pages.


%package a2x
Summary: a2x converts AsciiDoc text file to PDF, XHTML, HTML Help, manpage or plain text
Group: Text tools
Requires: %name = %version-%release
Requires: lynx xsltproc docbook-style-xsl dblatex

%description a2x
A DocBook toolchain wrapper script that translates an AsciiDoc text
file to PDF, XHTML (single page or chunked), man page, HTML Help
or plain text formats. PDF, XHTML, man page and HTML Help formats are
generated using the asciidoc(1)/xsltproc(1)/DocBook XSL Stylesheets
toolchain. Plain text is produced by passing asciidoc(1) generated HTML
through lynx(1). The htmlhelp format option generates .hhp, .hhc and
.html files suitable for compilation to an HTML Help .chm file.


%package doc
Summary: AsciiDoc documentation and examples
Group: Development/Documentation

%description doc
The asciidoc(1) command translates the AsciiDoc text file to the backend
formatted file.

AsciiDoc is a text document format for writing short documents, articles,
books and UNIX man pages.

This package contains AsciiDoc documentation and examples.


%package -n vim-plugin-asciidoc-syntax
Summary: Vim syntax highlighting for AsciiDoc files
Group: Editors
PreReq: vim-common

%description -n vim-plugin-asciidoc-syntax
The asciidoc(1) command translates the AsciiDoc text file to the backend
formatted file.

AsciiDoc is a text document format for writing short documents, articles,
books and UNIX man pages.

This package contains AsciiDoc syntax highlighting support for Vim.


%prep
%setup
%patch -p1

%build
%configure docdir=%docdir

%install
%make_install DESTDIR=%buildroot install docs
mv -f %buildroot%_bindir/%name.py %buildroot%_bindir/%name
mv -f %buildroot%_bindir/a2x.py %buildroot%_bindir/a2x
install -pD %buildroot%_sysconfdir/%name/dblatex/asciidoc-dblatex.sty \
  %buildroot%_texmfmain/tex/latex/%name/asciidoc-dblatex.sty

# install vim plugin
install -d %buildroot{%vim_ftdetect_dir,%vim_syntax_dir}
install -p -m644 vim/ftdetect/asciidoc_filetype.vim %buildroot%vim_ftdetect_dir/
install -p -m644 vim/syntax/asciidoc.vim %buildroot%vim_syntax_dir/

# install extra docs for asciidoc package
install -d %buildroot%docdir/
install -pD -m644 COPYRIGHT  %buildroot%docdir/

%files
%_bindir/%name

%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/*.conf
%config(noreplace) %_sysconfdir/%name/dblatex/
%config(noreplace) %_sysconfdir/%name/filters/
%_sysconfdir/%name/images
%_sysconfdir/%name/themes
%config(noreplace) %_sysconfdir/%name/javascripts/
%config(noreplace) %_sysconfdir/%name/stylesheets/

%_man1dir/%name.*
%dir %docdir
%doc %docdir/BUGS
%doc %docdir/CHANGELOG
%doc %docdir/COPYRIGHT
%doc %docdir/README

%files a2x
%_bindir/a2x
%config(noreplace) %_sysconfdir/%name/docbook-xsl/
%_man1dir/a2x.*
%_texmfmain/tex/latex/%name/

%files doc
%doc %docdir
%exclude %docdir/BUGS
%exclude %docdir/CHANGELOG
%exclude %docdir/COPYRIGHT
%exclude %docdir/README

%files -n vim-plugin-asciidoc-syntax
%vim_ftdetect_dir/*.vim
%vim_syntax_dir/*.vim

%changelog
