%define svndate 20061015

Name: astmanproxy
Summary: Asterisk manager proxy
Version: 1.22
Release: alt5.pre.%svndate.2
License: GPL
Group: System/Servers
Epoch: %svndate

Url: http://www.popvox.com/astmanproxy/

Packager: Denis Smirnov <mithraen@altlinux.ru>

Source: %name.tar

# Automatically added by buildreq on Wed May 10 2006
BuildRequires: libssl-devel openssl

Patch1: %name.config.patch
Patch2: %name.pidfile.patch
Patch3: %name.securityfix.patch
Patch4: %name.gmi.patch

Requires(pre): asterisk-base >= 0.6-alt1

%description
%summary

%prep
%setup -c
%patch1 -p0
%patch2 -p0
%patch3 -p1
%patch4 -p1
subst 's!/usr/lib!%_libdir!' Makefile src/dlfcn.c

%build
sed -i 's/^host =/;host =/' configs/astmanproxy.conf
sed -i 's/^\([^;]\)/;\1/' configs/astmanproxy.users 
CFLAGS="%optflags -fPIC -iquote src/include -I/usr/include/openssl -Wall -D_REENTRANT"
subst "s!^CFLAGS:=.*!CFLAGS:=$CFLAGS!" Makefile
%make_build
%install
%make_install install DESTDIR=%buildroot PREFIX=/usr
install -D -m 755 %name-init %buildroot%_initdir/%name
mkdir -p %buildroot/var/run/astmanproxy

%preun
%preun_service astmanproxy
%post
%post_service astmanproxy

%files
%_initdir/%name
%dir %_libdir/%name
%dir %_libdir/%name/modules
%attr(0660,_asterisk,pbxadmin) %config(noreplace) %_sysconfdir/asterisk/astmanproxy.conf
%attr(0660,_asterisk,pbxadmin) %config(noreplace) %_sysconfdir/asterisk/astmanproxy.users
%_libdir/%name/modules/csv.so
%_libdir/%name/modules/http.so
%_libdir/%name/modules/xml.so
%_libdir/%name/modules/standard.so
%_sbindir/%name
%doc README INSTALL TODO VERSIONS
%doc doc/README.*

%changelog
