Name: atftp
Version: 0.7
Release: alt1.qa1

Summary: Advanced Trivial File Transfer Protocol
License: GPLv2+
Group: System/Servers
Conflicts: tftpd

Source: %name-%version-%release.tar

%description
atftp stands for Advanced Trivial File Transfer Protocol. It is called
"advanced", by contrast to others TFTP servers, for two reasons.
Firstly, it is intended to be fully compliant with all related
RFCs. This include RFC1350, RFC2090, RFC2347, RFC2348 and RFC2349.
To my knowledge, there is no TFTP server currently available in the
public domain that fulfills this requirement. Secondly, atftp is
intended for serving boot files to large clusters. It is
multi-threaded and support multicast (RFC2090 and PXE), allowing
faster boot of hundreds of machine simultaneously.

%prep
%setup

%build
%configure --disable-libpcre
make

%install
%makeinstall
install -pm0755 -D atftpd.init %buildroot%_initdir/atftpd
install -pm0644 -D atftpd.sysconfig %buildroot%_sysconfdir/sysconfig/atftpd
mkdir -p %buildroot%_localstatedir/tftpboot
mkdir -pm0770 %buildroot%_runtimedir/atftpd
mkdir -pm0770 %buildroot%_logdir/atftpd
touch %buildroot%_sysconfdir/mtftp.conf
 
%pre
%_sbindir/groupadd -r -f _atftpd &> /dev/null
%_sbindir/useradd -r -g _atftpd -d /dev/null -s /dev/null -c 'ATFTP Service User' -n _atftpd &> /dev/null ||:

%post
%post_service atftpd

%preun
%preun_service atftpd

%files
%doc Changelog BUGS FAQ INSTALL LICENSE README README.CVS 
%doc README.MCAST README.PCRE TODO docs test/mtftp.conf

%config(noreplace) %_sysconfdir/sysconfig/atftpd
%ghost %config(noreplace) %_sysconfdir/mtftp.conf

%_initdir/atftpd

%_bindir/atftp
%_sbindir/atftpd
%_sbindir/in.tftpd

%_man1dir/atftp.1*
%_man8dir/atftpd.8*
%_man8dir/in.tftpd.8*

%dir %_localstatedir/tftpboot
%dir %attr(0770,root,_atftpd) %_logdir/atftpd
%dir %attr(0770,root,_atftpd) %_runtimedir/atftpd

%changelog
