Name: attr
Version: 2.4.46
Release: alt2

Summary: Utilities for managing filesystem extended attributes
License: GPLv2+
Group: File tools
Url: http://savannah.nongnu.org/projects/attr
# git://git.altlinux.org/gears/a/attr.git
Source: %name-%version-%release.tar

Requires: lib%name = %version-%release

%define _libexecdir %_libdir
%def_disable static

%description
A set of tools for manipulating extended attributes on filesystem
objects, in particular getfattr(1) and setfattr(1).
An attr(1) command is also provided which is largely compatible
with the SGI IRIX tool of the same name.

%package -n lib%name
Summary: Dynamic library for extended attribute support
License: LGPLv2+
Group: System/Libraries

%package -n lib%name-devel
Summary: Extended attribute development library and headers files
License: LGPLv2+
Group: Development/C
Requires: lib%name = %version-%release

%package -n lib%name-devel-static
Summary: Static library for extended attribute support
License: LGPLv2+
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name
This package contains the library needed to run programs dynamically
linked with lib%name.

%description -n lib%name-devel
This package contains the development library and header files
needed to develop programs which make use of extended attributes.
For Linux programs, the documented system call API is the
recommended interface, but an SGI IRIX compatibility interface
is also provided.

Currently only ext2, ext3, JFS and XFS support extended attributes.
The SGI IRIX compatibility API built above the Linux system calls is
used by programs such as xfsdump(8), xfsrestore(8) and xfs_fsr(8).

%description -n lib%name-devel-static
This package contains the static library needed to develop
statically linked programs which make use of extended attributes.

%prep
%setup

%build
make configure
%configure %{subst_enable static}
%make_build DEBUG= OPTIMIZER=

%install
make install install-lib install-dev DIST_ROOT=%buildroot

# Workaround bug in makefiles
rm -rf %buildroot%_datadir/doc/%name

# Relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=$(readlink -v "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%find_lang %name

%check
if ./setfattr/setfattr -n user.name -v value .; then
	make tests
else
	echo 'xattrs are probably not supported by the file system'
fi

%files -f %name.lang
%doc README doc/CHANGES.gz
%_bindir/*
%_mandir/man[15]/*

%files -n lib%name
/%_lib/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_mandir/man[23]/*
%_includedir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
