#%define rel -beta4
%define rel %nil
%define oname audacious
Name: audacious-plugins
Version: 3.3.4
Release: alt1

Summary: Plugins for Audacious

License: GPL
Group: Sound
Url: http://audacious-media-player.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://distfiles.audacious-media-player.org/%name-%version%rel.tar

Patch: audacious2-plugins.patch
Patch1: audacious-plugins-1.5.1-gentoo-libmtp.patch

# Sync vorbis with mercurial tip.  Impact: several bugfixes.
# http://redmine.atheme.org/issues/show/102
# http://bugs.debian.org/531835
Patch2: audacious-plugins-2.0.1-vorbis-hg-tip.patch

# Keep mixer open and not start at only 50 percent volume. (thanks, Fedora)
Patch3: audacious-plugins-2.1-keep-mixer-open.patch

Patch4: %name-2.1-alt-fix-build.patch

# From Mandriva:
Patch5: %name-2.1-fix-build.patch
Patch6: audacious-plugins-2.1-beta1-format-strings.patch
Patch7: audacious-plugins-2.1-beta1-linking.patch
Patch8: audacious-plugins-ffmpeg-0.7.1.patch

Requires: %oname = %version

# Automatically added by buildreq on Sun Aug 05 2012
# optimized out: fontconfig fontconfig-devel glib2-devel libX11-devel libXfixes-devel libXrender-devel libalsa-devel libatk-devel libcairo-devel libcairo-gobject libcairo-gobject-devel libdbus-devel libdbus-glib libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libogg-devel libpango-devel libsndfile-devel libstdc++-devel pkg-config termutils xorg-compositeproto-devel xorg-fixesproto-devel xorg-kbproto-devel xorg-renderproto-devel xorg-xproto-devel
BuildRequires: gcc-c++ libSDL-devel libXcomposite-devel libaudacious-devel libbinio-devel libbs2b-devel libcddb-devel libcdio-devel libcue-devel libcurl-devel libdbus-glib-devel libfaad-devel libflac-devel libfluidsynth-devel libgtk+3-devel liblame-devel liblirc-devel libmms-devel libmpg123-devel libneon-devel libnotify-devel libpulseaudio-devel libsamplerate-devel libvorbis-devel libwavpack-devel libxml2-devel zlib-devel

BuildRequires: lib%oname-devel = %version

# wait for altbug #20165
# libsidplay2-devel
BuildRequires: libglade-devel libprojectM-devel >= 1.1

%description
Base plugins for Audacious.
It includes some great other features like various output plugins, last.fm plugins, LIRC support.
This package contains the base I/O plugins:
  * Audio CD reading
  * MPEG support (mp3)
  * Ogg Vorbis support
  * WMA support
  * AAC support
  * FLAC support
  * ALAC support
  * WAVE support
  * ALSA output
  * OSS output
  * Disk writer output

%prep
%setup -n %name-%version%rel
%patch

%build
%configure \
	--enable-amidiplug --enable-sid \
	--enable-gio  \
	--disable-jack --enable-pulse \
%ifnarch x86_64
	--disable-sse2 \
%endif
	--disable-esd
%make_build

%install
%makeinstall_std
%find_lang audacious-plugins

%files -f audacious-plugins.lang
%doc AUTHORS
%_datadir/%oname/
%dir %_libdir/%oname/
%_libdir/%oname/*

%changelog
