Name: audacity
Version: 2.1.1
Release: alt1.0.M70P.1

Summary: Cross-platform audio editor
License: GPL
Group: Sound

Url: http://audacity.sourceforge.net/

# cvs -z3 -d:pserver:anonymous@cvs.sourceforge.net:/cvsroot/audacity co -r audacity-1_3_0-branch audacity
Source0: %name-minsrc-%version.tar
Source2: %name-48x48.xpm
Source3: %name-32x32.xpm
Source4: %name-16x16.xpm
Source6: %name-%version-help-en.tar
Patch0: %name-installmo.patch

Packager: Alex Karpov <karpov@altlinux.ru>

Summary(ru_RU.UTF-8): Кроссплатформенный звуковой редактор

# Automatically added by buildreq on Fri Oct 09 2015
# optimized out: fontconfig fontconfig-devel glib2-devel glibc-devel-static gnu-config libX11-devel libatk-devel libcairo-devel libflac-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libogg-devel libpango-devel libstdc++-devel libwayland-client libwayland-server pkg-config xorg-xproto-devel zlib-devel
BuildRequires: gcc-c++ libalsa-devel libexpat-devel libflac++-devel libgtk+2-devel libid3tag-devel libjack-devel liblame-devel libmad-devel libportaudio2-devel libsndfile-devel libsoundtouch-devel libsoxr-devel libstdc++-devel-static libtwolame-devel libvamp-devel libvorbis-devel libwxGTK-devel

BuildRequires: libopencore-amrnb0 libopencore-amrwb0
BuildRequires: desktop-file-utils shared-mime-info

%description
Audacity is a program that lets you manipulate digital audio waveforms.
It imports many sound file formats, including WAV, AIFF, AU, IRCAM,
MP3, and Ogg Vorbis. It supports all common editing operations such
as Cut, Copy, and Paste, plus it will mix tracks and let you apply
plug-in effects to any part of a sound.

%description -l ru_RU.UTF-8
Audacity - программа, которая дает возможность обрабатывать звукозаписи
в цифровом виде. Она может импортировать множество аудиоформатов, в т.ч.
WAV, AIFF, AU, IRCAM, MP3, Ogg Vorbis, и поддерживает все основные
операции редактирования, такие как Вырезать, Скопировать, Вставить,
а также возможность микширования дорожек и применения эффектов,
предоставляемых подключаемыми модулями, к любой части звука.

%package manual
Summary: Audacity manual (offline install)
Group: Documentation
BuildArch: noarch

%description manual
Audacity Manual can be installed locally if preferred, or accessed
on-line if internet connection is available.

For the most up to date manual content, use the on-line manual.

%prep
%setup -n %name-src-%version
#patch0
grep -Irl "libmp3lame.so" . | xargs sed -i "s/libmp3lame.so/libmp3lame.so.0.0/"

%build
rm -f src/.depend
rm -f src/.gchdepend
# ffmpeg: http://forum.audacityteam.org/viewtopic.php?f=19&t=71586
%configure \
	--disable-dynamic-loading \
	--with-expat=system \
	--without-ffmpeg \
	--with-lame=system \
	--with-libflac=system \
	--with-libid3tag=system \
	--with-libmad=system \
	--without-libresample \
	--without-libsamplerate \
	--with-libsndfile=system \
	--with-libtwolame=system \
	--with-libvamp=system \
	--with-libvorbis=system \
	--with-soundtouch=system \
	#
	#--enable-unicode=yes \
	#--with-portmixer=no
	#--with-portaudio=system \
	#--with-libsoxr=system \
	#--with-sbsms=system \
	#
%make

%install
%makeinstall_std
install -pDm644 %SOURCE2 %buildroot%_liconsdir/%name.xpm
install -pDm644 %SOURCE3 %buildroot%_niconsdir/%name.xpm
install -pDm644 %SOURCE4 %buildroot%_miconsdir/%name.xpm
mkdir %buildroot%_datadir/%name/help
tar -xf %SOURCE6 -C %buildroot%_datadir/%name/help/
rm -rf %buildroot%_defaultdocdir/%name
%find_lang %name

%files -f %name.lang
%doc *.txt
%doc lib-src/libnyquist/nyquist/license.txt
%doc lib-src/libnyquist/nyquist/Readme.txt
%_bindir/*
%_mandir/man?/*
%_iconsdir/*/*/apps/%name.*
%_liconsdir/*
%_niconsdir/*.xpm
%_miconsdir/*
%dir %_datadir/%name
%_datadir/%name/*.xml
%_datadir/%name/nyquist
%_datadir/%name/plug-ins
%_datadir/applications/%name.desktop
%_datadir/mime/packages/%name.xml
%_datadir/appdata/audacity.appdata.xml
%_pixmapsdir/*.xpm

%files manual
%dir %_datadir/%name
%_datadir/%name/help

%changelog
