%def_enable static

Name: audiofile
Version: 0.3.2
Release: alt3.qa1

Summary: Library to handle various audio file formats
License: LGPL
Group: System/Libraries
Url: http://www.68k.org/~michael/%name

Source: %url/%name-%version.tar.xz

Requires: lib%name = %version-%release

BuildRequires: gcc-c++ glibc-devel-static libalsa-devel

%package -n lib%name
Summary: Shared library for %name
Group: System/Libraries

%package -n lib%name-devel
Summary: Includes and other files to develop %name applications
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel

%package -n lib%name-devel-static
Summary: Static libraries to develop %name applications
Group: Development/C
Requires: lib%name-devel = %version-%release

%description
The Audio File Library handles reading and writing audio files in many
common formats.

Key goals of the Audio File Library are file format transparency and data
format transparency. The same calls for opening a file, accessing and
manipulating audio metadata (e.g. sample rate, sample format, textual
information, MIDI parameters), and reading and writing sample data will
work with any supported audio file format. Likewise, the format of the
audio data presented to the application need not be tied to the format
of the data contained in the file.

The following file formats are currently supported:
* AIFF/AIFF-C
* WAVE
* NeXT .snd/Sun .au
* Berkeley/IRCAM/CARL Sound File
* Audio Visual Research
* Amiga IFF/8SVX
* Creative Voice File
* NIST SPHERE
* Core Audio Format

The following compression formats are currently supported:
* G.711 mu-law and A-law
* IMA ADPCM
* Microsoft ADPCM

%description -n lib%name
This package contains the library needed to run programs dynamically
linked with audiofile.

%description -n lib%name-devel
Include files and other resources you can use to develop
%name applications.

%description -n lib%name-devel-static
Static libraries you can use to develop
%name applications.

%prep
%setup -q

sed -ri \
	's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' \
	ltmain.sh *.m4 configure

%build
%configure \
	--enable-largefile \
	%{subst_enable static}
%make_build

%install
%makeinstall

%files
%_bindir/sfconvert
%_bindir/sfinfo
%doc README ACKNOWLEDGEMENTS TODO NEWS NOTES

%files -n lib%name
%_libdir/*.so.*
%_man1dir/*

%files -n lib%name-devel
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*
%_man3dir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
