Name: audit
Version: 2.2.3
Release: alt1

Packager: Anton Farygin <rider@altlinux.com>

Summary: User space tools for 2.6 kernel auditing

License: GPL
Group: Monitoring
URL: http://people.redhat.com/sgrubb/audit/
Source: %name-%version.tar
Patch0: %name-%version-%release.patch

Requires: lib%{name}1 = %version-%release

# Automatically added by buildreq on Wed Mar 04 2009
BuildRequires: glibc-devel-static libkrb5-devel libldap-devel perl-XML-Parser python-devel swig libprelude-devel intltool

%description
The audit package contains the user space utilities for
storing and searching the audit records generate by
the audit subsystem in the Linux 2.6 kernel.

%package -n lib%{name}1
Summary: Dynamic library for audit framework
License: LGPL
Group: System/Libraries
Provides: lib%name = %version-%release
Obsoletes: libaudit = 2.0.4-alt1

%description -n lib%{name}1
This package contains the dynamic libraries needed for
applications to use the audit framework.

%package -n libauparse0
Summary: Dynamic library for audit framework
License: LGPL
Group: System/Libraries
Conflicts: lib%name = 2.0.4-alt1
Conflicts: lib%name < 1.7.16-alt2

%description -n libauparse0
This package contains the dynamic libraries needed for
applications to use the audit framework.

%package -n lib%name-devel
Summary: Header files and static library for libaudit
License: LGPL
Group: Development/C
Requires: lib%{name}1 = %version-%release
Requires: libauparse0 = %version-%release

%description -n lib%name-devel
This package contains the static libraries and header
files needed for developing applications that need to use the audit
framework libraries.

%package -n python-module-%name
Summary: Python bindings for libaudit
License: LGPL
Group: Development/Python
Requires: lib%{name}1 = %version-%release

%description -n python-module-%name
The python-module-%name package contains the bindings so that libaudit
and libauparse can be used by python.

%prep
%setup -q
%patch0 -p1

%build
%autoreconf

%configure --sbindir=/sbin --libdir=/%_lib --disable-static --with-prelude

%make_build CFLAGS=-D_GNU_SOURCE

%install
make DESTDIR=%buildroot install

install -d %buildroot%_logdir/%name
install -d %buildroot%_sysconfdir/audispd/plugins.d
install -d %buildroot/%_libdir/%name

#move development part to libdir
install -d %buildroot%_libdir
for i in libaudit libauparse;do
LIBNAME=$(readlink %buildroot/%_lib/$i.so)
ln -s  /%_lib/${LIBNAME##*/}  %buildroot/%_libdir/$i.so
done

#replace init script
install -Dpm755 %name.init %buildroot/%_initdir/%{name}d

#install rotate script
install -Dpm755 %name.cron %buildroot/%_sysconfdir/cron.weekly/%{name}d

install -pD -m644 init.d/%{name}d.service %buildroot%_unitdir/%{name}d.service

%post
%post_service %{name}d

%preun
%preun_service %{name}d

%files
%doc README ChangeLog contrib
%config(noreplace) %_sysconfdir/cron.weekly/%{name}d
%_initdir/%{name}d
%attr(700,root,root) %_logdir/%name
%config %_unitdir/%{name}d.service

/sbin/ausearch
/sbin/aureport
%_bindir/auvirt
%attr(750,root,root) /sbin/auditctl
%attr(750,root,root) /sbin/auditd
%attr(750,root,root) /sbin/autrace
%attr(750,root,root) /sbin/audispd
%attr(750,root,root) /sbin/audisp-remote
%attr(750,root,root) /sbin/audisp-prelude
%attr(750,root,root) /sbin/audispd-zos-remote
%attr(750,root,root) %_bindir/aulastlog
%attr(750,root,root) %_bindir/aulast
%attr(750,root,root) %_bindir/ausyscall


%_man5dir/*
%_man8dir/*
%_man7dir/*

%attr(700,root,root) %dir %_sysconfdir/%name
%config(noreplace) %attr(600,root,root) %_sysconfdir/%name/auditd.conf
%config(noreplace) %attr(600,root,root) %_sysconfdir/%name/audit.rules

%attr(700,root,root) %dir %_sysconfdir/audispd
%config(noreplace) %attr(640,root,root) /etc/audisp/*.conf

%attr(700,root,root) %dir %_sysconfdir/audispd/plugins.d
%config(noreplace) %attr(640,root,root) /etc/audisp/plugins.d/*.conf

%attr(700,root,root) %dir %_libdir/audit



%files -n lib%{name}1
/%_lib/libaudit.so.*
%config(noreplace) %attr(600,root,root) /etc/libaudit.conf

%files -n libauparse0
/%_lib/libauparse.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_man3dir/*

%files -n python-module-%name
%python_sitelibdir/*

%changelog
