Name: auth_ldap
Version: 1.6.1
Release: alt1.1.1.qa1

Summary: This is a LDAP authentication module for Apache
Summary(ru_RU.KOI8-R):   LDAP-  Apache
Group: System/Servers
License: GPL
Url: http://www.rudedog.org/auth_ldap/

Packager: Volkov Serge <vserge@altlinux.ru>

%define apache_moddocdir /var/www/html/addon-modules
%define httpd_conf %_sysconfdir/httpd/conf/httpd.conf

Source: http://www.rudedog.org/auth_ldap/auth_ldap-%version.tar.bz2
#Patch0: auth_ldap-1.4.7-Makefile.patch
Patch1: auth_ldap-1.6.0-Makefile_in.patch
Patch2: auth_ldap-1.6.0-configure_in.patch

Requires: apache

BuildPreReq: autoconf_2.13
# Automatically added by buildreq on Tue Jan 28 2003
BuildRequires: apache-devel libdb1 libgdbm libldap-devel libmm

%description
This is an authentication module for Apache that allows you to authenticate
HTTP clients using user entries in an LDAP directory.

%description -l ru_RU.KOI8-R
   - Apache;   
HTTP-,     LDAP-.

%prep
%setup -q
# %patch0 -p0
%patch1 -p1
%patch2 -p1
#For name module
mv auth_ldap.c mod_auth_ldap.c

%build
%set_autoconf_version 2.13

EXTRA_CFLAGS="$RPM_OPT_FLAGS"
export EXTRA_CFLAGS

%undefine __libtoolize
autoconf
# New in 1.6.0
%configure \
	--with-apxs=/usr/sbin/apxs \
	--with-ldap-sdk=openldap \
	--with-shared-cache

%make_build

%install
mkdir -p $RPM_BUILD_ROOT%_libdir/apache
# install ROOT=$RPM_BUILD_ROOT see Makefile.in
%makeinstall ROOT=$RPM_BUILD_ROOT LIBDIR=%_libdir

%post
ln -snf %_docdir/%name-%version %apache_moddocdir/%name
%_sbindir/apxs -e -a -n auth_ldap mod_auth_ldap.so >/dev/null 2>/dev/null
#workaround apxs wrong changes
if [ -f %httpd_conf ]; then
	grep -q "ldap_auth_module" %httpd_conf && \
	%__subst "s/ldap_auth_module/auth_ldap_module/" %httpd_conf
fi
%_sbindir/apachectl update

%preun
if [ $1 = 0 ]; then
    %_sbindir/apxs -e -A -n auth_ldap mod_auth_ldap.so >/dev/null 2>/dev/null
	#workaround apxs wrong changes
	if [ -f %httpd_conf ]; then
		grep -q "^LoadModule auth_ldap_module" %httpd_conf && \
		%__subst "/^LoadModule auth_ldap_module/d" %httpd_conf
	fi
	%_sbindir/apachectl update
    %__rm -f %apache_moddocdir/%name
fi

%files
%_libdir/apache/mod_auth_ldap.so
%doc *.html PROBLEMS

%changelog
