%define realname autoconf
%define dialect _2.13
%define suff -2.13

Name: %realname%dialect
Version: 2.13
Release: alt11
Serial: 2

%set_compress_method gzip

Summary: A GNU tool for automatically configuring source code
License: GPLv2+
Group: Development/Other
Url: http://www.gnu.org/software/%realname/
Packager: Dmitry V. Levin <ldv@altlinux.org>
BuildArch: noarch

%define srcname %realname-%version
Source: ftp://ftp.gnu.org/gnu/%realname/%srcname.tar.bz2
Source1: %realname-2.13-manpages.tar

Patch1: %realname-2.13-alt-tmp.patch
Patch2: %realname-2.13-alt-c++exit.patch
Patch3: %realname-2.13-alt-headers.patch
Patch4: %realname-2.13-alt-autoscan.patch
Patch5: %realname-2.13-alt-exit.patch
Patch6: %realname-2.13-alt-noelf.patch
Patch7: %realname-2.13-alt-texinfo.patch
Patch8: %realname-2.13-alt-acdatadir.patch
Patch9: %realname-2.13-alt-dnet.patch
Patch10: %realname-2.13-alt-ac_extension.patch

Provides: %realname = %serial:%version-%release
Obsoletes: %realname

PreReq: autoconf-common, alternatives >= 0:0.4
Requires: m4 >= 1.4, mktemp >= 1:1.3.1

%description
GNU's Autoconf is a tool for configuring source code and Makefiles.
Using Autoconf, programmers can create portable and configurable
packages, since the person building the package is allowed to
specify various configuration options.

You should install Autoconf if you are developing software and you'd
like to use it to create shell scripts which will configure your
source code packages. If you are installing Autoconf, you will also
need to install the GNU m4 package.

Note that the Autoconf package is not required for the end user who
may be configuring software with an Autoconf-generated script;
Autoconf is only required for the generation of the scripts, not
their use.

%prep
%setup -q -n %srcname -a1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1

find -type f -print0 |
	xargs -r0 grep -FZl 'mawk gawk' |
	xargs -r0 sed -i 's/mawk gawk/gawk mawk/g'

# patch texinfo file
sed -i 's/(%realname)/(%realname%suff)/g;s/\(\* \([Aa]utoconf\|configure\)\):/\1%suff:/g' %realname.texi

%build
%configure --program-suffix=%suff
%make_build

%install
%makeinstall

# We don't want to include the standards.info stuff in the package,
# since it comes from binutils.
rm %buildroot%_infodir/standards*

# Install manpages.
for f in [a-z]*.1; do
	install -pD -m644 "$f" "%buildroot%_man1dir/${f%%.1}%suff.1"
done

# Some more helpful scripts.
install -pm755 *-sh %buildroot%_datadir/%realname%suff/
rm -f %buildroot%_datadir/%realname%suff/INSTALL

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

mv %buildroot%_infodir/%realname.info %buildroot%_infodir/%realname%suff.info

%if 0
# rename binaries
for f in %buildroot%_bindir/*; do
	sed -e's@%_datadir/%realname@%_datadir/%realname%suff@' <"$f" >"${f}%suff"
	rm "$f"
	chmod a+x "${f}%suff"
done
# rename man files
for f in %buildroot%_man1dir/*; do
	mv $f ${f%%.1}%suff.1
done
%endif

for f in %buildroot%_bindir/*%suff; do
	ln -s "${f##*/}" "${f%%%suff}%dialect"
done

mkdir -p %buildroot%_altdir

cat >%buildroot%_altdir/%name <<EOF
%_bindir/%realname-default	%_bindir/%realname%suff	20
%_datadir/%realname	%_datadir/%realname%suff	%_bindir/%realname%suff
%_infodir/%realname.info.gz	%_infodir/%realname%suff.info.gz	%_bindir/%realname%suff
EOF

for i in autoheader autom4te autoreconf autoscan autoupdate ifnames; do
cat >>%buildroot%_altdir/%name <<EOF
%_bindir/$i-default	%_bindir/$i%suff	%_bindir/%realname%suff
EOF
done

for i in %realname autoheader autom4te autoreconf autoscan autoupdate config.guess config.sub ifnames; do
cat >>%buildroot%_altdir/%name <<EOF
%_man1dir/$i.1.gz	%_man1dir/$i%suff.1.gz	%_bindir/%realname%suff
EOF
done

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%_altdir/*
%_bindir/*
%_datadir/%realname%suff
%_man1dir/*
%_infodir/*.info*
%doc AUTHORS NEWS README TODO

%changelog
