%define realname autoconf
%define dialect _2.60
%define suff -2.60

Name: %realname%dialect
Version: 2.68
Release: alt3
Epoch: 2

Summary: A GNU tool for automatically configuring source code
License: GPLv2+
Group: Development/Other
Url: http://www.gnu.org/software/%realname/
BuildArch: noarch

%set_compress_method gzip
%define srcname %realname-%version-%release
%define __spec_autodep_custom_pre export autom4te_perllibdir=%buildroot%_datadir/%realname%suff

# git://git.altlinux.org/gears/a/autoconf_2.60.git
Source: %srcname.tar

Provides: %realname = %epoch:%version-%release
Obsoletes: %realname

PreReq: autoconf-common, alternatives >= 0:0.4
# GNU m4 version 1.4.6 or later is required; 1.4.14 or later is recommended.
Requires: m4 >= 1.4.14
# portable mktemp, later obsoleted by coreutils.
Requires: mktemp >= 1:1.3.1

BuildRequires: help2man, alternatives >= 0:0.4
%{!?__buildreqs:%{!?_without_check:%{!?_disable_check:BuildRequires: gcc-c++ gcc-g77 libgomp-devel}}}

%description
GNU's Autoconf is a tool for configuring source code and Makefiles.
Using Autoconf, programmers can create portable and configurable
packages, since the person building the package is allowed to
specify various configuration options.

You should install Autoconf if you are developing software and you'd
like to use it to create shell scripts which will configure your
source code packages.  If you are installing Autoconf, you will also
need to install the GNU m4 package.

Note that the Autoconf package is not required for the end user who
may be configuring software with an Autoconf-generated script;
Autoconf is only required for the generation of the scripts, not
their use.

%prep
%setup -n %srcname
find -type f -print0 |
	xargs -r0 fgrep -lZ @RPM_AUTOCONF_SUFFIX@ -- |
	xargs -r0 sed -i s,@RPM_AUTOCONF_SUFFIX@,%suff, --

find -type f -print0 |
	xargs -r0 grep -FZl 'mawk gawk' -- |
	xargs -r0 sed -i 's/mawk gawk/gawk mawk/g' --

# patch texinfo file
sed -i '/@direntry/,/@end direntry/ s/^\(\*[[:space:]]\+[[:alnum:].-]\+\)\(:[[:space:]]\+\)(%realname)/\1%suff\2(%realname%suff)/' \
	doc/autoconf.texi

# Build scripts expect to find autoconf version in this file.
echo -n %version > .tarball-version

%build
export ac_cv_prog_EMACS=no
autoreconf -iv
%configure --program-suffix=%suff
%make_build

%install
%makeinstall

# We don't want to include the standards.info stuff in the package,
# since it comes from binutils.
rm -f %buildroot%_infodir/standards*

# Some more helpful scripts.
rm -f %buildroot%_datadir/%realname/INSTALL
mv %buildroot%_datadir/%realname %buildroot%_datadir/%realname%suff

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

mv %buildroot%_infodir/%realname.info %buildroot%_infodir/%realname%suff.info

for f in %buildroot%_bindir/*%suff; do
	ln -s "${f##*/}" "${f%%%suff}%dialect"
done

%define _perl_lib_path %perl_vendor_privlib:%_datadir/%realname%suff

mkdir -p %buildroot%_altdir

cat >%buildroot%_altdir/%name <<EOF
%_bindir/%realname-default	%_bindir/%realname%suff	40
%_datadir/%realname	%_datadir/%realname%suff	%_bindir/%realname%suff
%_infodir/%realname.info.gz	%_infodir/%realname%suff.info.gz	%_bindir/%realname%suff
EOF

for i in autoheader autom4te autoreconf autoscan autoupdate ifnames; do
cat >>%buildroot%_altdir/%name <<EOF
%_bindir/$i-default	%_bindir/$i%suff	%_bindir/%realname%suff
EOF
done

for i in %realname autoheader autom4te autoreconf autoscan autoupdate config.guess config.sub ifnames; do
cat >>%buildroot%_altdir/%name <<EOF
%_man1dir/$i.1.gz	%_man1dir/$i%suff.1.gz	%_bindir/%realname%suff
EOF
done

%check
%make_build -k check

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%_altdir/*
%_bindir/*
%_datadir/%realname%suff
%_man1dir/*
%_infodir/*.info*
%doc AUTHORS NEWS README TODO

%changelog
