%define realname automake
%define dialect _1.10
%define dialect_regex _1\\.10
%define suff -1.10
%define altver 1101

Name: %realname%dialect
Version: 1.10.3
Release: alt2
Epoch: 1

%add_findreq_skiplist %_datadir/%realname%suff/config.guess
%set_compress_method gzip
%define _perl_lib_path %perl_vendor_privlib:%_datadir/%realname%suff
%{?filter_from_requires:%filter_from_requires /^perl(Automake/d}
%{?filter_from_provides:%filter_from_provides /^perl(Automake/d}

Summary: A GNU tool for automatically creating Makefiles
License: GPLv2+
Group: Development/Other
Url: http://www.gnu.org/software/automake/
BuildArch: noarch

%define srcname %realname-%version-%release

# ftp://ftp.gnu.org/gnu/%realname/%srcname.tar.bz2
Source: %srcname.tar

Provides: %realname = %epoch:%version-%release
Provides: aclocal(libtool)
Obsoletes: %realname
PreReq: automake-common, alternatives >= 0:0.4
Requires: autoconf_2.60

BuildPreReq: autoconf >= 2:2.58, texinfo >= 4.7

%description
Automake is a tool for automatically generating Makefiles compliant
with the GNU Coding Standards.

You should install Automake if you are developing software and would
like to use its capabilities of automatically generating GNU standard
Makefiles.  If you install Automake, you will also need to install
GNU Autoconf package.

%prep
%setup -n %srcname
bzip2 -9fk ChangeLog NEWS TODO

# patch texinfo file
sed -i '/@direntry/,/@end direntry/ s/^\(\*[[:space:]]\+[[:alnum:].]\+\)\(:[[:space:]]\+\)(%realname)/\1%suff\2(%realname%suff)/' \
	doc/automake.texi

%build
%define docdir %_docdir/%realname-%version
%configure --docdir=%docdir
%make_build MAKEINFOFLAGS=--no-split

%check
%make_build -k check

%install
%makeinstall_std MAKEINFOFLAGS=--no-split

mv %buildroot%_infodir/%realname.info %buildroot%_infodir/%realname%suff.info

mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat <<EOF >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
^/usr/share/aclocal(%dialect_regex)?/.+\.m4$
EOF

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

mkdir -p %buildroot%_altdir
cat <<EOF >%buildroot%_altdir/%name
%_bindir/%realname-default	%_bindir/%realname%suff	%altver
%_bindir/aclocal-default	%_bindir/aclocal%suff	%_bindir/%realname%suff
%_datadir/%realname	%_datadir/%realname%suff	%_bindir/%realname%suff
%_infodir/%realname.info.gz	%_infodir/%realname%suff.info.gz	%_bindir/%realname%suff
EOF

install -pm644 AUTHORS README THANKS ChangeLog.bz2 NEWS.bz2 TODO.bz2 \
	%buildroot%docdir/

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/*
%_altdir/%name
%_bindir/*%suff
%_datadir/aclocal%suff
%_datadir/%realname%suff
%_infodir/*.info*
%docdir

%changelog
