%define realname automake
%define dialect _1.9
%define dialect_regex _1\\.9
%define suff -1.9
%define altver 195

Name: %realname%dialect
Version: 1.9.6
Release: alt4
Epoch: 1

%add_findreq_skiplist %_datadir/%realname%suff/config.guess
%set_compress_method gzip
%define _perl_lib_path %perl_vendor_privlib:%_datadir/%realname%suff

Summary: A GNU tool for automatically creating Makefiles
License: GPLv2+
Group: Development/Other
Url: http://www.gnu.org/software/automake/
BuildArch: noarch

%define srcname %realname-%version

# ftp://ftp.gnu.org/gnu/%realname/%srcname.tar.bz2
Source: %srcname.tar
Source1: automake-1.9-objc.m4

Patch0: automake-1.9.5-alt-objc.patch
Patch1: automake-1.9.5-alt-texinfo.patch
Patch2: automake-1.9.5-alt-aclocal-libtool.patch
Patch3: automake-1.9.5-cvs-20070722-tests.patch
Patch4: automake-1.9.6-git-20091129.patch
Patch5: automake-1.9.6-git-20091201.patch

Provides: %realname = %epoch:%version-%release
Provides: aclocal(libtool)
Obsoletes: %realname
PreReq: automake-common, alternatives >= 0:0.4
Requires: autoconf_2.5 >= 2:2.58

BuildPreReq: autoconf >= 2:2.58, texinfo >= 4.7

%description
Automake is a tool for automatically generating Makefiles compliant
with the GNU Coding Standards.

You should install Automake if you are developing software and would
like to use its capabilities of automatically generating GNU standard
Makefiles.  If you install Automake, you will also need to install
GNU Autoconf package.

%prep
%setup -n %srcname
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
install -pm644 %SOURCE1 m4/objc.m4
bzip2 -9fk ChangeLog NEWS TODO

%build
# prevent very recent configure from running "config.sub noarch-alt-linux".
%undefine _configure_target
%configure
%make_build MAKEINFOFLAGS=--no-split

%check
%make_build -k check

%install
%makeinstall_std MAKEINFOFLAGS=--no-split

mv %buildroot%_infodir/%realname.info %buildroot%_infodir/%realname%suff.info

mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat <<EOF >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
^/usr/share/aclocal(%dialect_regex)?/.+\.m4$
EOF

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

mkdir -p %buildroot%_altdir
cat <<EOF >%buildroot%_altdir/%name
%_bindir/%realname-default	%_bindir/%realname%suff	%altver
%_bindir/aclocal-default	%_bindir/aclocal%suff	%_bindir/%realname%suff
%_datadir/%realname	%_datadir/%realname%suff	%_bindir/%realname%suff
%_infodir/%realname.info.gz	%_infodir/%realname%suff.info.gz	%_bindir/%realname%suff
EOF

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/*
%_altdir/%name
%_bindir/*%suff
%_datadir/aclocal%suff
%_datadir/%realname%suff
%_infodir/*.info*
%doc AUTHORS README THANKS ChangeLog.bz2 NEWS.bz2 TODO.bz2

%changelog
