%define realversion 1.0a16

Name: avinfo
Version: 1.0
Release: alt2.a17

Summary: AVInfo is a utility for output information about AVI files
Summary(ru_RU.KOI8-R): AVInfo -      AVI 
Group: Video
License: GPL
URL: http://www.shounen.ru/soft/avinfo/

Source: %url/avinfo-%realversion.zip
Patch: avinfo-1.0-gcc3.4.patch
Patch1:  avinfo-1.0-config.h.patch
Patch2:  avinfo-1.0-gcc4.patch
Patch3:  avinfo-1.0-alt-no-yyparse.patch

# Automatically added by buildreq on Mon Feb 28 2005
BuildRequires: unzip

BuildPreReq: flex

%description
AVInfo is a utility for displaying AVI header information. It returns the
length of a clip, FPS, resolution, codec, sound parametrs, and the number
and type of streams, including detailed information for each.

%description -l ru_RU.KOI8-R
AVInfo -           
avi . ,   ,  
   ,    .
         
  . ,  -    
   .
     -     
  -         .

%prep
%setup -q -c %name-%realversion
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p2
find -type f -print0 | xargs -r0 sed -i 's,
,,g 
s,,,g'

%build
mkdir -p doc
%define win_files readme.rus.txt whatsnew.rus
for f in %win_files; do
iconv -c -s -f windows-1251 -t koi8-r -o doc/$f $f || :
sed -i 's| Windows-1251 codepage, CRLF text||' doc/$f
done

pushd src
sed -i 's/-DMAKEFILE_WIN/-DCFG_PATH_STYLE_UNIX/g' Makefile
#make_build CXX="g++ -fpermissive %optflags"
%add_optflags -DYYPARSE_PARAM=lexer_ctl
%make_build CXX="gcc %optflags"
popd

%install
install -pD src/%name %buildroot%_bindir/%name
install -pD -m644 src/avinfo.tpl %buildroot%_sysconfdir/%name/templates
install -pD -m644 src/avinfo.cfg %buildroot%_sysconfdir/%name/default.conf

%files
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/templates
%config(noreplace) %_sysconfdir/%name/default.conf
%_bindir/*
%doc doc/* CHANGELOG

%changelog
