# -*- rpm-spec -*-
# $Id: avr-binutils,v 1.11 2003/09/05 11:18:56 grigory Exp $

#define snapshot_version 030512
%define cross_arch avr

Summary: A GNU collection of binary utilities.
Name: %cross_arch-binutils
Version: 2.23.51.0.8
Release: alt1
Serial: 1
Copyright: GPL
Group: Development/Other
URL: ftp://ftp.kernel.org/pub/linux/devel/binutils/
Source: binutils-%version.tar.bz2
Patch0: patch-coff-avr-2.20.51.0.9.patch
Patch1: 30-binutils-2.20.1-avr-size.patch
#Patch0: binutils-%version-info_fix.diff

%define libavrdir %_libdir/%cross_arch
%define includeavrdir %_includedir/%cross_arch

# Automatically added by buildreq on Mon Nov 29 2010
BuildRequires: avr-gcc-c++ expect flex gcc-c++ glibc-devel-static perl-Pod-Parser zlib-devel

%description
Avr-Binutils is a collection of binary utilities, including avr-ar (for
creating, modifying and extracting from archives), avr-as (a family of GNU
assemblers), avr-ld (the GNU linker), avr-nm (for listing symbols from object
files), avr-objcopy (for copying and translating object files), avr-objdump
(for displaying information from object files), avr-ranlib (for generating an
index for the contents of an archive), avr-size (for listing the section sizes
of an object or archive file), avr-strings (for listing printable strings from
files), avr-strip (for discarding symbols), and avr-addr2line (for converting
addresses to file and line).

This package is for cross-development of AVR programs.

%prep
%setup -n binutils-%version -q
%patch1
#%patch0 -p1
#%patch0 -p1 -b .avrinfo

%build
# Binutils come with its own custom libtool
%define __libtoolize echo
./configure \
	--prefix=%_prefix \
	--mandir=%_mandir \
	--infodir=%_infodir \
	--includedir=%includeavrdir \
	--libdir=%libavrdir \
	--exec-prefix=%libavrdir \
	--disable-nls \
	--target=avr \
	--program-prefix="avr-" \
	--enable-languages="c,c++"
%make_build

%install
%__mkdir_p %buildroot{%libavrdir/bin,%includeavrdir,%_bindir}

%makeinstall \
	prefix=%buildroot%_prefix \
	exec_prefix=%buildroot%libavrdir \
	libdir=%buildroot%libavrdir \
	includedir=%buildroot%includeavrdir \
	mandir=%buildroot%_mandir
%__make install-info \
	prefix=%buildroot%_prefix \
	infodir=%buildroot%_infodir

%__mv %buildroot%_bindir/* %buildroot%libavrdir/bin/
for i in `ls -1 %buildroot%libavrdir/bin/`; do
	%__ln_s ../..%libavrdir/bin/$i %buildroot%_bindir/$i
done
for i in `ls -1 %buildroot%libavrdir/%cross_arch/bin/`; do
	%__ln_s %cross_arch-$i %buildroot%libavrdir/bin/$i
done
%__rm -rf %buildroot%libavrdir/%cross_arch/bin

%__ln_s ../bin %buildroot%libavrdir/avr/bin
%__ln_s ./ %buildroot%libavrdir/lib
%__ln_s ../../..%includeavrdir %buildroot%libavrdir/include

%__rm -f %buildroot%_bindir/*c++filt*
%__rm -fr %buildroot%_infodir

%__ln_s %_libdir/%cross_arch %buildroot%_prefix/%cross_arch

%__rm -f %buildroot/usr/lib64/lib64/libiberty.a

%files
%doc README
%includeavrdir
%libavrdir
%_bindir/*
%libavrdir/*
%_prefix/%cross_arch
%_man1dir/*

%changelog
