%def_enable docs
%def_disable boo
%def_enable mtp
%def_enable appledevice
%def_enable daap
%def_enable podcast
%def_enable video
%def_disable moonlight
%def_enable webkit
%def_enable notify
%def_disable torrent
%def_enable nunit
%def_disable clutter
%def_enable youtube
%def_enable gio
%def_disable upnp

Name: banshee
Version: 2.6.0
Release: alt1
Summary: Easily import, manage, and play selections from your music collection
Group: Sound
License: MIT
Url: http://banshee.fm/

Source0: %name-%version.tar
Source2: hyena.tar
Patch0: %name-%version-%release.patch

# workaround for gnome-do-plugin-banshee
Provides: mono(Banshee.CollectionIndexer) = 2.3.0.0

BuildPreReq: lsb-core rpm-build-mono
# From configure.in and build/m4/banshee
BuildPreReq: intltool >= 0.35.0
BuildPreReq: libgtk+2-devel >= 2.22
BuildPreReq: gnome-doc-utils
BuildPreReq: libgnome-desktop-devel >= 2.28
BuildPreReq: gstreamer-devel >= 0.10.26
BuildPreReq: gst-plugins-devel >= 0.10.26
BuildPreReq: mono-devel >= 2.4.3
BuildPreReq: mono-data mono-data-sqlite
BuildPreReq: mono-web-devel
BuildPreReq: dbus-sharp-devel >= 0.7
BuildPreReq: dbus-sharp-glib-devel >= 0.5
BuildPreReq: mono-addins-devel >= 0.6.2
%{?_enable_boo:BuildPreReq: boo-devel >= 0.8.1}
%{?_enable_docs:BuildPreReq: monodoc-devel}
%{?_enable_nunit:BuildPreReq: mono-nunit-devel >= 2.4}
BuildPreReq: libtag-sharp-devel >= 2.0.3.7
BuildPreReq: libgtk-sharp2-devel >= 2.12.10
BuildPreReq: libgnome-sharp-devel >= 2.8
BuildPreReq: libsqlite3-devel >= 3.4
%{?_enable_mtp:BuildPreReq: libmtp-devel >= 0.2.0}
%{?_enable_appledevice:BuildPreReq: libgpod-sharp-devel >= 0.1}
%{?_enable_daap:BuildPreReq: mono-zeroconf-devel >= 0.7.3}
%{?_enable_moonlight:BuildPreReq: libmoon-sharp-devel >= 0.8}
%{?_enable_notify:BuildPreReq: libnotify-sharp-devel}
%{?_enable_torrent:BuildPreReq: monotorrent-devel >= 0.2}
%{?_enable_webkit:BuildPreReq: libwebkit-sharp-devel >= 0.2 libwebkitgtk2-devel >= 1.2.2 libsoup-devel >= 2.26 libsoup-gnome-devel >= 2.26}
%{?_enable_video:BuildPreReq: libXrandr-devel >= 1.1.1 libXxf86vm-devel >= 1.0.1}
%{?_enable_clutter:BuildPreReq: libclutter-devel >= 1.0.1}
%{?_enable_youtube:BuildPreReq: libgoogle-data-mono-devel >= 1.4}
%{?_enable_gio:BuildPreReq: libgtk-sharp-beans-devel >= 2.8 libgio-sharp-devel >= 2.22.3 libgudev-sharp-devel >= 0.1 libgkeyfile-sharp-devel >= 0.1}
%{?_enable_upnp:BuildPreReq: mono-upnp-devel >= 0.1}

BuildRequires: GConf libGConf-devel gcc-c++ mono-mcs perl-XML-Parser
BuildRequires: /proc
BuildPreReq: rpm-build-mono rpm-build-gnome desktop-file-utils
PreReq: desktop-file-utils

%description
Banshee allows you to import CDs, sync your music collection to an iPod,
play music directly from an iPod, create playlists with songs from your
library, and create audio and MP3 CDs from subsets of your library.

%package devel
Summary: Development files for Banshee
Group: Development/Other
Requires: %name = %version-%release

%description devel
Development files for Banshee Media Player

%if_enabled docs
%package doc
Summary: Development documentation for %name
Group: Documentation
Provides: %name-monodoc = %version-%release
Obsoletes: %name-monodoc
BuildPreReq: monodoc
Requires: monodoc
BuildArch: noarch

%description doc
This package contains the API documentation for the %name in
Monodoc format.
%endif

%if_enabled appledevice
%package ipod
Group: Sound
Summary: Ipod support for Banshee
Requires: %name = %version-%release

%description ipod
Banshee allows you to import CDs, sync your music collection to an iPod,
play music directly from an iPod, create playlists with songs from your
library, and create audio and MP3 CDs from subsets of your library.

Install this package for iPod support in Banshee.
%endif

%if_enabled mtp
%package mtp
Group: Sound
Summary: MTP audio player support for Banshee
Requires: %name = %version-%release

%description mtp
Banshee allows you to import CDs, sync your music collection to an iPod,
play music directly from an iPod, create playlists with songs from your
library, and create audio and MP3 CDs from subsets of your library.

Install this package for MTP audio player support in Banshee.
%endif

%if_enabled daap
%package daap
Group: Sound
Summary: DAAP audio player support for Banshee
Requires: %name = %version-%release

%description daap
Banshee allows you to import CDs, sync your music collection to an iPod,
play music directly from an iPod, create playlists with songs from your
library, and create audio and MP3 CDs from subsets of your library.

Install this package for DAAP support in Banshee.
%endif

%if_enabled boo
%package boo
Group: Sound
Summary: Boo support for Banshee
Requires: %name = %version-%release

%description boo
Banshee allows you to import CDs, sync your music collection to an iPod,
play music directly from an iPod, create playlists with songs from your
library, and create audio and MP3 CDs from subsets of your library.

Install this package for boo scripts support in Banshee.
%endif

%prep
%setup -q
tar -xf %SOURCE2 -C src/Hyena
%patch0 -p1

%build
intltoolize --force --copy
%__libtoolize --force --copy --automake
ACLOCAL="aclocal -I build/m4/banshee -I build/m4/shamrock -I build/m4/shave"  %autoreconf
%configure \
	--disable-static \
	%{subst_enable boo} \
	%{subst_enable mtp} \
	%{subst_enable appledevice} \
	%{subst_enable daap} \
	%{subst_enable moonlight} \
	%{subst_enable torrent} \
	%{subst_enable clutter} \
	%{subst_enable youtube} \
	%{subst_enable gio} \
	%{subst_enable upnp} \
	%{subst_enable webkit} \
	--disable-schemas-install \
	--enable-user-help \
	--enable-release \
	--with-vendor-build-id="ALTLinux"

# Non-parallel build
%make

%install
%make_install install DESTDIR=%buildroot

desktop-file-install --vendor gnome --delete-original		\
  --remove-category=X-Red-Hat-Base				\
  --remove-category=X-Novell-Main				\
  --remove-category=X-Ximian-Main				\
  --add-category=GTK						\
  --dir %buildroot%_desktopdir			\
%buildroot%_desktopdir/%name.desktop

%find_lang --with-gnome %name

%files -f %name.lang
%doc COPYING AUTHORS README NEWS
%_bindir/*
%_libdir/%name
%_desktopdir/*
%_datadir/dbus-1/services/*
%_datadir/%name
%_iconsdir/hicolor/*/apps/*
%_datadir/mime/packages/*
%exclude %_libdir/%name/*.la
%exclude %_libdir/%name/*/*.la

%if_enabled appledevice
%exclude %_libdir/%name/Extensions/Banshee.Dap.AppleDevice.dll*
%endif
%if_enabled mtp
%exclude %_libdir/%name/Mtp.dll*
%endif
%if_enabled daap
%exclude %_libdir/%name/Extensions/Banshee.Dap.Mtp.dll*
%exclude %_libdir/%name/Extensions/Banshee.Daap.dll*
%endif
%if_enabled boo
%exclude %_libdir/%name/Extensions/Banshee.BooScript.dll*
%endif

%files devel
%_pkgconfigdir/*.pc

%if_enabled docs
%files doc
%_monodocdir/*-docs*
%endif

%if_enabled appledevice
%files ipod
%_libdir/%name/Extensions/Banshee.Dap.AppleDevice.dll*
%endif

%if_enabled mtp
%files mtp
%_libdir/%name/Mtp.dll*
%_libdir/%name/Extensions/Banshee.Dap.Mtp.dll*
%endif

%if_enabled daap
%files daap
%_libdir/%name/Extensions/Banshee.Daap.dll*
%endif

%if_enabled boo
%files boo
%_libdir/%name/Extensions/Banshee.BooScript.dll*
%endif

%changelog
