Name: bind
Version: 9.9.8
Release: alt2.M70P.2

Summary: ISC BIND - DNS server
License: BSD-style
Group: System/Servers
Url: http://www.isc.org/products/BIND/

%define vsuffix -P4
# NOTE: vsuffix removed from Source0
# ftp://ftp.isc.org/isc/bind9/%version%vsuffix/bind-%version%vsuffix.tar.gz
Source0: %name-%version.tar
Source2: rfc1912.txt
Source3: bind.README.bind-devel
Source4: bind.README.ALT

Source11: bind.init
Source12: lwresd.init

Source21: rndc.conf
Source22: rndc.key

Source31: bind.named.conf
Source32: bind.options.conf
Source33: bind.rndc.conf
Source34: bind.local.conf
Source35: bind.rfc1912.conf
Source36: bind.rfc1918.conf
Source37: bind.sysconfig

Source41: bind.localhost
Source42: bind.localdomain
Source43: bind.127.in-addr.arpa
Source44: bind.empty

Source50: bind.service

# NB: there must be at least one patch :)
Patch0001: 0001-bind-9.9.7-owl-warnings.patch
Patch0002: 0002-bind-9.8.3-openbsd-owl-pidfile.patch
Patch0003: 0003-bind-9.9.1-openbsd-owl-chroot-defaults.patch
Patch0004: 0004-bind-9.9.1-alt-owl-chroot.patch
Patch0005: 0005-bind-9.8.3-owl-checkconf-chroot.patch
Patch0006: 0006-bind-9.8.3-alt-man.patch
Patch0007: 0007-bind-9.8.3-alt-owl-rndc-confgen.patch
Patch0008: 0008-bind-9.8.3-alt-nofile.patch
Patch0009: 0009-bind-9.9.1-alt-ads-remove.patch
Patch0010: 0010-bind-9.9.3-fc-exportlib.patch
Patch0011: 0011-Fix-CVE-2016-2776.patch

# root directory for chrooted environment.
%define _chrootdir %_localstatedir/bind

# common directory for documentation.
%define docdir %_docdir/bind-%version

%ifndef timestamp
%define timestamp %(TZ=UTC LC_TIME=C date +%%Y%%m%%d)
%endif

%def_disable static
%def_enable ipv6
%def_with openssl

Provides: bind-chroot(%_chrootdir)
Obsoletes: bind-chroot, bind-debug, bind-slave, caching-nameserver
# Because of /etc/syslog.d/ feature.
Conflicts: syslogd < 1.4.1-alt11
PreReq: bind-control chrooted syslogd-daemon
PreReq: libbind = %version-%release

# due to %_chrootdir/dev/log
BuildPreReq: coreutils

# due to broken configure script
BuildPreReq: gcc-c++

%{?_with_openssl:BuildPreReq: libssl-devel}

%package utils
Summary: Utilities provided by ISC BIND
Group: Networking/Other
Requires: libbind = %version-%release

%package -n libbind
Summary: Shared library used by ISC BIND
Group: System/Libraries
Provides: libdns = %version-%release
Provides: libisc = %version-%release
Provides: libisccc = %version-%release
Provides: libisccfg = %version-%release
Provides: liblwres = %version-%release
Obsoletes: libdns8, libdns9, libdns10, libdns11, libdns16
Obsoletes: libisc4, libisc7, libisccc0, libisccfg0, liblwres1

%package devel
Summary: ISC BIND development libraries and headers
Group: Development/C
Requires: libbind = %version-%release

%package devel-static
Summary: ISC BIND static development libraries
Group: Development/C
Requires: %name-devel = %version-%release

%package -n libisc-export
Summary: ISC BIND exportable libraries to build third party applications with
Group: System/Libraries
# RH compat
Provides: %name-lite

%package -n libisc-export-devel
Summary: ISC BIND development anvironment for exportable libraries
Group: Development/C
Requires: libisc-export = %version-%release
# RH compat
Provides: %name-lite-devel

%package doc
Summary: Documentation for ISC BIND
Group: Development/Other
BuildArch: noarch
Prefix: %prefix

%package -n lwresd
Summary: Lightweight resolver daemon
Group: System/Servers
PreReq: /var/resolv, chkconfig, shadow-utils
Requires: libbind = %version-%release

%description
The Berkeley Internet Name Domain (BIND) implements an Internet domain
name server.  BIND is the most widely-used name server software on the
Internet, and is supported by the Internet Software Consortium (ISC).

This package provides the %version%vsuffix server and related
configuration files.

%description utils
This package contains various utilities related to DNS that are derived
from the BIND %version%vsuffix source tree, including dig, host,
nslookup and nsupdate.

%description -n libbind
This package contains shared libraries used by BIND's %version%vsuffix
daemons and clients.

%description devel
This package contains development libraries, header files, and API man
pages for libdns, libisc, libisccc, libisccfg and liblwres. These are
only needed if you want to compile packages that need more BIND
%version%vsuffix nameserver API than the resolver code provided by
glibc.

%description devel-static
This package contains development static libraries, header files, and
API man pages for libdns, libisc, libisccc, libisccfg and liblwres.
These are only needed if you want to compile statically linked packages
that need more BIND %version%vsuffix nameserver API than the resolver
code provided by glibc.

%description -n libisc-export
This package contains shared libraries used by third-party projects that
require standard ISC BIND %version%vsuffix libaries without using
nameserver API.

%description -n libisc-export-devel
This package contains develompent environment for third-party projects
that require standard ISC BIND %version%vsuffix libaries without using
nameserver API.

%description doc
This package provides various documents that are useful for maintaining
a working BIND %version%vsuffix installation.

%description -n lwresd
This package contains lwresd, the daemon providing name lookup services
to clients that use the BIND %version%vsuffix lightweight resolver
library. It is essentially a stripped-down, caching-only name server
that answers queries using the BIND 9 lightweight resolver protocol
rather than the DNS protocol.

%prep
%setup

# NB: there must be at least one patch :)
%patch0001 -p2
%patch0002 -p2
%patch0003 -p2
%patch0004 -p2
%patch0005 -p2
%patch0006 -p2
%patch0007 -p2
%patch0008 -p2
%patch0009 -p2
%patch0010 -p2
%patch0011 -p2

install -D -pm644 %_sourcedir/rfc1912.txt doc/rfc/rfc1912.txt
install -pm644 %_sourcedir/bind.README.bind-devel README.bind-devel
install -pm644 %_sourcedir/bind.README.ALT README.ALT

mkdir addon
install -pm644 %_sourcedir/{bind,lwresd}.init addon/
install -pm644 %_sourcedir/bind.{named,options,rndc,local,rfc1912,rfc1918}.conf \
	addon/
install -pm644 %_sourcedir/bind.{localhost,localdomain,127.in-addr.arpa,empty,sysconfig,service} \
	addon/
install -pm644 %_sourcedir/rndc.{conf,key} addon/

find -type f -print0 |
	xargs -r0 grep -lZ '@[A-Z_]\+@' -- |
	xargs -r0 sed -i \
'
s,@ROOT@,%_chrootdir,g;
s,@LWRESD_ROOT@,/var/resolv,g;
s,@DOCDIR@,%docdir,g;
s,@SBINDIR@,%_sbindir,g;
' --

# XXX oldish stuff introduced in 9.9.6
sed -i 's/AC_DEFINE(\(.*\), 1)/AC_DEFINE(\1, 1, [\1])/' configure.in

sed -i '/# Large File/iAC_SYS_LARGEFILE/' configure.in

%build
%autoreconf
%configure \
	--localstatedir=/var \
	--with-randomdev=/dev/random \
	--disable-threads \
	--disable-linux-caps \
	 %{subst_with openssl} \
	 %{subst_enable ipv6} \
	 %{subst_enable static} \
	--enable-rrl \
	--enable-fetchlimit \
	--enable-exportlib \
	--with-export-libdir=%{_libdir} \
	--with-export-includedir=%{_includedir} \
	--includedir=%{_includedir}/bind9 \
	--disable-openssl-version-check \
	--with-libtool \
	--with-gssapi=yes \
	--disable-isc-spnego \
	#

%make_build
# Build queryperf
pushd contrib/queryperf
	%configure
	%make_build
popd # contrib/queryperf

%install
rln()
{
	local target=$1 && shift
	local source=$1 && shift
	target=`relative "$target" "$source"`
	ln -snf "$target" "%buildroot$source"
}

%makeinstall_std

# Install queryperf.
install -pm755 contrib/queryperf/queryperf %buildroot%_sbindir/

# Install startup scripts.
install -pD -m755 addon/bind.init %buildroot%_initdir/bind
install -pD -m755 addon/lwresd.init %buildroot%_initdir/lwresd

# Install systemd service
install -pD -m644 addon/bind.service %buildroot%_unitdir/bind.service

# Install configurations files
install -pm600 addon/rndc.conf %buildroot%_sysconfdir/
install -pD -m644 addon/bind.sysconfig %buildroot%_sysconfdir/sysconfig/bind

# Create a chrooted environment...
mkdir -p %buildroot%_chrootdir/{dev,%_sysconfdir,var/{run,tmp},session,zone/slave}
for n in named options rndc local rfc1912 rfc1918; do
	install -pm640 "addon/bind.$n.conf" \
		"%buildroot%_chrootdir%_sysconfdir/$n.conf"
done
for n in localhost localdomain 127.in-addr.arpa empty; do
	install -pm640 "addon/bind.$n" \
		"%buildroot%_chrootdir/zone/$n"
	sed -i s/YYYYMMDDNN/%{timestamp}00/ \
		"%buildroot%_chrootdir/zone/$n"
done

install -pm640 addon/rndc.key bind.keys %buildroot%_chrootdir%_sysconfdir/
ln -snfr %buildroot%_chrootdir%_sysconfdir/{named.conf,bind.keys} \
	%buildroot%_sysconfdir/

# Make use of syslogd-1.4.1-alt11 /etc/syslog.d/ feature.
/usr/bin/mksock %buildroot%_chrootdir/dev/log
mkdir %buildroot%_sysconfdir/syslog.d
ln -s %_chrootdir/dev/log %buildroot%_sysconfdir/syslog.d/bind
#... end of the chroot configuration.

# Create ndc compatibility symlinks.
ln -s rndc %buildroot%_sbindir/ndc
ln -s rndc.8 %buildroot%_man8dir/ndc.8

# Create ghost files
touch %buildroot/var/run/{named,lwresd}.pid

# Package documentation files
mkdir -p %buildroot%docdir
cp -a CHANGES COPYRIGHT FAQ README* \
	doc/{arm,misc,rfc} \
	%buildroot%docdir/
install -pm644 contrib/queryperf/README %buildroot%docdir/README.queryperf

bzip2 -9q %buildroot%docdir/{*/*.txt,FAQ,CHANGES}
rm -fv %buildroot%docdir/*/{Makefile*,README-SGML,*.dsl*,*.sh*,*.xml}

%pre
/usr/sbin/groupadd -r -f named
/usr/sbin/useradd -r -g named -d %_chrootdir -s /dev/null -n -c "Domain Name Server" named >/dev/null 2>&1 ||:
[ -f %_initdir/named -a ! -L %_initdir/named ] && /sbin/chkconfig --del named ||:
%pre_control bind-debug bind-slave

%preun
%preun_service bind

%post
SYSLOGD_SCRIPT=/etc/init.d/syslogd
SYSLOGD_CONFIG=/etc/sysconfig/syslogd
if grep -qs '^SYSLOGD_OPTIONS=.*-a %_chrootdir/dev/log' "$SYSLOGD_CONFIG"; then
	# Remove artefacts of pre-syslog.d epoch.
	sed -i 's|^\(SYSLOGD_OPTIONS=.*\) \?-a %_chrootdir/dev/log|\1|' "$SYSLOGD_CONFIG"
	if [ -x "$SYSLOGD_SCRIPT" ]; then
		"$SYSLOGD_SCRIPT" condreload ||:
	fi
fi

%post_control -s disabled bind-debug bind-slave
%post_service bind

%pre -n lwresd
/usr/sbin/groupadd -r -f lwresd
/usr/sbin/useradd -r -g lwresd -d / -s /dev/null -n -c "Lightweight Resolver Daemon" lwresd >/dev/null 2>&1 ||:

%post -n lwresd
%post_service lwresd

%preun -n lwresd
%preun_service lwresd

%files -n libbind
%exclude  %_libdir/*export.*
%_libdir/lib*.so.*
%dir %docdir
%docdir/COPYRIGHT

%files -n lwresd
%config %_initdir/lwresd
%_sbindir/lwresd
%_man8dir/lwresd.*
%ghost %attr(644,root,root) /var/run/lwresd.pid

%files -n libisc-export
%_libdir/lib*-export.so.*

%files devel
%exclude  %_libdir/*export.*
%_libdir/*.so
%_bindir/isc-config.sh
%_includedir/bind9
%_man3dir/*
%dir %docdir
%docdir/README.bind-devel

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files -n libisc-export-devel
%exclude %_includedir/bind9
%_includedir/*
%_libdir/lib*-export.so

%files
%exclude %_sbindir/lwresd
%exclude %_man8dir/lwresd*
%_sbindir/*
 
# TODO
#    /usr/bin/bind9-config
#    /usr/share/man/man1/bind9-config.1.gz

%_sysconfdir/named.conf
%_sysconfdir/bind.keys
%config %_initdir/bind
%config %_sysconfdir/sysconfig/bind
%config(noreplace) %_sysconfdir/rndc.conf
%_unitdir/bind.service

%_man5dir/*
%_man8dir/*
%_man1dir/arpaname*

%dir %docdir
%docdir/README*
%docdir/FAQ*
%docdir/misc
%exclude %docdir/README.bind-devel

%ghost %attr(644,root,root) /var/run/named.pid

#chroot
%_sysconfdir/syslog.d/*
%defattr(640,root,named,710)
%dir %_chrootdir
%dir %_chrootdir/dev
%dir %_chrootdir%_sysconfdir
%dir %_chrootdir/zone
%dir %attr(700,root,named) %verify(not mode) %_chrootdir/zone/slave
%dir %attr(700,root,named) %verify(not mode) %_chrootdir/var
%dir %attr(1770,root,named) %_chrootdir/var/run
%dir %attr(1770,root,named) %_chrootdir/var/tmp
%dir %attr(700,root,named) %_chrootdir/session
%config(noreplace) %_chrootdir%_sysconfdir/*.conf
%config(noreplace) %verify(not md5 mtime size) %_chrootdir%_sysconfdir/rndc.key
%_chrootdir%_sysconfdir/bind.keys
%config %_chrootdir/zone/localhost
%config %_chrootdir/zone/localdomain
%config %_chrootdir/zone/127.in-addr.arpa
%config %_chrootdir/zone/empty

%ghost %attr(666,root,root) %_chrootdir/dev/*

%files utils
%_bindir/dig
%_bindir/host
%_bindir/nslookup
%_bindir/nsupdate
%_man1dir/dig.*
%_man1dir/host.*
%_man1dir/nslookup.*
%_man1dir/nsupdate.*
%_man1dir/isc-config.sh.*

%files doc
%docdir
%exclude %docdir/README*
%exclude %docdir/FAQ.bz2
%exclude %docdir/misc
%exclude %docdir/COPYRIGHT

%changelog
