Name: binutils
Version: 2.23.51.0.1
Release: alt2.M70P.1
Epoch: 1

Summary: GNU Binary Utility Development Utilities
License: GPLv3+
Group: Development/Other
Url: http://sourceware.org/binutils/

# ftp://ftp.kernel.org/pub/linux/devel/%name/%name-%version.tar.xz
Source: %name-%version.tar
Source1: gcc.sh
Source2: gxx.sh
Source3: output-format.sed

# RH
#Patch01: binutils-2.20.51.0.7-rh-libtool-lib64.patch
Patch02: binutils-2.20.51.0.10-rh-ppc64-pie.patch
#Patch03: binutils-2.20.51.0.2-rh-ia64-lib64.patch
Patch04: binutils-2.20.51.0.2-rh-alt-version.patch
Patch05: binutils-2.20.51.0.2-rh-set-long-long.patch
Patch06: binutils-2.20.51.0.10-rh-copy-osabi.patch
Patch07: binutils-2.20.51.0.10-rh-sec-merge-emit.patch
#Patch08: binutils-2.22.52.0.1-rh-relro-on-by-default.patch
#Patch09: binutils-2.22.52.0.1-rh-export-demangle.h.patch
Patch10: binutils-2.23.51.0.1-rh833355-gold-keep.patch
Patch11: binutils-2.22.52.0.4-rh845084-no-config-h-check.patch

Patch50: binutils-2.24-rh-strings-default-all.patch

# ALT
Patch100: binutils-2.22.52.0.3-alt-configure.patch
Patch101: binutils-2.22.52.0.3-alt-texinfo.patch
Patch102: binutils-2.22.52.0.4-alt-no-warn-shared-textrel.patch
Patch103: binutils-2.22.52.0.3-alt-ld-defaults.patch
Patch104: binutils-2.22.52.0.4-alt-ld-testsuite.patch
Patch105: binutils-2.22.52.0.3-alt-gold-testsuite.patch
Patch106: binutils-2.22.52.0.3-alt-export-headers.patch

Patch111: binutils-2.23.51.0.1-alt-ld-testsuite-workaround-x86.patch

PreReq: alternatives >= 0:0.4
Conflicts: libbfd
# due to c++filt
Conflicts: gcc-common < 0:1.2.1-alt4

BuildRequires: alternatives >= 0:0.4
BuildRequires: flex perl-Pod-Parser zlib-devel
BuildRequires: gcc-c++ libstdc++-devel-static
%{?!_without_check:%{?!_disable_check:BuildRequires: dejagnu, gcc-c++, glibc-devel-static, zlib-devel-static, bc, /proc, /dev/pts}}

%package devel
Summary: Development files for development with BFD, opcodes and libiberty libraries
Group: Development/C
Requires: zlib-devel-static
Provides: libiberty-devel = %epoch:%version-%release
Provides: libbfd-devel = %epoch:%version-%release
Obsoletes: libiberty-devel
Obsoletes: libbfd-devel

%description
Binutils is a collection of binary utilities, including:
+ addr2line: converting addresses to file and line;
+ ar: creating modifying and extracting from archives;
+ nm: listing symbols from object files;
+ objcopy: copying and translating object files;
+ objdump: displaying information from object files;
+ ranlib: generating an index for the contents of an archive;
+ size: listing the section sizes of an object or archive file;
+ strings: listing printable strings from files;
+ strip: discarding symbols.

%description devel
This package contains include files, dynamic and static libraries needed
for development software based on Binary File Descriptor library and
libiberty.

%prep
%setup

#patch01 -p0
%patch02 -p0
#patch03 -p0
%patch04 -p0
%patch05 -p0
%patch06 -p0
%patch07 -p0
#patch08 -p0
#patch09 -p0
%patch10 -p0
%patch11 -p0

%patch50 -p0

%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
%patch105 -p1
%patch106 -p1

%ifarch %ix86
%patch111 -p1
%endif

grep -Fl 'x86_64-*kfreebsd*-gnu)' */configure |while read f; do
	patch "$f" < %PATCH100
	sed -i -e 's,sys_lib_search_path_spec="/lib /usr/lib /usr/local/lib",sys_lib_search_path_spec="/lib$libsuff /usr/lib$libsuff /usr/local/lib$libsuff",' \
	       -e 's,sys_lib_dlsearch_path_spec="/lib /usr/lib",sys_lib_dlsearch_path_spec="/lib$libsuff /usr/lib$libsuff",' \
	       -e 's,sys_lib_dlsearch_path_spec="/lib /usr/lib \$lt_ld_extra",sys_lib_dlsearch_path_spec="$sys_lib_dlsearch_path_spec $lt_ld_extra",' "$f"
done

sed -i 's/%%{release}/%release/g' bfd/Makefile{.am,.in}

find -type f -name \*.orig -delete

%build
%define _configure_target --host=%_target_platform --build=%_target_platform
%undefine __libtoolize
ADDITIONAL_TARGETS=
%ifarch %ix86 x86_32
ADDITIONAL_TARGETS="--enable-64-bit-bfd"
%endif
%ifarch ia64 x86_64
ADDITIONAL_TARGETS="--enable-targets=i386-alt-linux"
%endif
%ifarch ppc
ADDITIONAL_TARGETS="--enable-targets=powerpc64-alt-linux --enable-targets=spu --enable-64-bit-bfd"
%endif
%configure \
	--enable-shared \
	--with-pic \
	--disable-werror \
	--enable-plugins \
	--with-bugurl=http://bugzilla.altlinux.org/ \
	--enable-gold=yes --enable-ld=default \
	$ADDITIONAL_TARGETS

for t in configure-host maybe-all-{libiberty,bfd,opcodes} all; do
	%make_build tooldir=%_prefix $t
done

%install
%makeinstall_std tooldir=%_prefix install-info

# Add alternatives files
install -d %buildroot%_altdir
echo "%_bindir/ld	%_bindir/ld.bfd	50" >  %buildroot%_altdir/ld-bfd
echo "%_bindir/ld	%_bindir/ld.gold	10" >  %buildroot%_altdir/ld-gold

# Remove /usr/bin/ld to avoid conflicts with alternatives
rm -f %buildroot%_bindir/ld

# Install PIC version of the libiberty.a
install -pm644 libiberty/pic/libiberty.a %buildroot%_libdir/

# Remove unrelated manpages.
find %buildroot%_man1dir -type f |while read f; do
	n="${f##*/}"
	n="${n%%.1*}"

	# ld uses alternatives
	[ "$n" != "ld" ] || continue

	[ -f "%buildroot%_bindir/$n" ] || rm -v "$f"
done

# Prepare info file lists.
ls %buildroot%_infodir/*.info |
	fgrep -v /bfd |
	sed "s|^%buildroot\(.*\)|\1*|g" >files.lst

# Fix multilib conflicts of generated values by __WORDSIZE-based expressions.
%ifarch %ix86 x86_64 x86_32 ppc ppc64 s390 s390x sparc sparc64
# Sanity check --enable-64-bit-bfd really works.
grep -Fqsx '#define BFD_ARCH_SIZE 64' %buildroot%_prefix/include/bfd.h

sed -i -e '/^#include "ansidecl.h"/{p;s|^.*|#include <bits/wordsize.h>|}' \
    -e 's/^\(#define BFD_DEFAULT_TARGET_SIZE \)\(32\|64\) *$/\1__WORDSIZE/' \
    -e 's/^\(#define BFD_HOST_64BIT_LONG \)[01] *$/\1(__WORDSIZE == 64)/' \
    -e 's/^\(#define BFD_HOST_64_BIT \)\(long \)\?long *$/#if __WORDSIZE == 32\
\1long long\
#else\
\1long\
#endif/' \
    -e 's/^\(#define BFD_HOST_U_64_BIT unsigned \)\(long \)\?long *$/\1BFD_HOST_64_BIT/' \
    %buildroot%_includedir/bfd.h
%endif
touch -r bfd/bfd-in2.h %buildroot%_includedir/bfd.h

# Generate .so linker scripts for dependencies; imported from glibc/Makerules:

# Remove symlinks
rm -f %buildroot%_libdir/lib{bfd,opcodes}.so

# This fragment of linker script gives the OUTPUT_FORMAT statement
# for the configuration we are building.
OUTPUT_FORMAT="\
/* Ensure this .so library will not be used by a link for a different format
   on a multi-architecture system.  */
$(gcc $CFLAGS $LDFLAGS -shared -x c /dev/null -o /dev/null -Wl,--verbose -v 2>&1 | sed -n -f "%_sourcedir/output-format.sed")"

cat >%buildroot%_libdir/libbfd.so <<EOF
/* GNU ld script */

$OUTPUT_FORMAT

/* The -lz and -ldl dependencies are unexpected by legacy build scripts.  */
INPUT ( %_libdir/libbfd.a -liberty -ldl -lz )
EOF

cat >%buildroot%_libdir/libopcodes.so <<EOF
/* GNU ld script */

$OUTPUT_FORMAT

INPUT ( %_libdir/libopcodes.a -lbfd )
EOF

# Relocate include files.
pushd %buildroot%_includedir
	mkdir bfd
	for f in *.h; do
		mv "$f" bfd/
		ln -s bfd/"$f" .
	done
popd

# Add more include files.
install -pm644 include/{demangle,libiberty}.h %buildroot%_includedir/
install -pm644 bfd/{elf-bfd,lib*}.h %buildroot%_includedir/bfd/
cp -a include/{coff,elf,nlm} %buildroot%_includedir/bfd/
rm -f %buildroot%_includedir/bfd/{*in.h,*/ChangeLog*}

# Install NEWS.
for n in binutils gas ld; do
	install -pm644 $n/NEWS NEWS-$n
done

%find_lang %name bfd gas gprof ld opcodes --append --output files.lst

%set_verify_elf_method strict

%check
[ -w /dev/ptmx -a -f /proc/self/maps ] || exit
RUNTESTFLAGS=
XFAIL_TESTS=
%ifarch x86_64
XFAIL_TESTS='exception_static_test incremental_test_2 incremental_test_3 incremental_test_4 incremental_test_5 incremental_test_6 incremental_copy_test incremental_common_test_1 incremental_comdat_test_1'
%endif
%ifarch %ix86
XFAIL_TESTS=debug_msg.sh
%endif
%make_build -k check CC="%_sourcedir/gcc.sh" CXX="%_sourcedir/gxx.sh" \
	XFAIL_TESTS="$XFAIL_TESTS" RUNTESTFLAGS="$RUNTESTFLAGS"

%files devel
%_libdir/*.a
%_libdir/libbfd.so
%_libdir/libopcodes.so
%_includedir/bfd
%_includedir/*.h
%_infodir/bfd.info*

%files -f files.lst
%_bindir/*
%_altdir/ld-*
%_prefix/lib/ldscripts
%_mandir/man?/*
%_libdir/*-*.so
%doc NEWS*

%changelog
