Name: bird
Version: 1.4.3
Release: alt0.M70P.2
Summary: BIRD Internet Routing Daemon

Group: Networking/Other
License: GPL
URL: http://bird.network.cz

# Cloned from git://git.nic.cz/bird.git
Source: %name-%version.tar
Source1: %name.init
Patch: %name-%version-%release.patch

Packager: Vladimir Lettiev <crux@altlinux.ru>

BuildRequires: libreadline-devel libncurses-devel flex glibc-kernheaders OpenSP linuxdoc-tools

%description
BIRD is an Internet Routing Daemon designed to support all the routing
technology used in the today's Internet or planned to be used in near
future and to have a clean extensible architecture allowing new routing
protocols to be incorporated easily. Among other features, BIRD supports:

 * both IPv4 and IPv6 protocols
 * multiple routing tables
 * the Border Gateway Protocol (BGPv4)
 * the Routing Information Protocol (RIPv2)
 * the Open Shortest Path First protocol (OSPFv2)
 * a virtual protocol for exchange of routes between different routing
   tables on a single host
 * a command-line interface allowing on-line control and inspection of
   status of the daemon
 * soft reconfiguration (no need to use complex online commands to
   change the configuration, just edit the configuration file and notify
   BIRD to re-read it and it will smoothly switch itself to the new
   configuration, not disturbing routing protocols unless they are
   affected by the configuration changes)
 * a powerful language for route filtering

BIRD has been developed at the Faculty of Math and Physics, Charles
University, Prague, Czech Republic as a student project. It can be
freely distributed under the terms of the GNU General Public License.

%package -n bird6
Group: Networking/Other
Summary: BIRD Internet Routing Daemon, ipv6 enabled
Requires: %name = %version-%release
%description -n bird6
%summary

%prep
%setup
%patch -p1

%build
autoconf
./configure --prefix=%_usr --sysconfdir=%_sysconfdir --localstatedir=%_var \
	--enable-ipv6 --with-protocols=all
%make_build
mv bird bird6
mv birdc birdc6
mv birdcl birdcl6
%make clean
./configure --prefix=%_usr --sysconfdir=%_sysconfdir --localstatedir=%_var \
	--with-protocols=all
%make_build
pushd doc
    make prog.sgml
    ./sgml2html prog.sgml
    ./sgml2html bird.sgml
popd

%install
%make_install install \
	prefix=%buildroot%_prefix \
	sysconfdir=%buildroot%_sysconfdir \
	sbindir=%buildroot%_sbindir \
	localstatedir=%buildroot%_var

install -d %buildroot%_sbindir
install bird6 %buildroot%_sbindir
install birdc6 %buildroot%_sbindir
install birdcl6 %buildroot%_sbindir

install -d %buildroot%_initdir
install %SOURCE1 %buildroot%_initdir/%name

%post
%post_service bird

%preun
%preun_service bird

%files
%_initdir/%name
%config(noreplace) %_sysconfdir/%name.conf
%_sbindir/%name
%_sbindir/%{name}c
%_sbindir/%{name}cl
%doc NEWS README TODO doc/*.html

%files -n bird6
%_sbindir/%{name}6
%_sbindir/%{name}c6
%_sbindir/%{name}cl6

%changelog
