Name: bitcoin
Version: 0.9.3
Release: alt0.M70P.1.rc1

Summary: peer-to-peer network based anonymous digital currency
License: MIT
Group: Networking/Other

Url: http://www.bitcoin.org/
Source: %name-%version.tar

BuildRequires: zlib-devel boost-devel libssl-devel gcc-c++ libdb4.8-devel libdb4.8_cxx-devel
BuildRequires: boost-filesystem-devel boost-interprocess-devel boost-program_options-devel
BuildRequires: libgtk+2-devel wxGTK-devel boost-asio-devel
BuildRequires: libqt4-devel lcov ccache libminiupnpc-devel
BuildPreReq: libprotobuf-devel protobuf-compiler gcc-objc clang-devel
BuildPreReq: libqrencode-devel boost-signals-devel

%description
Q. What is Bitcoin?
A. Bitcoin is a peer-to-peer currency. Peer-to-peer means that no
central authority issues new money or tracks transactions. These tasks
are managed collectively by the network.

Q. How does Bitcoin work?
A. Bitcoin utilises public-key cryptography. A coin contains the owner's
public key. When a coin is transferred from user A to user B, A adds B's
public key to the coin, and the coin is signed using A's private key. B
now owns the coin and can transfer it further. A is prevented from
transferring the already spent coin to other users because a public list
of all previous transactions is collectively maintained by the network.
Before each transaction the coin's validity will be checked.

%prep
%setup

%build
./autogen.sh
export OBJC=clang
export OBJCXX=clang++
%configure \
	--enable-upnp-default \
	--with-gui=qt4
%make_build V=1

%install
%makeinstall_std
ln -s %name-qt %buildroot%_bindir/%name

%pre
rm -f %_bindir/%name

%files
%_bindir/%{name}*
%doc doc/*

%changelog
