%define _libexecdir %_prefix/libexec

Name: blueman
Version: 1.23
Release: alt2
Summary: The GTK+ bluetooth management utility
License: GPLv3
Group: System/Libraries
Url: http://%name.tuxfamily.org/

Requires: bluez >= 4.35 obex-data-server >= 0.4.3
Requires: GConf polkit-gnome
Provides: bluez-gnome

Source: %name-%version.tar

Patch1: blueman-1.23-alt-fix-icon-tray-name.patch

BuildRequires: intltool libbluez-devel libgtk+2-devel libstartup-notification-devel python-module-Pyrex
BuildRequires: python-module-dbus python-module-pygobject-devel python-module-pygtk-devel python-module-notify

%description
Blueman is a GTK+ bluetooth management utility for GNOME using bluez
dbus backend.  The aim is to create a full featured graphical bluetooth
manager for Linux.

Features:

    * Easy to use interface
    * Storing Favourite devices
    * Send files
    * Browse files on devices
    * List all seen devices
    * View Local/Remote Device information
    * View transfer speeds and link quality
    * Configure local devices
    * Manage Pairing (Bonding)
    * Host/Connect to Personal Area Networks
    * Bind services to /dev/rfcomm ports, for eg. connecting via gprs
    * Connect and receive connections from: audio, network, input and serial devices 

%prep
%setup
%patch1 -p1

subst 's/DBusServiceUnknownError/DBusException/' blueman/*/*.py
find -name Makefile.am | xargs sed -i 's,pythondir,pyexecdir,'

%build
%autoreconf
%configure \
	--with-dhcp-config=%_sysconfdir/dhcp/dhcpd.conf \
	--libexecdir=%_libexecdir \
	--enable-polkit \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

find %buildroot%python_sitelibdir -name \*.la -delete

mkdir -p %buildroot%_altdir
cat > %buildroot%_altdir/%name <<EOF
%_bindir/bluetooth-sendto	%_bindir/blueman-sendto	20
EOF

%find_lang %name

%files -f %name.lang
%_altdir/%name
%_sysconfdir/dbus-1/system.d/org.%name.Mechanism.conf
%_sysconfdir/xdg/autostart/%name.desktop
%_bindir/blue*
%_libexecdir/%name-mechanism
%_libdir/nautilus-sendto/plugins/libnstblueman.so
%python_sitelibdir/blueman
%python_sitelibdir/_blueman.so
%exclude %python_sitelibdir/blueman/plugins/applet/AppIndicator.py*
%_desktopdir/%name-manager.desktop
%_datadir/%name
%_datadir/dbus-1/services/%name-applet.service
%_datadir/dbus-1/system-services/org.%name.Mechanism.service
%_datadir/polkit-1/actions/org.blueman.policy
%_iconsdir/hicolor/*/apps/%name.*
%_man1dir/%name-*.1*

%changelog
