%define systemdsystemunitdir /lib/systemd/system

Name: bluez
Version: 4.101
Release: alt1
Summary: Bluetooth utilities
License: GPLv2+
Group: Networking/Other
URL: http://www.bluez.org/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: lib%name = %version-%release
Conflicts: udev-extras < 169

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: flex glib2-devel gtk-doc libalsa-devel libcheck-devel libdbus-devel
BuildRequires: libreadline-devel libsndfile-devel libusb-compat-devel libudev-devel

%description
Bluetooth protocol stack for Linux

%package -n lib%name
Summary: Libraries for use in Bluetooth applications
Group: System/Libraries
Obsoletes: lib%{name}4

%description -n lib%name
Libraries for use in Bluetooth applications

%package -n lib%name-devel
Summary: Development libraries for Bluetooth applications
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
lib%name-devel contains development libraries and headers for
use in Bluetooth applications

%package cups
Summary: CUPS printer backend for Bluetooth printers
Group: Networking/Other
Requires: %name = %version-%release

%description cups
This package contains the CUPS backend

%package alsa
Summary: ALSA support for Bluetooth audio devices
Group: Networking/Other
Requires: %name = %version-%release

%description alsa
This package contains ALSA support for Bluetooth audio devices

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--enable-cups \
	--enable-dfutool \
	--enable-tools \
	--enable-bccmd \
	--disable-gstreamer \
	--enable-hidd \
	--enable-pand \
	--enable-dund \
	--enable-hid2hci \
	--with-systemdunitdir=%systemdsystemunitdir \
	--localstatedir=%_var
%make

%install
%make DESTDIR=%buildroot install

install -pD -m755 scripts/bluetooth.alt.init %buildroot%_initdir/bluetoothd
install -m644 audio/audio.conf \
	input/input.conf \
	network/network.conf \
	serial/serial.conf \
	%buildroot%_sysconfdir/bluetooth/

mkdir -p %buildroot%_libdir/bluetooth/plugins %buildroot%_localstatedir/bluetooth

# symlink for systemd
ln -s bluetooth.service %buildroot%systemdsystemunitdir/bluetoothd.service

mkdir %buildroot%_sysconfdir/modprobe.d
cat <<__EOF__ > %buildroot%_sysconfdir/modprobe.d/bluetooth.conf
# use "reset=1" as default, since it should be safe for recent devices and
# solves all kind of problems.
options btusb reset=1

install bluetooth /sbin/modprobe --first-time --ignore-install bluetooth && { /sbin/modprobe uinput; /bin/true; }
__EOF__

find %buildroot%_libdir -name \*.la -delete

%post
%post_service bluetoothd
if [ $1 = 1 ]; then
	chkconfig bluetoothd on
fi

%preun
%preun_service bluetoothd

%triggerin -- %name <= 4.37-alt1
chkconfig bluetoothd on

%files
%doc AUTHORS ChangeLog README
%_initdir/bluetoothd
%dir %_sysconfdir/bluetooth/
%config(noreplace) %_sysconfdir/bluetooth/*.conf
%config %_sysconfdir/dbus-1/system.d/bluetooth.conf
%_sysconfdir/modprobe.d/bluetooth.conf
%systemdsystemunitdir/*.service
/lib/udev/rules.d/*-bluetooth-hid2hci.rules
/lib/udev/hid2hci
%_sbindir/*
%_bindir/*
%_libdir/bluetooth
%_datadir/dbus-1/system-services/org.bluez.service
%_localstatedir/bluetooth
%_man1dir/*.1*
%_man8dir/*.8*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/bluetooth
%_libdir/*.so
%_pkgconfigdir/*.pc

%files cups
%_prefix/lib/cups/backend/bluetooth

%files alsa
%_datadir/alsa/bluetooth.conf
%_libdir/alsa-lib/*.so*

%changelog
