Name: bogofilter
Version: 1.2.3
Release: alt1

Summary: Fast anti-spam filtering by Bayesian statistical analysis
Summary(ru_RU.CP1251):        
Group: Networking/Mail
License: GPL
URL: http://bogofilter.sourceforge.net/

Packager: Ilya Mashkin <oddity@altlinux.ru>

%define gsl_ver 1.4

%define pkgdocdir %_docdir/%name-%version

Source: %name-%version.tar.bz2
Patch0: %name-0.96.4-alt-bogus-deps.patch

Requires: libgsl >= %gsl_ver

BuildRequires: OpenSP flex
BuildRequires: libgsl-devel >= %gsl_ver
BuildRequires: libdb4.7-devel 
BuildRequires: perl-Pod-Parser

%description
Bogofilter is a Bayesian spam filter.  In its normal mode of
operation, it takes an email message or other text on standard input,
does a statistical check against lists of "good" and "bad" words, and
returns a status code indicating whether or not the message is spam.
Bogofilter is designed with fast algorithms  (including Berkeley DB system),
coded directly in C, and tuned for speed, so it can be used for production
by sites that process a lot of mail.

%description -l ru_RU.CP1251
Bogofilter         .  
        
  ,     
""  "" ,   ,   
   . Bogofilter    
(  Berkeley DB),   C,    , 
      ,   
 .

%package utils
Summary: Bogofilter utilities
Group: Networking/Mail
Requires: %name = %version-%release pax
Provides: bogofilter-tuning
Obsoletes: bogofilter-tuning

%description utils
This package features various utilities to maintain bogofilter installations.
Bogofilter is a Bayesian spam filter using databases of "good" and "bad"
words for operation.

%package contrib
Summary: Scripts contributed to Bogofilter
Group: Networking/Mail
Requires: %name = %version-%release

AutoReq: yes, noperl

%description contrib
Helpful scripts contributed to the bogofilter package.
Bogofilter is a Bayesian spam filter.

%prep
%setup -q
%patch0 -p1

%build
%configure --disable-dependency-tracking \
    --with-database=db --disable-rpath
%make_build
%{?!_disable_check:%make check}

%install
%set_verify_info_method relaxed
%makeinstall
#cp $RPM_BUILD_ROOT%_sysconfdir/bogofilter.cf.example \
#   $RPM_BUILD_ROOT%_sysconfdir/bogofilter.cf

install -d -m755 $RPM_BUILD_ROOT%_libdir/%name
install -d -m755 $RPM_BUILD_ROOT%_libdir/%name/contrib
for f in $(find contrib -type f ! \( -name 'Makefile*' -o -name '*.c' -o -name '*.o' -o -name '*.Po' \)); do
    cp -p "$f" $RPM_BUILD_ROOT%_libdir/%name/contrib
done

install -d -m755 $RPM_BUILD_ROOT%pkgdocdir
ln -s %_licensedir/GPL-2 $RPM_BUILD_ROOT%pkgdocdir/COPYING
install -m644 AUTHORS GETTING.STARTED NEWS README RELEASE.NOTES TODO \
    $RPM_BUILD_ROOT%pkgdocdir/
install -m644 doc/*.html \
    $RPM_BUILD_ROOT%pkgdocdir/
install -m644 doc/integrating-with-* \
    $RPM_BUILD_ROOT%pkgdocdir/
install -m644 doc/README.db \
    $RPM_BUILD_ROOT%pkgdocdir/

%files
%dir %pkgdocdir
%pkgdocdir/COPYING
%pkgdocdir/AUTHORS
%pkgdocdir/GETTING.STARTED
%pkgdocdir/NEWS
%pkgdocdir/README*
%pkgdocdir/RELEASE.NOTES
%pkgdocdir/TODO
%pkgdocdir/*.html
%pkgdocdir/integrating-with-*
%_bindir/bogofilter
%_man1dir/bogofilter.1*
%_sysconfdir/bogofilter.cf.example
#%config(noreplace) %_sysconfdir/bogofilter.cf

%files utils
%_bindir/bf_*
%_bindir/bogolexer
%_bindir/bogotune
%_bindir/bogoupgrade
%_bindir/bogoutil
%_man1dir/bf_*
%_man1dir/bogolexer.1*
%_man1dir/bogotune.1*
%_man1dir/bogoupgrade.1*
%_man1dir/bogoutil.1*

%files contrib
%dir %_libdir/%name
%_libdir/%name/contrib

%changelog
