Name: bootloader-utils
Version: 0.4.24
Release: alt1

Summary: Bootloader utilities
License: GPL
Group: System/Base
BuildArch: noarch

Source: %name-%version-%release.tar

PreReq: getopt, make-initrd >= 0.4.3-alt2
Conflicts: grub2 < 1.98-alt13
Conflicts: lilo < 22.7.3-alt7

%ifarch %arm
PreReq: uboot-tools >= 2013.07
%endif

# Automatically added by buildreq on Thu Feb 22 2007
BuildRequires: perl-devel

%description
This package contains utilities used to manipulate bootloaders.

%prep
%setup -n %name-%version-%release

%build
%make_build

%install
%makeinstall perl_libdir=%buildroot%perl_vendor_privlib
ln -s `relative %perl_vendor_privlib/bootloader_utils.pm %_datadir/loader/bootloader_utils.pm` \
	%buildroot%_datadir/loader/bootloader_utils.pm
mkdir -p %buildroot/%_rpmlibdir
install -pD -m755 kernel.filetrigger %buildroot/%_rpmlibdir/boot_kernel.filetrigger

mkdir -p %buildroot/%_sysconfdir/sysconfig

cat > %buildroot/%_sysconfdir/sysconfig/installkernel <<-EOF
INITRD_GENERATOR=make-initrd
MKINITRD=%_sbindir/mkinitrd-make-initrd
#INITRD_AUTOUPDATE=all
EOF

%check
make test

%pre
[ $1 -gt 1 ] || exit 0
f=/etc/sysconfig/installkernel
rm -f $f.install
[ ! -f $f ] || exit 0
if [ -f $f.rpmsave ]; then
  cp -a $f.rpmsave $f.install
else
  cat >&2 <<EOF
Neither $f nor $f.rpmsave
exits, no way to find out whether this system was configured to use make-initrd
or mkinitrd by default.  This update implements the first scenario.  If this is
not the case, please edit $f after update.
EOF
fi

%post
[ $1 -gt 1 ] || exit 0
f=/etc/sysconfig/installkernel
[ -f $f.install ] || exit 0
cp -a $f $f.rpmnew 2> /dev/null ||:
mv $f.install $f

%files
%config(noreplace) %_sysconfdir/sysconfig/installkernel
/sbin/installkernel
%_sbindir/detectloader.sh
%_sbindir/detectliloboot.sh
%_sbindir/convertdev.sh
%_sbindir/rebootin
%_datadir/loader/
%perl_vendor_privlib/*.pm
%_man8dir/*.*
%_rpmlibdir/*.filetrigger

%changelog
