%define theme slinux
%define Name Simply Linux
%define codename Dory
%define status %nil
%define variants altlinux-backup-server altlinux-desktop altlinux-gnome-desktop altlinux-kdesktop altlinux-lite altlinux-lxdesktop altlinux-office-desktop altlinux-office-server altlinux-school-server altlinux-sisyphus altlinux-spt altlinux-tablet altlinux-workbench informika-schoolmaster ivk-chainmail lxde-desktop lxde-school-lite Platform6-server-light school-junior school-lite school-master school-server school-teacher school-terminal altlinux-centaurus sisyphus-server-light
%define brand simply

Name: branding-simply-linux
Version: 7.0.5
Release: alt1.M70P.4
BuildArch: noarch

BuildRequires: cpio gfxboot >= 4 fonts-ttf-dejavu fonts-ttf-google-droid-serif fonts-ttf-google-droid-sans fonts-ttf-google-droid-sans-mono
BuildRequires: design-bootloader-source >= 5.0-alt2

BuildRequires(pre): libqt4-core 
BuildRequires: libalternatives-devel
BuildRequires: libqt4-devel

BuildRequires: ImageMagick fontconfig bc libGConf-devel

Source: %name-%version.tar

Group: Graphics
Summary: System/Base
License: GPLv2+

%description
Distro-specific packages with design and texts for Simply Linux distribution.

%description -l ru_RU.UTF-8
Пакеты, для дистрибутива "Просто Линукс" (Simply Linux)

%package bootloader
Group: System/Configuration/Boot and Init
Summary: Graphical boot logo for grub2, lilo and syslinux
Summary(ru_RU.UTF-8): Тема для экрана выбора вариантов загрузки (lilo и syslinux) 
License: GPLv2+

PreReq: coreutils
Provides: design-bootloader-system-%theme design-bootloader-livecd-%theme design-bootloader-livecd-%theme design-bootloader-%theme branding-alt-%theme-bootloader

Obsoletes: design-bootloader-system-%theme design-bootloader-livecd-%theme design-bootloader-livecd-%theme design-bootloader-%theme branding-alt-%theme-bootloader
Conflicts: %(for n in %variants ; do [ "$n" = %theme ] || echo -n "branding-$n-bootloader ";done )

%define grub_normal white/dark-gray
%define grub_high black/white

%description bootloader
Here you find the graphical boot logo for Simply Linux distribution.
Suitable for both lilo and syslinux.

%description bootloader -l ru_RU.UTF-8
В данном пакете находится тема для экрана выбора вариантов загрузки (lilo и syslinux) 
для дистрибутива "Просто Линукс" (Simply Linux).

%package bootsplash
Summary: Theme for splash animations during bootup
Summary(ru_RU.UTF-8): Тема для экрана загрузки для дистрибутива "Просто Линукс"
License: Distributable
Group:  System/Configuration/Boot and Init
Provides: plymouth-theme-%theme
Requires: plymouth-plugin-script
PreReq: plymouth

Conflicts: %(for n in %variants ; do [ "$n" = %theme ] || echo -n "branding-$n-bootsplash ";done )

%description bootsplash
This package contains graphics for boot process for Simply Linux
(needs console splash screen enabled).

%description bootsplash -l ru_RU.UTF-8
В данном пакете находится тема для экрана загрузки для дистрибутива
"Просто Линукс" (Simply Linux).

%package alterator
Summary: Design for alterator for Simply Linux 
Summary(ru_RU.UTF-8): Тема для "Центра управления системой" и QT для дистрибутива "Просто Линукс"
License: GPLv2+
Group: System/Configuration/Other
Provides: design-alterator-browser-%theme  branding-alt-%theme-browser-qt branding-altlinux-%theme-browser-qt
Provides: alterator-icons design-alterator design-alterator-%theme
Obsoletes:  branding-alt-%theme-browser-qt  branding-altlinux-%theme-browser-qt 

# lexicographically first of the village
Conflicts: branding-sisyphus-server-light-alterator

Conflicts: %(for n in %variants ; do [ "$n" = %theme ] || echo -n "branding-$n-alterator ";done )
Obsoletes: design-alterator-server design-alterator-desktop design-altertor-browser-desktop  design-altertor-browser-server branding-altlinux-backup-server-alterator
PreReq(post,preun): alternatives >= 0.2 alterator

%description alterator
Design for QT and web alterator for Simply Linux.

%description alterator -l ru_RU.UTF-8
В данном пакете находится тема для "Центра управления системой" (Alterator)
и модулей библиотеки QT для дистрибутива "Просто Линукс" (Simply Linux).

%package graphics
Summary: Design for Simply Linux
Summary(ru_RU.UTF-8): Тема для дистрибутива "Просто Линукс"
License: Different licenses
Group: Graphics

Provides: design-graphics-%theme  branding-alt-%theme-graphics
Obsoletes:  branding-alt-%theme-graphics design-graphics-%theme
Provides: design-graphics = 12.0.0

PreReq(post,preun): alternatives >= 0.2
Conflicts: %(for n in %variants ; do [ "$n" = %theme ] || echo -n "branding-$n-graphics ";done )

%description graphics
This package contains some graphics for Simply Linux design.

%description graphics -l ru_RU.UTF-8
В данном пакете находится необходимые графические элементы для дистрибутива 
"Просто Линукс" (Simply Linux).


%define provide_list altlinux fedora redhat system altlinux
%define obsolete_list altlinux-release fedora-release redhat-release
%define conflicts_list altlinux-release-sisyphus altlinux-release-4.0 altlinux-release-5.0 altlinux-release-5.1 altlinux-release-junior altlinux-release-master altlinux-release-server altlinux-release-terminal altlinux-release-small_business
%package release

Summary: Simply Linux release file
Summary(ru_RU.UTF-8): Описание дистрибутива "Просто Линукс"
License: GPLv2+
Group: System/Configuration/Other
Provides: %(for n in %provide_list; do echo -n "$n-release = %version-%release "; done) altlinux-release-%theme  branding-alt-%theme-release
Obsoletes: %obsolete_list  branding-alt-%theme-release
Conflicts: %conflicts_list
Conflicts: %(for n in %variants ; do [ "$n" = %theme ] || echo -n "branding-$n-release ";done )

%description release
Simply Linux %version release file.

%description release -l ru_RU.UTF-8
В данном пакете находится описание версии %version дистрибутива
"Просто Линукс" (Simply Linux).

%package notes
Provides: alt-license-theme = %version alt-notes-%theme
Obsoletes: alt-license-%theme alt-notes-%theme 
Summary: Distribution license and release notes
Summary(ru_RU.UTF-8): Лицензия и дополнительные сведения для дистрибутива "Просто Линукс"
License: Distributable
Group: Documentation
Conflicts: alt-notes-children alt-notes-hpc alt-notes-junior alt-notes-junior-sj alt-notes-junior-sm alt-notes-school-server alt-notes-server-lite alt-notes-skif alt-notes-terminal alt-notes-desktop
Conflicts: %(for n in %variants ; do [ "$n" = %theme ] || echo -n "branding-$n-notes ";done )

%description notes
Distribution license and release notes

%description notes -l ru_RU.UTF-8
В данном пакете находится лицензия и дополнительные сведения для версии %version
дистрибутива "Просто Линукс" (Simply Linux).

%package xfce-settings

Summary: default settings for Xfce for Simply linux distribution
License: Distributable
Group: Graphical desktop/XFce
Requires: PolicyKit-gnome
Requires: etcskel gtk3-theme-clearlooks-phenix
Requires: gnome-icon-theme icon-theme-simple-sl
Requires: branding-simply-linux-graphics
Obsoletes: xfce-settings-lite xfce-settings-school-lite
Conflicts: %(for n in %variants ; do [ "$n" = %theme ] || echo -n "branding-$n-xfce-settings ";done )
Conflicts: xfce-settings-simply-linux

%description xfce-settings
This package contains default settings for Xfce for Simply linux distribution.

%package slideshow
Summary: Slideshow for Simply Linux %version installer.
Summary(ru_RU.UTF-8): Изображения для организации "слайдшоу" в установщике дистрибутива "Просто Линукс"
License: Distributable
Group: System/Configuration/Other 
Conflicts: %(for n in %variants ; do [ "$n" = %theme ] || echo -n "branding-$n-slideshow ";done )

%description slideshow
Slideshow for Simply Linux %version installer.

%description slideshow -l ru_RU.UTF-8
В данном пакете находятся изображения для организации "слайдшоу" в установщике 
дистрибутива "Просто Линукс" (Simply Linux).

%package indexhtml
Summary: Simply Linux html welcome page
Summary(ru_RU.UTF-8): Стартовая страница для дистрибутива "Просто Линукс"
License: distributable
Group: System/Base
Provides: indexhtml indexhtml-%theme = %version indexhtml-Desktop = 1:5.0
Obsoletes: indexhtml-desktop indexhtml-Desktop

Conflicts: indexhtml-sisyphus
Conflicts: indexhtml-school_junior
Conflicts: indexhtml-school_lite
Conflicts: indexhtml-school_master
Conflicts: indexhtml-school_terminal
Conflicts: indexhtml-small_business
Conflicts: indexhtml-school-server
Conflicts: branding-altlinux-backup-server-indexhtml

Requires: xdg-utils 
Requires: docs-simply-linux
Requires: docs-linux_intro
Requires(post): indexhtml-common

%description indexhtml
Simply Linux index.html welcome page.

%description indexhtml -l ru_RU.UTF-8
В данном пакете содержится стартовая страница для дистрибутива
"Просто Линукс" (Simply Linux).

%package menu
Summary: menu for Simply Linux
License: Distributable
Group: Graphical desktop/Other
Requires(pre): altlinux-freedesktop-menu-common
Requires: altlinux-freedesktop-menu-common

%description menu
Menu for Simply Linux

%package system-settings
Summary: Some system settings for Simply Linux
License: GPLv2+
Group: System/Base
# Really we need lightdm only, but it can pull another greeter.
Requires: lightdm-gtk-greeter
# Due to ldm/.pam_environment file included in the lightdm >= 1.9.13-alt1
Conflicts: lightdm >= 1.9.13-alt1

%description system-settings
Some system settings for Simply Linux.

%prep
%setup -q


%build
autoconf
THEME=%theme NAME='%Name' STATUS=%status VERSION=%version CODENAME=%codename ./configure
make

%install
%makeinstall
make x86 DESTDIR=%buildroot datadir=%buildroot%_datadir sysconfdir=%buildroot%_sysconfdir

%define data_cur_dir %_datadir/branding-data-current
mkdir -p %buildroot%data_cur_dir

#graphics
mkdir -p %buildroot/%_datadir/design/{%theme,backgrounds}
mkdir -p %buildroot/%_niconsdir
install graphics/icons/slinux.png %buildroot/%_niconsdir/slinux.png
install graphics/icons/mini/slinux.png %buildroot/%_iconsdir/altlinux.png
cp -ar graphics/* %buildroot/%_datadir/design/%theme

pushd %buildroot/%_datadir/design/%theme
    pushd backgrounds
	ln -sf ../../../wallpapers more
    popd
popd


install -d %buildroot//etc/alternatives/packages.d
cat >%buildroot/etc/alternatives/packages.d/%name-graphics <<__EOF__
%_datadir/artworks	%_datadir/design/%theme 10	
%_datadir/design-current	%_datadir/design/%theme	10
%_datadir/design/current	%_datadir/design/%theme	10
__EOF__

#release
install -pD -m644 /dev/null %buildroot%_sysconfdir/buildreqs/packages/ignore.d/%name-release
install -pD -m644 components/systemd/os-release %buildroot%data_cur_dir/release/os-release
echo "%Name %version %status (%codename)" >%buildroot%data_cur_dir/release/altlinux-release
for n in fedora redhat system; do
	ln -s altlinux-release %buildroot%data_cur_dir/release/$n-release
done
for r in %buildroot%data_cur_dir/release/*-release; do
  touch %buildroot%_sysconfdir/"${r##*/}"
done

#notes
pushd notes
%makeinstall
popd
ln -s license.ru.html %buildroot%data_cur_dir/alt-notes/license.uk.html
for r in %buildroot%data_cur_dir/alt-notes/license.*.html; do
  touch %buildroot%_datadir/alt-notes/"${r##*/}"
done

mkdir -p %buildroot/etc/skel/XDG-Templates.skel/

cp -r xfce-settings/etcskel/* %buildroot/etc/skel/
cp -r xfce-settings/etcskel/.config %buildroot/etc/skel/
cp -r xfce-settings/etcskel/.local %buildroot/etc/skel/
cp -r xfce-settings/etcskel/.gconf %buildroot/etc/skel/
cp -r xfce-settings/etcskel/.vimrc %buildroot/etc/skel/

install -m 644 xfce-settings/etcskel/.wm-select %buildroot/etc/skel/

mkdir -p %buildroot/usr/share/backgrounds/xfce/vladstudio.com/1600x1200
mkdir -p %buildroot/usr/share/backgrounds/xfce/vladstudio.com/1680x1050
cp -P xfce-settings/backgrounds/*.jpg %buildroot/usr/share/backgrounds/xfce
install -m 644 xfce-settings/backgrounds/vladstudio.com/LICENSE.txt %buildroot/usr/share/backgrounds/xfce/vladstudio.com/
install -m 644 xfce-settings/backgrounds/vladstudio.com/1600x1200/* %buildroot/usr/share/backgrounds/xfce/vladstudio.com/1600x1200/
install -m 644 xfce-settings/backgrounds/vladstudio.com/1680x1050/* %buildroot/usr/share/backgrounds/xfce/vladstudio.com/1680x1050/
install -m 644 xfce-settings/backgrounds/slinux*.{jpg,png} %buildroot/usr/share/backgrounds/xfce/

install -pDm0755 xfce-settings/scripts/zdg-move-templates.sh %buildroot%_sysconfdir/X11/profile.d/zdg-move-templates.sh

#slideshow
mkdir -p %buildroot/usr/share/install2/slideshow
mkdir -p %buildroot/etc/alterator
cp -a slideshow/slides-*  %buildroot/usr/share/install2/slideshow/
# Set English slideshow as default
ln -s slides-en %buildroot/usr/share/install2/slideshow/slides
install slideshow/slideshow.conf %buildroot/etc/alterator/

#indexhtml
%define _altdocsdir %_defaultdocdir/alt-docs
%define _indexhtmldir %_defaultdocdir/indexhtml
install components/indexhtml/*.html %buildroot%_defaultdocdir/indexhtml/
mkdir -p %buildroot%_defaultdocdir/indexhtml/images
install components/indexhtml/images/* %buildroot%_defaultdocdir/indexhtml/images/
#install -m644 components/indexhtml.desktop %buildroot%_desktopdir/

#menu
mkdir -p %buildroot/usr/share/slinux-style/applications
install menu/applications/* %buildroot/usr/share/slinux-style/applications/
mkdir -p %buildroot/etc/xdg/menus/xfce-applications-merged
cp menu/50-xfce-applications.menu %buildroot/etc/xdg/menus/xfce-applications-merged/
mkdir -p %buildroot/usr/share/desktop-directories
cp menu/altlinux-wine.directory %buildroot/usr/share/desktop-directories/

# system-settings
mkdir -p %buildroot/%_sysconfdir/polkit-1/rules.d/
cp -a system-settings/polkit-rules/*.rules %buildroot/%_sysconfdir/polkit-1/rules.d/
install -Dm644 system-settings/ldm_pam_environment %buildroot%_localstatedir/ldm/.pam_environment

#bootloader
%pre bootloader
[ -s /usr/share/gfxboot/%theme ] && rm -fr  /usr/share/gfxboot/%theme ||:
[ -s /boot/splash/%theme ] && rm -fr  /boot/splash/%theme ||:

%post bootloader
%__ln_s -nf %theme/message /boot/splash/message
. /etc/sysconfig/i18n
lang=$(echo $LANG | cut -d. -f 1)
cd boot/splash/%theme/
echo $lang > lang
[ "$lang" = "C" ] || echo lang | cpio -o --append -F message
. shell-config
shell_config_set /etc/sysconfig/grub2 GRUB_THEME /boot/grub/themes/%theme/theme.txt
#shell_config_set /etc/sysconfig/grub2 GRUB_THEME /boot/grub/themes/%theme
shell_config_set /etc/sysconfig/grub2 GRUB_COLOR_NORMAL %grub_normal
shell_config_set /etc/sysconfig/grub2 GRUB_COLOR_HIGHLIGHT %grub_high

%preun bootloader
[ $1 = 0 ] || exit 0
[ "`readlink /boot/splash/message`" != "%theme/message" ] ||
    %__rm -f /boot/splash/message

%post indexhtml
%_sbindir/indexhtml-update

%post system-settings
chown _ldm:_ldm %_localstatedir/ldm/.pam_environment
sed -i '/pam_env\.so/ {
		/user_readenv/ b
		s/pam_env\.so/pam_env.so user_readenv=1/ }
' %_sysconfdir/pam.d/lightdm-greeter

%files bootloader
%_datadir/gfxboot/%theme
/boot/splash/%theme
/boot/grub/themes/%theme

#bootsplash
%post bootsplash
subst "s/Theme=.*/Theme=%theme/" /etc/plymouth/plymouthd.conf
[ -f /etc/sysconfig/grub2 ] && \
      subst "s|GRUB_WALLPAPER=.*|GRUB_WALLPAPER=/usr/share/plymouth/themes/%theme/grub.jpg|" \
             /etc/sysconfig/grub2 ||:

#release
%post release
if ! [ -e %_sysconfdir/altlinux-release ] && \
   ! [ -e %_sysconfdir/os-release ]; then
	cp -a %data_cur_dir/release/*-release %_sysconfdir/
fi

#notes
%post notes
if ! [ -e %_datadir/alt-notes/license.all.html ]; then
	cp -a %data_cur_dir/alt-notes/license.*.html %_datadir/alt-notes/
fi

%files alterator
%config %_altdir/*.rcc
/usr/share/alterator-browser-qt/design/*.rcc
/usr/share/alterator/design/*

%files graphics
%config /etc/alternatives/packages.d/%name-graphics
%_datadir/design
%_niconsdir/slinux.png
%_iconsdir/altlinux.png

%files bootsplash
%_datadir/plymouth/themes/%theme/*
%exclude %_datadir/plymouth/themes/%theme/*.in

%files release
%dir %data_cur_dir
%data_cur_dir/release/
%_sysconfdir/buildreqs/packages/ignore.d/*
%ghost %config(noreplace) %_sysconfdir/*-release

%files notes
%dir %data_cur_dir
%data_cur_dir/alt-notes
%_datadir/alt-notes/livecd-*
%_datadir/alt-notes/release-notes.*
%ghost %config(noreplace) %_datadir/alt-notes/license.*.html

%files xfce-settings
%_sysconfdir/X11/profile.d/zdg-move-templates.sh
/etc/skel/XDG-Templates.skel/
/etc/skel/.wm-select
/etc/skel/.config
/etc/skel/.local
/etc/skel/.gconf
/etc/skel/.vimrc
/usr/share/backgrounds/xfce/*

%files slideshow
/etc/alterator/slideshow.conf
/usr/share/install2/slideshow

%define indexhtmldir %_defaultdocdir/indexhtml

%files indexhtml
#%%ghost %%_indexhtmldir/index.html
#%%_indexhtmldir/*
#%%_desktopdir/*

%ghost %indexhtmldir/index.html
%indexhtmldir/index-*.html
%indexhtmldir/index.css
%indexhtmldir/images
%_desktopdir/indexhtml.desktop

%files menu
/usr/share/slinux-style
/etc/xdg/menus/xfce-applications-merged/50-xfce-applications.menu
/usr/share/desktop-directories/altlinux-wine.directory

%files system-settings
%config %_sysconfdir/polkit-1/rules.d/*.rules
%config %_localstatedir/ldm/.pam_environment

%changelog
