Name: btrfs-progs
Version: 4.2.2
Release: alt0.M70P.1

Summary: Utilities for managing the Btrfs filesystem
License: GPLv2
Group: System/Kernel and hardware
Url: http://btrfs.wiki.kernel.org/

Source: %name-%version-%release.tar

BuildRequires: libacl-devel libe2fs-devel libuuid-devel zlib-devel libblkid-devel libattr-devel liblzo2-devel asciidoc xmlto

%description
Btrfs (B-tree FS or usually pronounced "Butter FS") is a copy-on-write
file system for Linux. It was created as a response to the ZFS filesystem,
in order to replace the ext3 file system while removing a number of its
limitations, particularly with respect to file size, total file system size
and filesystem check duration; it is also expected to implement modern
filesystem features not supported by ext3, like writable snapshots,
snapshots of snapshots, builtin RAID support, and subvolumes. In addition,
Btrfs claims a "focus on fault tolerance, repair and easy administration.

This package contains utilities for managing the Btrfs filesystem

%package -n libbtrfs-devel
Summary:	btrfs filesystem-specific libraries and headers
Group:		Development/C
Requires:	libbtrfs = %version-%release
Provides:	%name-devel

%description -n libbtrfs-devel
btrfs-progs-devel contains the libraries and header files needed to
develop btrfs filesystem-specific programs.

You should install btrfs-progs-devel if you want to develop
btrfs filesystem-specific programs.


%package -n libbtrfs
Summary:	btrfs filesystem-specific libraries and headers
Group:		System/Kernel and hardware

%description -n libbtrfs
btrfs-progs-devel contains shared libraries needed to
btrfs filesystem-specific programs.


%prep
%setup -q -n %name-%version-%release

%build
autoreconf -fisv
automake --add-missing ||:
%configure
%make_build

%install
%makeinstall bindir=%buildroot/sbin libdir=%buildroot/%_lib incdir=%buildroot/%_includedir/btrfs
mkdir -p %buildroot%_libdir
LIBNAME=`basename \`ls $RPM_BUILD_ROOT/%{_lib}/libbtrfs.so.*.*\``
ln -s ../../%_lib/$LIBNAME %buildroot%_libdir/libbtrfs.so 

%files
/sbin/*
%_man8dir/*
%_man5dir/*

%files -n libbtrfs
/%_lib/*.so.*

%files -n libbtrfs-devel
%_libdir/*.so
%_includedir/btrfs

%changelog
