%define __cc musl-gcc

%define bname busybox
Name: %bname-initramfs
Version: 1.21.0
Release: alt1
Summary: %bname for initramfs images generated by mkinitrd
License: GPLv2
Group: System/Kernel and hardware
URL: http://%bname.net
Source1: blkid.sh
Source2: vol_id.sh
AutoReq: no
Provides: util-linux-initramfs module-init-tools-initramfs

BuildRequires: %bname-source = %version

%if "%__cc" == "musl-gcc"
BuildRequires: musl-devel
%else
BuildRequires: glibc-devel-static
%endif
# due -flto flag
BuildRequires: gcc >= 4.6 binutils >= 2.22

%description
This package contains %bname for initramfs images generated by mkinitrd.


%prep
%setup -cT -n %name-%version
tar -x --strip-components 1 -f %_usrsrc/%bname-%version.tar*
#echo "CFLAGS_ash.o += -fno-lto" >> shell/Kbuild.src


%build
config_enable() {
local e
while [ -n "$1" ]; do
	e="$e"'/^#[[:blank:]]*CONFIG_'$1'[[:blank:]]/s|^.*$|CONFIG_'$1'=y|;'
	shift
done
sed -i "$e" .config
}

config_disable() {
local e
while [ -n "$1" ]; do
	e="$e"'/^CONFIG_'$1'=/s|^.*$|# CONFIG_'$1' is not set|;'
	shift
done
sed -i "$e" .config
}

config_param() {
local e
while [ -n "$1" ]; do
	{ echo "$2" | grep -q '^[0-9][0-9]*$'; } &&
		e="$e"'/^CONFIG_'$1'=/s|^.*$|CONFIG_'$1=$2'|;' ||
		e="$e"'/^CONFIG_'$1'=/s|^.*$|CONFIG_'$1'="'$2'"|;'
	shift 2
done
sed -i "$e" .config
}

make allnoconfig

config_disable \
	FEATURE_SH_IS_NONE
config_enable \
	STATIC \
	LFS \
	INSTALL_NO_USR \
	MODPROBE \
	FEATURE_MODUTILS_ALIAS \
	FEATURE_MODUTILS_SYMBOLS \
	BLKID \
	FEATURE_BLKID_TYPE \
	FINDFS \
	VOLUMEID \
	FEATURE_VOLUMEID_SQUASHFS \
	FEATURE_VOLUMEID_EXT \
	FEATURE_VOLUMEID_BTRFS \
	FEATURE_VOLUMEID_REISERFS \
	FEATURE_VOLUMEID_JFS \
	FEATURE_VOLUMEID_XFS \
	FEATURE_VOLUMEID_ISO9660 \
	FEATURE_VOLUMEID_UDF \
	FEATURE_VOLUMEID_NILFS \
	FEATURE_VOLUMEID_LUKS \
	FEATURE_VOLUMEID_LINUXSWAP \
	FEATURE_VOLUMEID_CRAMFS \
	FEATURE_VOLUMEID_OCFS2 \
	FEATURE_VOLUMEID_LINUXRAID \
%if 0
	FEATURE_DEVPTS \
	CAT \
	FEATURE_FANCY_ECHO \
	FALSE \
	LN \
	MKDIR \
	MKNOD \
	READLINK \
	RM \
	SLEEP \
	TRUE \
	USLEEP \
	HALT \
	MDEV \
	FEATURE_MDEV_CONF \
	FEATURE_MDEV_EXEC \
	FEATURE_MDEV_LOAD_FIRMWARE \
	LOSETUP \
	MOUNT \
	FEATURE_MOUNT_LABEL \
	FEATURE_MOUNT_LOOP \
	SWITCH_ROOT \
	UMOUNT \
	IFCONFIG \
	UDHCPC \
	KILL \
	ASH \
	ASH_BUILTIN_ECHO \
	ASH_BUILTIN_PRINTF \
	ASH_BUILTIN_TEST \
	ASH_OPTIMIZE_FOR_SIZE \
	FEATURE_SH_IS_ASH \
	FEATURE_SH_EXTRA_QUIET
%endif

config_param \
	PREFIX /lib/initramfs \
	GZIP_FAST 2 \
	DEFAULT_MODULES_DIR /lib/modules \
	DEFAULT_DEPMOD_FILE modules.dep \
	EXTRA_CFLAGS "-flto -fno-stack-protector -U_FORTIFY_SOURCE -fno-asynchronous-unwind-tables" \
	EXTRA_LDFLAGS -flto

make oldconfig

%make_build %{?__cc:CC="%__cc"} %bname


%install
%make_install %{?__cc:CC="%__cc"} CONFIG_PREFIX=%buildroot/lib/mkinitrd/initramfs install
install -p -m 0755 %{S:1} %buildroot/lib/mkinitrd/initramfs/sbin/$(basename %{S:1} .sh)
install -pD -m 0755 %{S:2} %buildroot/lib/mkinitrd/initramfs/lib/udev/$(basename %{S:2} .sh)


%files
/lib/mkinitrd/initramfs


%changelog
