# vim: set ft=spec: -*- rpm-spec -*-

%def_without check

# %%branch_switch set %%branch_release use
#%%define branch_switch Mxx

Name: bzr
Version: 2.5.1
Release: %branch_release alt1

Summary: Bazaar is a decentralized revision control system
License: %gpl2plus
Group: Development/Other

Url: http://bazaar-vcs.org
Packager: Anatoly Kitaykin <cetus@altlinux.ru>

Source: %name-%version.tar

Patch0: bzr-2.5.0-alt-ssl-cert-path.patch
Patch1: bzr-2.5.1-alt-pyftbdlib-version.patch

%add_python_req_skip launchpadlib
%add_python_req_skip lazr

Conflicts: %name-doc < %version

BuildRequires(pre): rpm-macros-branch
BuildRequires(pre): rpm-build-licenses

# Automatically added by buildreq on Thu Aug 20 2009 (-bi)
BuildRequires: python-module-Pyrex python-modules-compiler python-modules-email python-modules-logging zlib-devel

%{?!__buildreqs:%{?!_without_check:%{?!_without_test:%{?!_disable_check:%{?!_disable_test:BuildRequires: python-module-docutils}}}}}
%{?!__buildreqs:%{?!_without_check:%{?!_without_test:%{?!_disable_check:%{?!_disable_test:BuildRequires: python-module-paramiko}}}}}

%description
Bazaar is a distributed version control system that Just Works. While
many similar systems require you to adapt to their model of working,
Bazaar adapts to the workflows you want to use, and it takes only five
minutes to try it out. People have used it to version pretty much
anything: single-file projects, your /etc directory and even the
thousands of files and revisions in the source code for Launchpad,
MySQL and Mailman.

%package -n python-module-bzrlib-tests
Summary: Tools for testing Bazaar
Group: Development/Other

Requires: %name = %version-%release

%description -n python-module-bzrlib-tests
This package contain tools and test suites for testing Bazaar.

%package doc
Summary: %name documentation and examples
Group: Development/Other
BuildArch: noarch

Conflicts: %name < %version

%description doc
Bazaar is a decentralized revision control system. This
package contain documentation and examples for using Bazaar.

%define bzr_docdir %_docdir/%name-%version

%prep
%setup
%patch0 -p0
%patch1 -p0

%build
%add_optflags -fno-strict-aliasing
%python_build

%install
#define _compress_method none
%python_install --install-data=%_datadir
install -dm0755 %buildroot%bzr_docdir
install -m0644 BRANCH.TODO INSTALL NEWS README TODO %buildroot%bzr_docdir
cp -a doc contrib %buildroot%bzr_docdir
# Hack! Need a subst in setup.py
mv %buildroot%_datadir/share/locale %buildroot%_datadir

%check
%make_build check

%files
%_bindir/bzr
%_man1dir/bzr.*
%python_sitelibdir/*
%exclude %python_sitelibdir/bzrlib/tests
%bzr_docdir
%exclude %bzr_docdir/doc
%exclude %bzr_docdir/contrib
%_datadir/locale/*/LC_MESSAGES/bzr.mo

%files -n python-module-bzrlib-tests
%dir %python_sitelibdir/bzrlib
%python_sitelibdir/bzrlib/tests

%files doc
%dir %bzr_docdir
%bzr_docdir/doc
%bzr_docdir/contrib

%changelog
