Name: ca-certificates
Version: 2015.10.29
Release: alt1

Summary: Common CA Certificates
License: MPL/GPL/LGPL
Group: System/Base
BuildArch: noarch

Source0: mozilla.tar
Source1: alt.tar

BuildRequires: openssl

%description
This package contains a bundle of X.509 certificates of public Certificate
Authorities (CA).  This is useful for any applications to verify SSL/TLS
connection.
Note that certificate authorities whose certificates are included in
this package are not in any way audited for trustworthiness and RFC3647
compliance, and that full responsibility to assess them rests with
the user.

%prep
%setup -c -a1
patch -p1 < mozilla/mk-ca-bundle.patch

%build
export TZ=UTC
pushd mozilla
	./mk-ca-bundle.pl -t crt
popd
pushd alt
	for t in alt; do
		printf '#\n# %%s\n#\n\n' 'ALT CA'
		openssl x509 -sha256 -in $t.crt -text -fingerprint
		printf '\n\n'
	done >crt
popd
cat {mozilla,alt}/crt >ca-bundle.crt

%install
install -pDm644 ca-bundle.crt %buildroot%_datadir/%name/ca-bundle.crt
mkdir -p %{buildroot}%_sysconfdir/pki/tls/certs
ln -s %_datadir/%name/ca-bundle.crt %{buildroot}%_sysconfdir/pki/tls/certs

%files
%dir %_sysconfdir/pki/tls
%dir %_sysconfdir/pki/tls/certs
%_sysconfdir/pki/tls/certs/*
%_datadir/%name

%changelog
