Name: cacti
Version: 0.8.8b
Release: alt1

%define cactidir %_datadir/%name
%define cacticonfdir %_sysconfdir/%name
%define username cacti

Summary: The complete RRDTool-based graphing solution.
Summary(ru_RU.UTF8): Полнофункциональная оболочка для RRDTool.

License: GPL
Group: Monitoring

URL: http://www.cacti.net/
Source0: http://www.cacti.net/downloads/%name-%version.tar.gz
Source1: %name.cfg.php
Source2: %name-readme.alt
Source3: %name.logrotate
Source5: %name-rrdpath.sql
Source7: %name-apache.conf
Source8: %name-lighttpd.conf

# official patches

# unofficial patches
Patch11: %name-alt-config.patch
Patch12: %name-alt-system-adodb.patch
Patch13: %name-ioerror.patch
Patch14: %name-webroot.patch
Patch15: %name-linux_memory.patch
Patch16: %name-log-verbosity.patch
Patch17: %name-ss_disk-array-indices.patch
Patch19: %name-host_name-url.patch
Patch20: %name-fix-php_scripts.patch

Requires: %name-config = %version-%release webserver webserver-common rrd-utils net-snmp net-snmp-utils
BuildPreReq: rpm-macros-webserver-common
BuildArch: noarch

%description
Cacti is a complete frontend to RRDTool. It stores all of the necessary 
information to create graphs and populate them with data in a MySQL database. 
The frontend is completely PHP driven. Along with being able to maintain graphs, 
data sources, and round robin archives in a database, Cacti also handles the data 
gathering. There is SNMP support for those used to creating traffic graphs with 
MRTG.

%description -l ru_RU.UTF8
Cacti - это полнофункциональная оболочка для RRDTool. Программа хранит всю
необходимую информацию для создания и наполнения графиков в базе MySQL.
Программа полностью написана на PHP. Вместе с возможностью управления
графиками, источниками данных и архивами round robin Cacti также занимается
сбором данных.

%package config-php
License: GPL
Group: Monitoring
Summary: Virtual package for php's depend.
Requires: php-snmp php-sockets php-mysql
Conflicts: %name-config-php5
Provides: %name-config = %version-%release

%description config-php
Virtual package for php's depend.

%package config-php5
License: GPL
Group: Monitoring
Summary: Virtual package for php's depend.
Requires: php5-snmp php5-sockets php5-mysql php5-gd2 php5-adodb

Conflicts: %name-config-php
Provides: %name-config = %version-%release

%description config-php5
Virtual package for php5's depend.

%package setup
Summary: Cacti setup package
Group: Monitoring
BuildArch: noarch
Requires: %name = %version-%release
Requires: %name-doc = %version-%release

%description setup
Install this package to configure initial Cacti installation. You
should uninstall this package when you're done, as it considered
insecure to keep the setup files in place.

%description -l ru_RU.UTF8 setup
Установите этот пакет для первоначальной инициализации Cacti.
После завершения настройки Cacti Вы должны удалить этот пакет, что бы обеспечить
безопасную работу приложения.

%package doc
Summary: Documentation for %name
Group: Documentation
BuildArch: noarch

%description doc
Documentation for %name

%prep
%setup -q -n %name-%version

# add official patches

# sed -i /\$config\ =/a\$url_path\ \=\ \"\/cacti\/\"\; include/global.php

%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch19 -p1
%patch20 -p1


mkdir -p sql
mv *.sql sql
# you should run this sql if your database contains path to %{_datadir}...
cp %SOURCE5 sql

%build

#Add sql to one script
#cat cacti.sql cacti-plugin-arch/pa.sql > cacti_all.sql
#mv -f cacti_all.sql cacti.sql

rm -rf cacti-plugin-arch
rm -rf lib/adodb
rm -f log/.htaccess
rm -f cli/.htaccess
rm -f rra/.placeholder
rm -f log/.placeholder

chmod a+rx scripts/*

chmod a+rx cli/*

# make sure cacti runs out of the box
sed -e "s,new_install,%version," -i sql/cacti.sql

%install -n %name-%version
mkdir -p %buildroot{%_sbindir,%_sysconfdir/cron.d,%cacticonfdir,%cactidir/plugins,%_localstatedir/%name/rra,%_logdir/%name}

cp -a *.php README LICENSE %buildroot%cactidir
cp -a cli images include install lib resource scripts sql plugins %buildroot%cactidir
mv -f %buildroot{%cactidir/poller.php,%_sbindir/cacti-poller}
chmod 755 %buildroot%_sbindir/cacti-poller
cp %SOURCE1 %buildroot%cacticonfdir/config.php
touch %buildroot%_logdir/%name/%name.log

cp %SOURCE2 docs/README_ALT.txt
cp %SOURCE7 docs/
cp %SOURCE8 docs/
ln -sf %_docdir/%name-doc-%version %buildroot%cactidir/docs


# install cron
cat << EOF > %buildroot%_sysconfdir/cron.d/cacti
MAILTO=root

*/5 * * * * cacti umask 022; exec /usr/sbin/cacti-poller > /dev/null
EOF

# logrotate
install -D -m 0644 %SOURCE3 %buildroot%_sysconfdir/logrotate.d/cacti

%pre
%_sbindir/useradd -M -d %cactidir -r %username -G %webserver_group > /dev/null 2>&1 ||:
if LANG=C %_bindir/id %username 2>/dev/null | \
grep -qv "groups=[^[:space:]]*(%webserver_group)"; then
echo 'Warning: User %username was not included in the group %webserver_group!'
%_bindir/gpasswd -a %username %webserver_group 
echo '     Added user %username to group %webserver_group.'
fi

%post
%post_service crond

%triggerpostun -- %name < 0.8.7e-alt1
# Migration from previous version
if [ $2 -gt 0 ]; then
echo "Fixing permissions and location rrd,log files after previous package:"
mv -f %_var/www/html/%name/log/* %_logdir/%name/
mv -f %_var/www/html/%name/rra/* %_localstatedir/%name/rra/
chown -v root:%webserver_group  %_logdir/%name/* %_localstatedir/%name/*
chmod -v 660 %_logdir/%name/* %_localstatedir/%name/*
fi

%files
%doc docs/README_ALT.txt docs/CHANGELOG docs/README docs/CONTRIB docs/*.conf
%config(noreplace) %_sysconfdir/cron.d/cacti
%_sbindir/cacti-poller
%dir %attr(750,root,%webserver_group) %cacticonfdir
%attr(640,root,%webserver_group) %config(noreplace) %cacticonfdir/config.php
%config(noreplace) %_sysconfdir/logrotate.d/%name
%dir %cactidir
%cactidir/resource
%cactidir/sql
%cactidir/lib
%cactidir/include
%cactidir/images
%cactidir/plugins
%cactidir/*.php

%dir %cactidir/cli
%attr(755,root,root) %cactidir/cli/*

%dir %cactidir/scripts
%attr(755,root,root) %cactidir/scripts/*

%attr(755,root,%webserver_group) %dir %_localstatedir/%name
%attr(2775,root,%webserver_group) %dir %_localstatedir/%name/rra
%attr(730,root,%webserver_group) %dir %_logdir/%name
%attr(660,root,%webserver_group) %ghost %_logdir/%name/cacti.log

%exclude %cactidir/install
%exclude %cactidir/docs

##files config-php

%files config-php5

%files setup
%cactidir/install

%files doc
%doc docs/html docs/txt
%cactidir/docs

%changelog
