Name: cairo-dock
Version: 3.1.0
Release: alt1.r33
Summary: A light and eye-candy dock to launch your programs easily
License: GPLv3+
Group: Graphical desktop/Other
Url: https://launchpad.net/cairo-dock-core

Source: %name-%version.tar

# Automatically added by buildreq on Thu Apr 12 2012 (-bi)
# optimized out: GraphicsMagick GraphicsMagick-common cmake-modules elfutils fontconfig fontconfig-devel glib2-devel libGL-devel libX11-devel libXext-devel libXfixes-devel libXi-devel libXrender-devel libatk-devel libcairo-devel libcairo-gobject libcairo-gobject-devel libdbus-devel libdbus-glib libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libstdc++-devel libwayland-client libwayland-server pkg-config python-base xorg-compositeproto-devel xorg-fixesproto-devel xorg-inputproto-devel xorg-renderproto-devel xorg-xextproto-devel xorg-xproto-devel
BuildRequires: GConf apt cmake desktop-file-utils gcc-c++ libGLU-devel libXcomposite-devel libXinerama-devel libXtst-devel libcurl-devel libdbus-glib-devel libgtk+3-devel librsvg-devel libxml2-devel wget

# removing GraphicsMagick-ImageMagick-compat and adding
#FIXME: BuildRequires: /usr/bin/convert
BuildRequires: ImageMagick-tools
BuildPreReq: libXdmcp-devel libpixman-devel libpangox-compat-devel
BuildPreReq: libpng-devel libharfbuzz-devel libXcursor-devel
BuildPreReq: at-spi2-atk-devel
BuildPreReq: pkgconfig(xdamage) pkgconfig(xxf86vm) pkgconfig(xrandr)

%description
cairo-dock uses cairo to render nice graphics, and Glitz to use hardware
acceleration. It's fully configurable and can be a taskbar too. You can
easily plug applets into it.

%package devel
Summary: Development files for cairo-dock
Group: Development/Other
Requires: %name = %version-%release

%description devel
cairo-dock uses cairo to render nice graphics, and Glitz to use hardware
acceleration. It's fully configurable and can be a taskbar too. You can
easily plug applets into it.

This package provides the include files and library for cairo-dock functions.

%prep
%setup -n %name-%version

%build
%cmake
%make_build -C BUILD

%install
%make_install DESTDIR=%buildroot install -C BUILD

%find_lang %name

mkdir -p %buildroot{%_niconsdir,%_miconsdir,%_liconsdir}
convert data/cairo-dock.svg -resize 48x48 %buildroot%_liconsdir/%name.png
convert data/cairo-dock.svg -resize 16x16 %buildroot%_miconsdir/%name.png
convert data/cairo-dock.svg -resize 32x32 %buildroot%_niconsdir/%name.png
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=System \
	--add-category="GNOME;GTK;Utility;X-Desktop" \
	%buildroot%_desktopdir/cairo-dock.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=System \
	--add-category="GNOME;GTK;Utility;X-Desktop" \
	%buildroot%_desktopdir/cairo-dock-cairo.desktop

%files -f %name.lang
%_bindir/*
%_libdir/*.so.*
%_man1dir/*.1.*
%_datadir/%name
%_desktopdir/*.desktop
%_pixmapsdir/*.svg
%_niconsdir/%name.png
%_miconsdir/%name.png
%_liconsdir/%name.png

%files devel
%_includedir/%name
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
