BuildRequires: /proc
BuildRequires: jpackage-compat
# Copyright (c) 2000-2011, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define	jarname		carol_irmi


Name:		carol-irmi
Summary:	IRMI: Intercepting RMI implementation for the Java platform
Url:		http://carol.objectweb.org/
Version:	1.0.1
Release:	alt1_3jpp6
Epoch:		0
License:	LGPL
Group:		Development/Java
BuildArch:	noarch
Source0:	carol-irmi-%{version}-src.tar.gz
Source1:	irmi-1.0.1.pom

BuildRequires:  jpackage-utils >= 0:1.7.5
BuildRequires:	ant >= 0:1.7.1
BuildRequires:	ant-junit
BuildRequires:	junit
BuildRequires:  apache-commons-collections >= 3.1
Requires:  apache-commons-collections >= 3.1
Requires(post):    jpackage-utils >= 0:1.7.5
Requires(postun):  jpackage-utils >= 0:1.7.5
Source44: import.info


%description
The irmi package is a JDK agnostic RMI implementation supporting
pluggable interceptors and local call optimization. It uses standard
JRMP stubs and uses the javax.rmi.CORBA.PortableRemoteObjectDelegate
interface to plug into any JDK. This implementation may be enabled by
setting the system property named javax.rmi.CORBA.PortableRemoteObjectClass
to the value "org.objectweb.carol.irmi.PRO".


%package javadoc
Summary:	Javadoc for %{name}
Group:		Development/Documentation
BuildArch: noarch

%description javadoc
Javadoc for %{name}.

%prep
%setup -qq -n irmi
chmod -R go=u-w *

find . -name "*.jar" \
       -exec rm -f {} \;

%build
build-jar-repository externals commons-collections junit

#ant test jar javadoc
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 jar javadoc

%install
                                                                                
# jars
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}

install -m 644 build/irmi.jar \
        $RPM_BUILD_ROOT%{_javadir}/ow_%{jarname}-%{version}.jar
pushd $RPM_BUILD_ROOT%{_javadir}
ln -sf ow_%{jarname}-%{version}.jar ow_%{jarname}.jar
popd

# poms
install -d -m 755 $RPM_BUILD_ROOT%{_datadir}/maven2/poms
install -m 644 %{SOURCE1} \
    $RPM_BUILD_ROOT%{_datadir}/maven2/poms/JPP-ow_%{jarname}.pom
%add_to_maven_depmap org.objectweb.carol irmi %{version} JPP ow_%{jarname}

# javadoc
install -d -m 755 $RPM_BUILD_ROOT%{_javadocdir}/%{name}-%{version}
cp -pr build/doc/* $RPM_BUILD_ROOT%{_javadocdir}/%{name}-%{version}
ln -s %{name}-%{version} $RPM_BUILD_ROOT%{_javadocdir}/%{name} # ghost symlink

%files
%{_javadir}/ow_%{jarname}.jar
%{_javadir}/ow_%{jarname}-%{version}.jar
%{_mavendepmapfragdir}/*
%{_datadir}/maven2/poms/*

%files javadoc
%doc %{_javadocdir}/%{name}-%{version}
%doc %{_javadocdir}/%{name}

%changelog
