Name: cdemu-daemon
Version: 3.0.0
Release: alt2.M70P.1

Summary: CDEmu daemon
License: GPLv2+
Group: System/Servers

URL: http://cdemu.sourceforge.net
Packager: Nazarov Denis <nenderus@altlinux.org>

Source0: http://downloads.sourceforge.net/cdemu/%name-%version.tar.bz2 
Source1: vhba.init
Source2: vhba.service

BuildRequires: cmake
BuildRequires: libao-devel >= 0.8.0
BuildRequires: libmirage-devel >= 3.0.0

%description
This is CDEmu daemon, the userspace daemon part of the userspace-cdemu suite, a 
free, GPL CD/DVD-ROM device emulator for linux.

It receives SCSI commands from kernel module and processes them, passing the 
requested data back to the kernel. Daemon implements the actual virtual device; 
one instance per each device registered by kernel module. It uses libMirage, an 
image access library that is part of userspace-cdemu suite, for the image access 
(e.g. sector reading).

The daemon registers itself on D-BUS' system or session bus (depending on the
options passed to it) where it exposes an interface that can be used by clients
to control it.

%prep
%setup -q

%build
%__mkdir_p %_target_platform
pushd %_target_platform

cmake .. \
         -DCMAKE_INSTALL_PREFIX:PATH="%prefix" \
         -DCMAKE_INSTALL_LIBEXECDIR:PATH="%_libexecdir/%name" \
         -DCMAKE_C_FLAGS:STRING="%optflags" \
         -DCMAKE_BUILD_TYPE:STRING="Release"
         
popd

%make_build -C %_target_platform

%install
%makeinstall_std -C %_target_platform
%__install -Dp -m0755 %SOURCE1 %buildroot%_initdir/vhba
%__install -Dp -m0644 %SOURCE2 %buildroot%_unitdir/vhba.service

%preun
%preun_service vhba
/sbin/service vhba condstop ||:

%post
%post_service vhba
/sbin/service vhba condrestart ||:

%files
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/%name-session.sh
%_man8dir/%name.*
%dir %_datadir/dbus-1
%dir %_datadir/dbus-1/services
%_datadir/dbus-1/services/*.service
%_initdir/vhba
%dir /lib/systemd
%dir %_unitdir
%_unitdir/vhba.service

%changelog
