Name: cegui06
Version: 0.6.2
Release: alt7

Summary: Free library providing windowing and widgets for graphics APIs / engines
Group: System/Libraries
License: MIT
Url: http://www.cegui.org.uk
Packager: Vitaly Kuznetsov <vitty@altlinux.ru>

Source: http://downloads.sourceforge.net/crayzedsgui/CEGUI-%version.tar
Source1: http://downloads.sourceforge.net/crayzedsgui/CEGUI-DOCS-%version.tar
Patch1: cegui-0.6.0-release-as-so-ver.patch
Patch2: cegui-0.6.0-userverso.patch
Patch3: cegui-0.6.2-new-DevIL.patch
Patch4: cegui-0.6.2-new-tinyxml.patch
Patch5: cegui-0.6.2-gcc46.patch
Patch6: cegui-0.6.1-libdl-alt.patch

BuildRequires: gcc-c++
BuildRequires: expat-devel
BuildRequires: libfreetype-devel
BuildRequires: libICE-devel libX11-devel libXext-devel
BuildRequires: libGLU-devel
BuildRequires: libSM-devel
BuildRequires: pcre-devel
BuildRequires: libglew-devel

%description
Crazy Eddie's GUI System is a free library providing windowing and widgets for
graphics APIs / engines. This package contains the older version 0.6 for
apps which cannot be easily ported to 0.7. As such this version has been build
without additional image codecs or xml parsers.

%package devel
Summary: Development files for cegui
Group: Development/C++
Requires: %name = %version-%release
Requires: libGLU-devel

%description devel
Development files for cegui

%prep
%setup -qb1 -qn CEGUI-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

# Permission fixes for debuginfo RPM
chmod -x include/falagard/*.h

# Delete zero length file
rm -f documentation/api_reference/keepme

# Encoding fixes
iconv -f iso8859-1 AUTHORS -t utf8 > AUTHORS.conv && mv -f AUTHORS.conv AUTHORS
iconv -f iso8859-1 TODO -t utf8 > TODO.conv && mv -f TODO.conv TODO
iconv -f iso8859-1 README -t utf8 > README.conv && mv -f README.conv README

# Make makefile happy even though we've removed the (unused) included copy of
# GLEW due to license reasons
mkdir -p RendererModules/OpenGLGUIRenderer/GLEW/GL
touch RendererModules/OpenGLGUIRenderer/GLEW/GL/glew.h
touch RendererModules/OpenGLGUIRenderer/GLEW/GL/glxew.h
touch RendererModules/OpenGLGUIRenderer/GLEW/GL/wglew.h
touch RendererModules/OpenGLGUIRenderer/GLEW/GLEW-LICENSE

%build
%configure \
	--disable-static --disable-samples --disable-lua-module \
	--disable-corona --disable-devil --disable-silly --disable-freeimage \
	--disable-irrlicht-renderer --disable-directfb-renderer \
	--disable-xerces-c --disable-libxml --disable-tinyxml \
	--with-default-xml-parser=ExpatParser \
	--with-default-image-codec=TGAImageCodec \
	--with-pic
# We do not want to get linked against a system copy of ourselves!
sed -i 's|-L%_libdir||g' RendererModules/OpenGLGUIRenderer/Makefile
# Don't use rpath!
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
make %{?_smp_mflags}

%install
%make_install install DESTDIR=%buildroot
find %buildroot -name '*.la' -exec rm -f {} ';'

# Move some things around to make cegui06-devel co-exist peacefully with
# cegui-devel
mkdir -p %buildroot/%_libdir/CEGUI-0.6
for i in libCEGUIBase libCEGUIExpatParser libCEGUIFalagardWRBase \
	 libCEGUIOpenGLRenderer libCEGUITGAImageCodec; do
    rm %buildroot/%_libdir/$i.so
    ln -s ../$i-%version.so %buildroot/%_libdir/CEGUI-0.6/$i.so
done
mv %buildroot/%_includedir/CEGUI %buildroot/%_includedir/CEGUI-0.6
mv %buildroot/%_datadir/CEGUI %buildroot/%_datadir/CEGUI-0.6
sed -e 's|/CEGUI|/CEGUI-0.6|g' \
    -e 's|libdir=%_libdir|libdir=%_libdir/CEGUI-0.6|g' \
    -i %buildroot/%_libdir/pkgconfig/*.pc
for i in %buildroot/%_libdir/pkgconfig/*.pc; do
    mv $i `echo $i | sed 's|\.pc\$|-0.6.pc|'`
done

%files
%doc AUTHORS ChangeLog COPYING README TinyXML-License TODO
%_libdir/libCEGUI*-%version.so

%files devel
%_libdir/CEGUI-0.6/*.so
%_pkgconfigdir/CEGUI-OPENGL-0.6.pc
%_pkgconfigdir/CEGUI-0.6.pc
%_includedir/CEGUI-0.6
%_datadir/CEGUI-0.6

%changelog
