Name: celestia
Version: 1.6.1
Release: alt2.4
License: GPL
Group: Education
Summary: A real-time visual space simulation
URL: http://www.shatters.net/celestia/
Source: %{name}-%{version}.tar.gz
Patch1: celestia-1.4.0-desktop-fix.patch
Patch2: celestia-1.6.1-alt-gcc4.6.patch
Patch3: celestia-1.6.1-alt-DSO.patch
Patch4: celestia-1.6.1-alt-libpng15.patch
Patch5: celestia-1.6.1-alt-glibc-2.16.patch

BuildRequires: fontconfig freetype2 gcc-c++ kdelibs-devel libtqt-devel
BuildRequires: libjpeg-devel libpng-devel libqt3-devel
BuildRequires: libqt3-settings libstdc++-devel xml-utils 
BuildRequires: libICE-devel, libSM-devel, libX11-devel, libXau-devel, libXaw-devel, libXrandr-devel, libXdmcp-devel, libXext-devel, libXfixes-devel, libXfont-devel, libXft-devel, libXi-devel, libXmu-devel, libXpm-devel, libXrender-devel, libXres-devel, libXScrnSaver-devel, libXinerama-devel, libXt-devel, libXtst-devel, libXxf86dga-devel, libXcomposite-devel, libXxf86vm-devel, libdmx-devel, libfontenc-devel, libGLU-devel, libXdamage-devel, libxkbfile-devel, xcursorgen, xorg-font-utils, libXvMC-devel, libXcursor-devel, libXevie-devel, libXv-devel, xorg-xtrans-devel, xorg-util-macros, xorg-sgml-doctools
BuildRequires: zlib-devel liblua5-devel libtheora-devel

BuildRequires: libGConf2-devel GConf libgtk+2-devel glib-devel libgnomeui-devel libgtkglext-devel
Requires(post): GConf
Requires: libpng12 >= 1.2.38 


%description
Celestia is a free real-time space simulation that
lets you experienceour universe in three dimensions.
Unlike most planetarium software, Celestia does not
confine you to the surface of the Earth. You can
travelthroughout the solar system, to any of over
100,000 stars, or even beyondthe galaxy.

%package common
Group: Education
Summary: A real-time visual space simulation (common part)
Requires: celestia-ui = %version-%release
Obsoletes: celestia

%description common
This is a common part of Celestia

Celestia is a free real-time space simulation that
lets you experienceour universe in three dimensions.
Unlike most planetarium software, Celestia does not
confine you to the surface of the Earth. You can
travelthroughout the solar system, to any of over
100,000 stars, or even beyondthe galaxy.

%package kde
Group: Education
Summary: A real-time visual space simulation (KDE frontend)
Requires: celestia-common = %version-%release
Provides: celestia-ui = %version-%release
Provides: celestia
Obsoletes: celestia

%description kde
This is a KDE3 frontend to Celestia

Celestia is a free real-time space simulation that
lets you experienceour universe in three dimensions.
Unlike most planetarium software, Celestia does not
confine you to the surface of the Earth. You can
travelthroughout the solar system, to any of over
100,000 stars, or even beyondthe galaxy.


%package gnome
Group: Education
Summary: A real-time visual space simulation (GNOME frontend)
Requires: celestia-common = %version-%release
Provides: celestia-ui = %version-%release

%description gnome
This is a GNOME frontend ro Celestia

Celestia is a free real-time space simulation that
lets you experienceour universe in three dimensions.
Unlike most planetarium software, Celestia does not
confine you to the surface of the Earth. You can
travelthroughout the solar system, to any of over
100,000 stars, or even beyondthe galaxy.


%prep
%setup -q 
%patch1 -p0
%patch2 -p2
%patch3 -p2
%patch4 -p2
%patch5 -p2
##%__aclocal --force
##%__automake --foreign
autoreconf
##%__subst 's,\.la,\.so,' configure


%build
PATH=$PATH:/usr/lib/kde3/
export PATH
%add_optflags -fpermissive
%configure --disable-rpath --with-kde --without-arts
make echo=echo
mv src/celestia/celestia src/celestia/celestia-kde
mkdir -p  %buildroot{%_bindir,%_datadir,%_desktopdir,%_liconsdir}
make install DESTDIR=%buildroot echo=echo


make clean
%configure --disable-rpath --with-gnome --without-arts
make echo=echo


export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
export GCONF_SCHEMA_FILE_DIR="%{buildroot}%{_sysconfdir}/gconf/schemas"
make install DESTDIR=%buildroot echo=echo
##   (?) ,     %buildroot%buildroot
%__rm -f %buildroot%buildroot
find %buildroot%_datadir -name %{name}.desktop -exec rm {} \;
%__install src/celestia/kde/data/%{name}.desktop %buildroot%_desktopdir
install -D -m 644 src/celestia/gtk/data/%{name}.png %buildroot%_liconsdir/%{name}.png
install -m 755 src/celestia/celestia-kde %buildroot/%_bindir
install -m 755 src/celestia/celestia %buildroot/%_bindir/celestia-gnome
rm %buildroot/%_bindir/celestia

install -d %buildroot//etc/alternatives/packages.d
cat >%buildroot/etc/alternatives/packages.d/%name-kde <<__EOF__
%_bindir/celestia      %_bindir/celestia-kde 20
__EOF__

cat >%buildroot/etc/alternatives/packages.d/%name-gnome <<__EOF__
%_bindir/celestia      %_bindir/celestia-gnome 10
__EOF__

%find_lang %{name}
##(cd %buildroot/%_datadir/apps && symlinks -c .)

%pre
[ ! -d %_datadir/apps/%name ] || %__rm -fr %_datadir/apps/%name

%post gnome
export GCONF_CONFIG_SOURCE="$(gconftool-2 --get-default-source)"
gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/celestia.schemas &>/dev/null || :

%preun gnome
export GCONF_CONFIG_SOURCE="$(gconftool-2 --get-default-source)"
gconftool-2 --makefile-uninstall-rule %{_sysconfdir}/gconf/schemas/celestia.schemas &>/dev/null || :

%files -f %{name}.lang common
%_datadir/apps/*
%_datadir/applnk/*
%_datadir/config/*
## %_datadir/locale/*
%_datadir/locale/*/*/celestia_constellations.mo
%_datadir/mimelnk/*
%_datadir/services/*
%_datadir/%{name}
%_liconsdir/%{name}.png
%_desktopdir/%{name}.desktop
%doc ChangeLog TRANSLATORS README NEWS 

%files gnome
%_bindir/celestia-gnome
/etc/gconf/schemas/celestia.schemas
/etc/alternatives/packages.d/%name-gnome

%files kde
%_bindir/celestia-kde
/etc/alternatives/packages.d/%name-kde

%changelog
