%define ver_major 3.8
%define api_ver 3.0
%define gst_api_ver 1.0
%def_disable static
%def_disable gtk_doc
%def_enable introspection

Name: cheese
Version: %ver_major.3
Release: alt1

Summary: Cheese is a Photobooth-inspired application for taking pictures and videos
License: GPL
Group: Video
Url: http://www.gnome.org/projects/cheese

Source: ftp://ftp.gnome.org/pub/gnome/sources/cheese/%ver_major/%name-%version.tar.xz

# from configure.ac
%define glib_ver 2.28.0
%define gtk_ver 3.4.4
%define desktop_ver 3.0.0
%define gst_ver 0.11
%define vala_ver 0.18.0
%define clutter_ver 1.10.0

Requires: lib%name = %version-%release
Requires: gnome-video-effects
# camerabin used for taking photos and videos
Requires: gst-plugins-bad%gst_api_ver
# matroska (webmmux), vp8enc
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-ugly%gst_api_ver

BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libgnome-desktop3-devel >= %desktop_ver
BuildPreReq: gst-plugins%gst_api_ver-devel >= %gst_ver
BuildPreReq: gst-plugins-bad%gst_api_ver-devel >= %gst_ver
BuildPreReq: gstreamer%gst_api_ver-utils >= %gst_ver
BuildPreReq: gst-plugins-good%gst_api_ver >= %gst_ver
BuildPreReq: libclutter-devel >= %clutter_ver
BuildPreReq: vala-tools >= %vala_ver
BuildRequires: gnome-common intltool yelp-tools gtk-doc desktop-file-utils
BuildRequires: librsvg-devel libcanberra-gtk3-devel
BuildRequires: libgudev-devel
BuildRequires: libX11-devel libXtst-devel libXext-devel
BuildRequires: libclutter-gst2.0-devel libclutter-gtk3-devel
BuildRequires: gnome-video-effects-devel gsettings-desktop-schemas-devel
BuildRequires: nautilus-sendto-devel
%{?_enable_introspection:BuildRequires: libgdk-pixbuf-gir-devel libclutter-gir-devel libgstreamer%gst_api_ver-gir-devel}
# for check
BuildRequires: /proc dbus-tools-gui xvfb-run

%description
Cheese is a Photobooth-inspired GNOME application for taking pictures
and videos from a webcam. It also includes fancy graphical effects
based on the gstreamer-backend.

%package -n lib%name
Summary: Cheese libraries
Group: System/Libraries

%description -n lib%name
Cheese is a Photobooth-inspired GNOME application for taking pictures
and videos from a webcam. It also includes fancy graphical effects
based on the gstreamer-backend. This package contains Cheese libraries.

%package -n lib%name-devel
Summary: Cheese development files
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains files necessary to develop applications that use
Cheese libraries.

%package -n lib%name-devel-doc
Summary: Cheese development documentation
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
This package contains documentation necessary to develop applications
that use Cheese libraries.

%package -n lib%name-gir
Summary: GObject introspection data for the Cheese
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Cheese library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Cheese
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Cheese library.


%prep
%setup -q

%build
%autoreconf
%configure \
	%{subst_enable static} \
	--disable-schemas-compile \
	%{?_enable_gtk_doc:--enable-gtk-doc}

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%check
#xvfb-run %make check

%files -f %name.lang
%_bindir/%name
%_desktopdir/%name.desktop
%_datadir/cheese/
%_datadir/icons/hicolor/*/*/*.*
%config %_datadir/glib-2.0/schemas/*
%_man1dir/%name.1.*
%doc AUTHORS NEWS README

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/Cheese-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Cheese-%api_ver.gir
%endif

%changelog
