%define shortversion %(echo %{version} | sed -e 's/\([0-9]*\.[0-9]*\)\.[0-9]*/\1/')
%define wwwroot /var/www/cherokee

# This script is not only for Linux, so we have to hide it from rpm's req finder
# to avoid generated dependency on Solaris utilities... :)
%add_findreq_skiplist %_bindir/cherokee-panic

Name: cherokee
Version: 1.2.101
Release: alt2.qa1

Summary: Flexible and Fast Webserver
License: GPLv2+
Group: System/Servers

Url: http://www.cherokee-project.com/
Source: http://www.cherokee-project.com/download/%shortversion/%version/cherokee-%version.tar.gz
Source1: cherokee.init
Source2: cherokee.logrotate

Requires: %name-data = %version-%release

# Automatically added by buildreq on Sat Jun 11 2011
BuildRequires: bzlib-devel libGeoIP-devel libavformat-devel libldap-devel libmysqlclient-devel libpam-devel libpcre-devel libssl-devel php5-fpm-fcgi python-base

%description
Cherokee is a very fast, flexible and easy to configure Web Server. It supports
the widespread technologies nowadays: FastCGI, SCGI, PHP, CGI, TLS and SSL
encrypted connections, Virtual hosts, Authentication, on the fly encoding,
Apache compatible log files, and much more.

%package data
Summary: Architecture independent data files for cherokee web server
Group: System/Servers
BuildArch: noarch

%description data
Architecture independent data files for cherokee web server.

%package devel
Summary: Development files of cherokee
Group: Development/C
Requires: %name = %version-%release

%description devel
This package holds the development files for cherokee web server.

%prep
%setup

# Quick fix naive system pcre detection
subst 's#"pcre.h"#"pcre/pcre.h"#g' configure

%build
subst 's#/log/cherokee\.#/log/cherokee/cherokee\.#' cherokee.conf.sample.pre
%configure -with-wwwroot=%wwwroot --localstatedir=/var --docdir=%_datadir/cherokee \
	--disable-static --disable-internal-pcre
# strip rpath
subst 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
subst 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%make_build

%install
%makeinstall_std
install -d %buildroot%_logdir/cherokee
install -pDm 755 %_sourcedir/cherokee.init %buildroot%_initrddir/cherokee
install -pDm 644 %_sourcedir/cherokee.logrotate %buildroot/etc/logrotate.d/cherokee

%find_lang cherokee

%post
%post_service cherokee

%preun
%preun_service cherokee

%files -f cherokee.lang
%dir %_sysconfdir/cherokee
%config(noreplace) %_sysconfdir/cherokee/*
%config(noreplace) %_initrddir/cherokee
%config(noreplace) /etc/logrotate.d/cherokee
%_bindir/*
%_sbindir/*
%_libdir/cherokee
%_libdir/lib*.so.*
%_man1dir/*
%_logdir/cherokee
%exclude %_libdir/cherokee/*.la
%exclude %_bindir/cherokee-config

%files data
%_datadir/cherokee
%wwwroot/

%files devel
%_bindir/cherokee-config
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%_datadir/aclocal/*

%changelog
