# Conditional switches (ie. use with rpmbuild --rebuild):
#   --with glibc   Compile chkrootkit against glibc-static

%def_without glibc

%if_with glibc
Name: chkrootkit-glibc
%else
Name: chkrootkit
%endif
Version: 0.49
Release: alt1

Summary: Check rootkits
Summary(ru_RU.KOI8-R):       

License: BSD
Group: Monitoring
Url: http://www.chkrootkit.org/
Packager: Slava Semushin <php-coder@altlinux.ru>

Source: ftp://ftp.pangeia.com.br/pub/seg/pac/%name-%version.tar.gz
Patch0: chkrootkit-alt-libpath.patch
Patch2: chkrootkit-0.45-alt-ifpromisc.patch
Patch3: strings.c.patch

Requires: binutils coreutils findutils sed gawk grep net-tools procps crontabs

%if_with glibc
BuildPreReq: glibc-devel-static
%else
BuildPreReq: dietlibc
%endif

%define cron_daily %_sysconfdir/cron.daily


%description
Chkrootkit is a tool to locally check for signs of a rootkit.

%description -l ru_RU.KOI8-R
Chkrootkit         
       .

%prep
%setup
%patch0 -p2 -b .libpath
%patch2 -p1
%patch3

sed -i 's|@CHKROOTKIT_DIR@|%_libdir/%name|' %name

%build
%if_with glibc
make               CFLAGS="-DHAVE_LASTLOG_H -DLASTLOG_FILENAME='\"/var/log/lastlog\"' -DWTEMP_FILENAME='\"/var/log/wtmp\"'" LDFLAGS=-static
%else
make CC="diet gcc" CFLAGS="-DHAVE_LASTLOG_H -DLASTLOG_FILENAME='\"/var/log/lastlog\"' -DWTEMP_FILENAME='\"/var/log/wtmp\"' -Os  -s -static" LDFLAGS=-static
%endif

%install
install -pD -m 755 chkrootkit %buildroot%_sbindir/chkrootkit

for p in chklastlog chkwtmp ifpromisc chkproc chkdirs check_wtmpx strings-static chkutmp; do
	install -pD -m 755 "$p" "%buildroot%_libdir/%name/$p"
done

mkdir -p %buildroot%cron_daily
cat > %buildroot%cron_daily/%name << __EOF__
%_sbindir/%name -q
__EOF__

%files
%doc README* COPYRIGHT
%_sbindir/*
%_libdir/%name
%attr(700,root,root) %cron_daily/%name

%changelog
