%set_verify_elf_method textrel=relaxed

%def_disable debug
%def_disable nacl
%def_disable verbose

%if_enabled debug
%define buildtype Debug
%else
%define buildtype Release
%endif

Name:           chromium
Version:        38.0.2125.122
Release:        alt0.M70P.2

Summary:        An open source web browser developed by Google
License:        BSD-3-Clause and LGPL-2.1+
Group:          Networking/WWW
Url:            http://code.google.com/p/chromium/

Source0:        %name-%version.tar.gz
Source10:		depot_tools.tar

Source30:       master_preferences
Source31:       default_bookmarks.html
Source99:       chrome-wrapper
Source100:      %name.sh
Source101:      chromium.desktop
Source102:      chromium.xml
Source200:      %name.default
Provides:       chromium-browser = %version
Obsoletes:      chromium-browser < %version

## Start Patches
# Patches from SUSE
# PATCH-FIX-OPENSUSE Fix the WEBRTC cpu-features for the ARM builds
Patch6:	 	chromium-arm-webrtc-fix.patch
# PATCH-FIX-OPENSUSE removes build part for courgette
Patch13:	chromium-no-courgette.patch
# PATCH-FIX-OPENSUSE enables reading of the master preference
Patch14:	chromium-master-prefs-path.patch
# PATCH-FIX-OPENSUSE Fix some includes specifically for the GCC version used
Patch20:	chromium-gcc-fixes.patch
# PATCH-FIX-UPSTREAM Add more charset aliases
Patch64:	chromium-more-codec-aliases.patch
# PATCH-FIX-OPENSUSE Compile the sandbox with -fPIE settings
Patch66:	chromium-sandbox-pie.patch

# TODO Obsoleted patches from SUSE
# PATCH-FIX-OPENSUSE patches in system zlib library
Patch8:		chromium-codechanges-zlib.patch
# PATCH-FIX-OPENSUSE patches in system glew library
Patch17:	chromium-system-glew.patch
# PATCH-FIX-OPENSUSE patches in system speex library
Patch28:	chromium-system-speex.patch
# PATCH-FIX-OPENSUSE patches in the system libvpx library
Patch32:	chromium-system-libvpx.patch

# Patches from other vendors
# ALT: Fix krb5 includes path
Patch69:	chromium-alt-krb5-fix-path.patch
# Set appropriate desktop file name for default browser check
Patch71:	chromium-set-desktop-file-name.patch

# Patch form Gentoo
# Fix build with GCC 4.7 (https://bugs.gentoo.org/show_bug.cgi?id=525374)
Patch75:	chromium-can-build-with-gcc4.7.patch

# Patches from Debian
Patch80:	chromium-nspr.patch
Patch81:	chromium-nss.patch
Patch82:	chromium-expat.patch
Patch85:	chromium-fix-manpage.patch
Patch86:	chromium-icon.patch
# Old, but specific
Patch87:	chromium-cups1.5.patch
Patch88:	chromium-arm-no-float-abi.patch
Patch90:	chromium-gcc4.7.patch
Patch91:	chromium-arm.patch
# New from Debian
Patch92:	chromium-third-party-cookies-off-by-default.patch
Patch93:	chromium-ps-print.patch
Patch94:	chromium-linker-flags.patch

# Patches from ALT Linux
Patch95:	chromium-fix-shrank-by-one-character.patch
Patch96:	chromium-set-ffmpeg-flags-for-multimedia.patch
# See https://code.google.com/p/chromium/issues/detail?id=393535
Patch97:	chromium-fix-russian-translations.patch
Patch98: 	chromium-fix-ffmpeg-build-on-ia32.patch
Patch99:    chromium-alt-use-nss-compat.patch

# Backport from upstream
Patch110:   chromium-support-ModeSwitch-key.patch

BuildRequires: /proc

BuildRequires:  bison
BuildRequires:  bzlib-devel
BuildRequires:  flex
BuildRequires:  gcc-c++
BuildRequires:  gperf
BuildRequires:	gst-plugins-devel
BuildRequires:  libalsa-devel
BuildRequires:  libavcodec-devel
BuildRequires:  libavformat-devel
BuildRequires:  libavutil-devel
BuildRequires:  libcap-devel
BuildRequires:  libcups-devel
BuildRequires:  libdbus-glib-devel
BuildRequires:  libelf-devel
BuildRequires:  libexif-devel
BuildRequires:  libevent1.4-devel
BuildRequires:  libexpat-devel
BuildRequires:  libflac-devel
BuildRequires:  libglew-devel
BuildRequires:  libgcrypt-devel
BuildRequires:  libgnome-keyring-devel
BuildRequires:  libhunspell-devel
BuildRequires:  libharfbuzz-devel
#BuildRequires:  libicu-devel >= 4.0
BuildRequires:  libkrb5-devel
BuildRequires:  libnspr-devel
BuildRequires:  libnss-compat-devel
BuildRequires:  libopus-devel
BuildRequires:  libpam-devel
BuildRequires:  libpci-devel
BuildRequires:  libpng12-devel
BuildRequires:  libpulseaudio-devel
BuildRequires:  libspeechd-devel >= 0.8
BuildRequires:  libspeex-devel
BuildRequires:  libsqlite3-devel
BuildRequires:  libssl-devel
BuildRequires:  libudev-devel
BuildRequires:  libvpx-devel
BuildRequires:  libx264-devel
BuildRequires:  libxslt-devel
BuildRequires:  libXdamage-devel
BuildRequires:  libXrandr-devel
BuildRequires:  libXtst-devel
BuildRequires:  libyasm-devel
BuildRequires:  perl-Switch
BuildRequires:  ninja-build
BuildRequires:  pkg-config
BuildRequires:  pkgconfig(cairo) >= 1.6
BuildRequires:  pkgconfig(dbus-1)
BuildRequires:  pkgconfig(gconf-2.0)
BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(gtk+-2.0)
BuildRequires:  pkgconfig(libxml-2.0)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(xcomposite)
BuildRequires:  pkgconfig(xcursor)
BuildRequires:  pkgconfig(xext)
BuildRequires:  pkgconfig(xfixes)
BuildRequires:  pkgconfig(xi)
BuildRequires:  pkgconfig(xrender)
BuildRequires:  pkgconfig(xscrnsaver)
BuildRequires:  pkgconfig(xt)
BuildRequires:  python-devel
BuildRequires:  python-module-PyXML
BuildRequires:  python-modules-compiler
BuildRequires:  python-modules-email
BuildRequires:  python-modules-encodings
BuildRequires:  python-modules-json
BuildRequires:  python-modules-logging
BuildRequires:  subversion
BuildRequires:  wdiff
BuildRequires:  yasm
#BuildRequires:  zlib-devel

Provides: 		webclient, /usr/bin/xbrowser
BuildPreReq: 	alternatives >= 0.2.0
PreReq(post,preun): alternatives >= 0.2

%add_findreq_skiplist %_libdir/%name/xdg-settings
%add_findreq_skiplist %_libdir/%name/xdg-mime

%filter_from_requires /^\/usr\/%_lib\/nss-compat/d
Requires: libnss-compat

%description
Chromium is an open-source browser project that aims to build a safer,
faster, and more stable way for all Internet users to experience the web.

%package kde

Summary:        Update to chromium to use KDE's kwallet to store passwords
License:        BSD-3-Clause and LGPL-2.1+
Group:          Networking/WWW
Conflicts:      chromium-gnome
Conflicts:      chromium-desktop-gnome
Provides:       chromium-password = %version
Provides:		chromium-desktop-kde = %version
Obsoletes:		chromium-desktop-kde < %version
Requires:       chromium = %version
Requires:       kde4base-runtime-core

%description kde
By using the update-alternatives the password store for Chromium is
changed to utilize KDE's kwallet. Please be aware that by this change
the old password are no longer accessible and are also not converted
to kwallet.

%package gnome

Summary:        Update to chromium to use Gnome keyring to store passwords
License:        BSD-3-Clause and LGPL-2.1+
Group:          Networking/WWW
Conflicts:      chromium-desktop-kde
Conflicts:      chromium-kde
Provides:       chromium-password = %version
Provides:		chromium-desktop-gnome = %version
Obsoletes:		chromium-desktop-gnome < %version
Requires:       chromium = %version
Requires:       gnome-keyring

%description gnome
By using the update-alternatives the password store for Chromium is
changed to utilize Gnome's Keyring. Please be aware that by this change
the old password are no longer accessible and are also not converted
to Gnome's Keyring.

%prep
%setup -q -n %name
tar xf %SOURCE10 -C src

%patch6  -p0 -d src
%patch8  -p2
%patch13 -p2
%patch14 -p2
%patch17 -p1
%patch20 -p0 -d src
%patch28 -p2
%patch64 -p0 -d src
%patch66 -p1
%patch69 -p2
%patch71 -p2
%patch75 -p0 -d src

%patch80 -p2
#%%patch81 -p1
%patch82 -p1
%patch85 -p1
%patch86 -p0
%patch87 -p1
%patch88 -p1
%patch90 -p1
%patch91 -p1
%patch92 -p1
%patch93 -p1
%patch94 -p1
%patch95 -p0
%patch96 -p0
%patch97 -p1 -d src
%patch98 -p0
%patch99 -p1
%patch110 -p1 -d src

# Move vpx/internal/vpx_codec_internal.h to one directory up
grep -Rl 'vpx/internal/vpx_codec_internal.h' src/third_party/libvpx | xargs subst 's,vpx/internal/vpx_codec_internal.h,vpx/vpx_codec_internal.h,'
mv -f src/third_party/libvpx/source/libvpx/vpx/{internal/,}vpx_codec_internal.h

# Make sure that the requires legal files can be found
cp -a src/AUTHORS src/LICENSE .

%build
## create make files

PARSED_OPT_FLAGS=`echo \'%optflags -DUSE_SYSTEM_LIBEVENT -fPIC -fno-ipa-cp -fno-strict-aliasing \' | sed "s/ /',/g" | sed "s/',/', '/g"`
for i in src/build/common.gypi; do
	sed -i "s|'-march=pentium4',||g" $i
%ifnarch x86_64
	sed -i "s|'-mfpmath=sse',||g" $i
%endif
	sed -i "s|'-O<(debug_optimize)',||g" $i
	sed -i "s|'-m32',||g" $i
	sed -i "s|'-fno-exceptions',|$PARSED_OPT_FLAGS|g" $i
	sed -i "s|'-Werror'|'-Wno-error'|g" $i
done

# Set up Google API keys, see http://www.chromium.org/developers/how-tos/api-keys .
# Note: these are for ALT Linux use ONLY. For your own distribution,
# please get your own set of keys.
_google_api_key='AIzaSyAIIWz7zaCwYcUSe3ZaRPviXjMjkBP4-xY'
_google_default_client_id='1018394967181.apps.googleusercontent.com'
_google_default_client_secret='h_PrTP1ymJu83YTLyz-E25nP'

pushd src

./build/gyp_chromium -f ninja build/all.gyp \
	-Dbuild_ffmpegsumo=1 \
%if_disabled nacl
	-Ddisable_nacl=1 \
%endif
	-Ddisable_sse2=1 \
	-Denable_plugin_installation=0 \
	-Dfastbuild=1 \
	-Dremove_webcore_debug_symbols=1 \
	-Dclang=0 \
	-Dgoogle_api_key="$_google_api_key" \
	-Dgoogle_default_client_id="$_google_default_client_id" \
	-Dgoogle_default_client_secret="$_google_default_client_secret" \
	-Dffmpeg_branding=Chrome \
	-Djavascript_engine=v8 \
	-Dlinux_fpic=1 \
	-Dlinux_link_gsettings=1 \
	-Dlinux_link_libpci=1 \
	-Dlinux_link_libspeechd=1 \
	-Dlibspeechd_h_prefix=speech-dispatcher/ \
	-Dlinux_link_pulseaudio=1 \
	-Dlinux_strip_binary=1 \
	-Dlinux_sandbox_chrome_path=%_libdir/chromium/chromium \
	-Dlinux_sandbox_path=%_libdir/chromium/chrome-sandbox \
	-Dlinux_use_bundled_binutils=0 \
	-Dlinux_use_debug_fission=0 \
	-Dlinux_use_bundled_gold=0 \
	-Dlinux_use_gold_flags=0 \
	-Dlogging_like_official_build=1 \
	-Dproprietary_codecs=1 \
	-Dremove_webcore_debug_symbols=1 \
%ifarch x86_64
	-Dtarget_arch=x64 \
%endif
%ifarch arm armh
	-Dtarget_arch=arm \
	-Denable_webrtc=0 \
	-Duse_cups=1 \
%ifarch arm
	-Dv8_use_arm_eabi_hardfloat=false \
	-Darm_float_abi=soft \
	-Darm_thumb=0 \
	-Darmv7=0 \
	-Darm_neon=0 \
%endif
%ifarch armh
	-Dv8_use_arm_eabi_hardfloat=true \
	-Darm_fpu=vfpv3 \
	-Darm_float_abi=hard \
	-Darm_thumb=1 \
	-Darmv7=1 \
	-Darm_neon=0 \
%endif
%endif
	-Duse_pulseaudio=1 \
	-Duse_system_bzip2=1 \
	-Duse_system_ffmpeg=0 \
	-Duse_system_flac=1 \
	-Duse_system_icu=0 \
	-Duse_system_libbz2=1 \
	-Duse_system_libexif=1 \
	-Duse_system_libevent=1 \
	-Duse_system_libjpeg=0 \
	-Duse_system_libmtp=0 \
	-Duse_system_libopus=1 \
	-Duse_system_libpng=0 \
	-Duse_system_libwebp=0 \
	-Duse_system_libyuv=1 \
	-Duse_system_libxml=1 \
	-Duse_system_libxslt=1 \
	-Duse_system_nspr=1 \
	-Duse_system_protobuf=0 \
	-Duse_system_speex=1 \
	-Duse_system_sqlite=0 \
	-Duse_system_v8=0 \
	-Duse_system_vpx=0 \
	-Duse_system_xdg_utils=0 \
	-Duse_system_yasm=1 \
	-Duse_system_zlib=0
# Unused flags
#	-Dlinux_use_tcmalloc=0 \

# Limit number of threads
export NPROCS=4

# Build with ninja-build (see https://code.google.com/p/chromium/wiki/LinuxBuildInstructions)
ninja-build -C out/Release \
%if_enabled verbose
	-v \
%endif
	-j $NPROCS \
	chrome \
	chrome_sandbox \
	chromedriver \
	pdf

popd

%install
mkdir -p %buildroot%_libdir/chromium/
%ifarch x86_64
mkdir -p %buildroot%_prefix/lib/
%endif
install -m 755 %SOURCE100 %buildroot%_libdir/chromium/chromium-generic
install -pD -m644 %SOURCE200 %buildroot%_sysconfdir/%name/default
# x86_64 capable systems need this
sed -i "s|/usr/lib/chromium|%_libdir/chromium|g" %buildroot%_libdir/chromium/chromium-generic

#update the password-store settings for each alternative
sed "s|password-store=detect|password-store=kwallet|g" %buildroot%_libdir/chromium/chromium-generic > %buildroot%_libdir/chromium/chromium-kde
sed "s|password-store=detect|password-store=gnome|g" %buildroot%_libdir/chromium/chromium-generic > %buildroot%_libdir/chromium/chromium-gnome
mkdir -p %buildroot%_mandir/man1/

pushd src/out/%buildtype

cp -a chrome_sandbox %buildroot%_libdir/chromium/chrome-sandbox
cp -a *.pak locales xdg-mime %buildroot%_libdir/chromium/
cp -a chromedriver %buildroot%_libdir/chromium/
cp -a icudtl.dat %buildroot%_libdir/chromium/

# Patch xdg-settings to use the chromium version of xdg-mime as that the system one is not KDE4 compatible
sed "s|xdg-mime|%_libdir/chromium/xdg-mime|g" xdg-settings > %{buildroot}%{_libdir}/chromium/xdg-settings

cp -a chrome %buildroot%_libdir/chromium/chromium
cp -a chrome.1 %buildroot%_mandir/man1/chrome.1
cp -a chrome.1 %buildroot%_mandir/man1/chromium.1
cp -a libffmpegsumo.so %buildroot%_libdir/chromium/libffmpegsumo.so
cp -a libpdf.so %buildroot%_libdir/chromium/libpdf.so

# NaCl
%if_enabled nacl
cp -a nacl_helper %buildroot%_libdir/chromium/
cp -a nacl_helper_bootstrap %buildroot%_libdir/chromium/
cp -a nacl_irt_*.nexe %buildroot%_libdir/chromium/
cp -a libppGoogleNaClPluginChrome.so %buildroot%_libdir/chromium/
%endif
popd

# Icons
for size in 22 24 48 64 128 256; do
	install -Dm644 "src/chrome/app/theme/chromium/product_logo_$size.png" \
		"%buildroot%_iconsdir/hicolor/${size}x${size}/apps/%{name}.png"
done
for size in 16 32; do
	install -Dm644 "src/chrome/app/theme/default_100_percent/chromium/product_logo_$size.png" \
		"%buildroot%_iconsdir/hicolor/${size}x${size}/apps/%{name}.png"
done

# Desktop file
install -Dm0644 %SOURCE101 %buildroot%_desktopdir/%{name}.desktop

mkdir -p %buildroot%_datadir/gnome-control-center/default-apps/
cp -a %SOURCE102 %buildroot%_datadir/gnome-control-center/default-apps/

# link to browser plugin path.  Plugin patch doesn't work. Why?
mkdir -p %buildroot%_libdir/browser-plugins
pushd %buildroot%_libdir/%name
ln -s %_libdir/browser-plugins plugins

# Install the master_preferences file
mkdir -p %buildroot%_sysconfdir/%name
install -m 0644 %SOURCE30 %buildroot%_sysconfdir/%name
install -m 0644 %SOURCE31 %buildroot%_sysconfdir/%name

# Set alternative to xbrowser
mkdir -p %buildroot%_altdir
printf '%_bindir/xbrowser\t%_bindir/%name\t50\n' > %buildroot%_altdir/%name
printf '%_bindir/%name\t%_libdir/%name/%name-generic\t10\n' > %buildroot%_altdir/%name-generic
printf '%_bindir/%name\t%_libdir/%name/%name-kde\t15\n' > %buildroot%_altdir/%name-kde
printf '%_bindir/%name\t%_libdir/%name/%name-gnome\t15\n' > %buildroot%_altdir/%name-gnome

# Add directory for extensions
mkdir -p %buildroot%_libdir/chromium/extensions

%files
%doc AUTHORS LICENSE
%config %_sysconfdir/%name
%dir %_datadir/gnome-control-center
%dir %_datadir/gnome-control-center/default-apps
%config %_sysconfdir/%name/default
%dir %_libdir/chromium/
%attr(4711,root,root) %_libdir/chromium/chrome-sandbox
%_libdir/chromium/chromium
%_libdir/chromium/chromedriver
%_libdir/chromium/chromium-generic
%_libdir/chromium/libffmpegsumo.so
%_libdir/chromium/libpdf.so
%_libdir/chromium/icudtl.dat
%_libdir/chromium/plugins/
%_libdir/chromium/locales/
%_libdir/chromium/extensions/
%if_enabled nacl
%_libdir/chromium/nacl_*
%_libdir/chromium/libppGoogleNaClPluginChrome.so
%endif
%attr(755,root,root) %_libdir/chromium/xdg-settings
%attr(755,root,root) %_libdir/chromium/xdg-mime
%_libdir/chromium/*.pak
%_man1dir/chrom*
%_desktopdir/%name.desktop
%_datadir/gnome-control-center/default-apps/chromium.xml
%_iconsdir/hicolor/*/apps/chromium.*
%_altdir/%name
%_altdir/%name-generic

%files kde
%attr(755, root, root) %_libdir/chromium/chromium-kde
%_altdir/%name-kde

%files gnome
%attr(755, root, root) %_libdir/chromium/chromium-gnome
%_altdir/%name-gnome

%changelog
