# SPEC based on ArchLinux package

# https://aur.archlinux.org/packages/ci/citrix-client/PKGBUILD
# https://wiki.archlinux.org/index.php/Citrix

Name:		citrix-client
Version:	12.1.0
%define     CHANGE_NO 203066
Release:	alt2.M70P.1
Vendor:		Citrix
Summary:	Receiver for Linux
License:	Commercial
Group:		Networking/Other
Url:		http://www.citrix.com/lang/English/lp/lp_2309126.asp
Source0:	linuxx86_%{version}.%{CHANGE_NO}.tar.gz
Source1:    citrix-client.desktop
Packager:   Andriy Stepanov <stanv@altlinux.ru>
Requires: etcskel

BuildRequires: glib2 libgtk+2 libXaw libXext libXft libXmu libXp libXpm libXt libcanberra libopenmotif4 libgst-plugins libavutil51 libva libavcodec53 libkrb5 libsasl2-plugin-gssapi
BuildRequires: rpm-build-browser-plugins
AutoReq: noshell, noshebang

ExclusiveArch: %{ix86}
# BuildArch: i586

%set_verify_elf_method none
%set_findreq_skiplist %_libdir/ICAClient/util/gst_play.64
%add_findreq_skiplist %_libdir/ICAClient/util/gst_read.64
%add_findreq_skiplist %_libdir/ICAClient/util/libgstflatstm.64.so

%description
The Citrix ICA Client is a UNIX application that provides access to a
Windows session running on a high-performance Citrix server.
Once the connection to the Citrix server is established, you can access
Windows applications and work with files in a similar way to working on
a local PC. Because the Windows applications are running remotely on a
Citrix server you get excellent performance, even on a low-performance
UNIX workstation.

%prep
%setup -c -n %name

%install

# Create folder structure
mkdir -p %buildroot/%_libexecdir/ICAClient
mkdir -p %buildroot/%_localstatedir
mkdir -p %buildroot/%browser_plugins_path
mkdir -p %buildroot/%_bindir
mkdir -p %buildroot%_desktopdir
mkdir -p %buildroot%_sysconfdir/skel/.ICAClient

# Desktop file
cp -vRpf %{S:1} %buildroot%_desktopdir/

# Copy needed files
cp -vRp ./linuxx86/linuxx86.cor/* %buildroot/%_libexecdir/ICAClient
cp -vp ./setupwfc %buildroot/%_libexecdir/ICAClient
cp -vp ./linuxx86/linuxx86.cor/nls/en/eula.txt %buildroot/%_libexecdir/ICAClient
cp -vp ./linuxx86/linuxx86.cor/npica.so %buildroot/%browser_plugins_path

# Go to package directory
pushd %buildroot/%_libexecdir/ICAClient

# Create symlinks for the Npica.ad binary
ln -s ./nls/en/Npica.ad ./Npica.ad
ln -s ./Npica.ad ./Npica

mv util/gst_play.32 util/gst_play
mv util/gst_read.32 util/gst_read

# Copy default configuration files to config directory of the program and setting them readable
cp ./nls/en/{appsrv.ini,wfclient.ini,module.ini} ./config/
chmod 644 ./config/{appsrv.ini,wfclient.ini,module.ini}
chmod 755 ./config
mv ./config %buildroot%_localstatedir/ICAClient
ln -sf %_localstatedir/ICAClient config
popd

# Create the 32 bit client script
cat << 'EOF' >> %buildroot%_bindir/citrix-client
#!/bin/sh
# Copyright (c) ALTLinux Andrew V. Stepanov 2012

export ICAROOT=%_libexecdir/ICAClient
${ICAROOT}/wfcmgr
EOF

# Create executable wrapper for the binaries
cat << 'EOF' >> %buildroot%_bindir/wfica
#!/bin/sh
# Copyright (c) ALTLinux Andrew V. Stepanov 2012

export ICAROOT=%_libexecdir/ICAClient
${ICAROOT}/wfica -file $1
EOF

cat << 'EOF' >> %buildroot%_bindir/wfica_assoc
#!/bin/sh
# Copyright (c) ALTLinux Andrew V. Stepanov 2012

export ICAROOT=%_libexecdir/ICAClient
${ICAROOT}/wfica -associate -fileparam $1
EOF

chmod a+x %buildroot%_bindir/{citrix-client,wfica,wfica_assoc}

# Create browser plugin helper
cat << 'EOF' >> %buildroot%browser_plugins_path/wfica
#!/bin/sh
# Copyright (c) ALTLinux Andrew V. Stepanov 2012

export ICAROOT=%_libexecdir/ICAClient
${ICAROOT}/wfica "$@"
EOF

chmod a+x %buildroot%browser_plugins_path/wfica

%pre
groupadd -r -f _citrix_user

%files
%_libexecdir/ICAClient
%_localstatedir/ICAClient
%attr(775, root, _citrix_user) %dir %_localstatedir/ICAClient
%attr(664, root, _citrix_user) %_localstatedir/ICAClient/appsrv.ini
%attr(664, root, _citrix_user) %_localstatedir/ICAClient/wfclient.ini
%attr(664, root, _citrix_user) %_localstatedir/ICAClient/module.ini
%browser_plugins_path/*.so
%browser_plugins_path/wfica
%_bindir/*
%_desktopdir/*.desktop
%_sysconfdir/skel/.ICAClient

%changelog
