# -*- coding: utf-8; mode: rpm-spec -*-
# $Id: cmus.spec,v 1.34 2006/08/20 13:58:03 eugene Exp $

%define name cmus
%define version 2.5.0
%define release alt4
%define debug 0

Name: %name
Version: %version
Release: %release
Summary: CMus - C* Music Player
License: GPL
Group: Sound
Url: http://cmus.sourceforge.net/

Packager: Eugene Vlasov <eugvv@altlinux.ru>

AutoReq: yes, nopython

Source0: %name-%version.tar
Source2: cmus.desktop

# Patch0: cmus-vorbis_includes.patch
# Temporary disable build with ncursesw - removed. Now cmus use ncurses if
# ncursesw not available
# Patch1: %name-with_ncurses.patch
Patch2: cmus.git-5feece0be8491287625b105af35d0091cbb05aa6.patch

# User interface
BuildRequires(build): libtinfo-devel
BuildRequires(build): libncursesw-devel
# Output
BuildRequires(build): libalsa-devel
BuildRequires(build): libao-devel
BuildRequires(build): libpulseaudio-devel
# Input
BuildRequires(build): libmad-devel
BuildRequires(build): libogg-devel
BuildRequires(build): libvorbis-devel
BuildRequires(build): libflac-devel
BuildRequires(build): libmodplug-devel
BuildRequires(build): libmpcdec-devel
BuildRequires(build): libfaad-devel
BuildRequires(build): libmikmod-devel
BuildRequires(build): libmpeg4ip-devel
BuildRequires(build): libavcodec-devel
BuildRequires(build): libavformat-devel
BuildRequires(build): libavutil-devel
BuildRequires(build): libwavpack-devel
BuildRequires(build): libcue-devel
BuildRequires(build): libcdio-devel
BuildRequires(build): libcddb-devel
BuildRequires(build): libdiscid-devel
BuildRequires(build): libopusfile-devel

# Automatically added by buildreq on Sat Jul 28 2007
BuildRequires: libstdc++-devel

%description
CMus is a small and fast text mode music player.
Track metadata cache makes adding files to playlist very fast and separate
playlist loader thread keeps UI always usable. cmus is also fast to use;
most commands require just one keypress, more complex commands are
executed in vi-style command mode.
Features
  * Input
    o FLAC
    o Ogg/Vorbis
    o MP3 (libmad)
    o Wav
    o .mod, .s3m, ... (libmodplug, libmikmod)
    o .mpc, .mpp, .mp+ (libmpcdec)
    o MPEG-4 AAC (.mp4, .m4a, .m4b)
    o AAC (.aac, audio/aac, audio/aacp)
    o FFMPEG (.wma files, could extend to support more)
    o WavPack (.wv)
    o CDIO
  * Output
    o ALSA
    o OSS
    o libao
  * Playing
    o Album/artist modes; playing within one album or artist
    o Play queue
    o MP3 and Ogg streaming (Shoutcast/Icecast)
    o Powerful playlist filters
  * Interface
    o Easy to use directory browser
    o Customizable colors
    o Dynamic keybindings, you can bind a key to any command
    o Vi/less style search mode
    o Vi style command mode with tabulator expansion
  * Misc
    o Can run external commands for the selected files (tag-editor for
      example)
    o UTF-8 support
    o Can be controlled via UNIX socket using cmus-remote command

%description -l ru_RU.UTF-8
CMus - маленький и быстрый музыкальный проигрыватель, использующий
библиотеку ncurses.
Кэширование данных треков делает добавление файлов в список
воспроизведения очень быстрым, фоновая загрузка файлов в список не
блокирует воспроизведение и интерфейс пользователя.
Для выполнения большинства команд достаточно нажатия на одну клавишу,
более сложные команды отдаются в стиле редактора Vi.
Особенности
  * Входные форматы:
    o FLAC
    o Ogg/Vorbis
    o MP3 (libmad)
    o Wav
    o .mod, .s3m, ... (libmodplug, libmikmod)
    o .mpc, .mpp, .mp+ (libmpcdec)
    o MPEG-4 AAC (.mp4, .m4a, .m4b)
    o AAC (.aac, audio/aac, audio/aacp)
    o FFMPEG (.wma, возможность поддержки многих форматов)
    o WavPack (.wv)
    o CDIO
  * Выход:
    o ALSA
    o OSS
    o libao
  * Воспроизведение
    o Режимы альбом/исполнитель. Воспроизведение целого альбома или
      полностью исполнителя
    o Очередь воспроизведения
    o Потоковое воспроизведение MP3 и Ogg (Shoutcast/Icecast)
    o Фильтры списков воспроизведения
  * Интерфейс
    o Легкая в использовании навигация по каталогам
    o Настраиваемые цвета
    o Переопределяемые комбинации клавиш, возможность задать клавишу для
      любой команды
    o Режим поиска в тиле vi/less
    o Командный режим в стиле vi с поддержкой дополнения строк
  * Прочее
    o Возможность запуска внешних команд для выбранных файлов (например,
      редактора тегов)
    o Поддержка UTF-8
    o Может управлятся через сокет UNIX (используя команду cmus-remote)

%package in-flac
Summary: FLAC plugin for CMus
Group: Sound

Requires: %name = %version-%release

%description in-flac
CMus is a small and fast music player using the ncurses library.

This package contains FLAC plugin.

%description -l ru_RU.UTF-8 in-flac
CMus - маленький и быстрый музыкальный проигрыватель, использующий
библиотеку ncurses.

Этот пакет содержит расширение для воспроизведения FLAC.


%package in-vorbis
Summary: Ogg/Vorbis plugin for CMus
Group: Sound

Requires: %name = %version-%release

%description in-vorbis
CMus is a small and fast music player using the ncurses library.

This package contains Ogg/Vorbis plugin.

%description -l ru_RU.UTF-8 in-vorbis
CMus - маленький и быстрый музыкальный проигрыватель, использующий
библиотеку ncurses.

Этот пакет содержит расширение для воспроизведения Ogg/Vorbis.


%package in-modplug
Summary: libmodplug plugin for CMus (.mod, .x3m, ...)
Group: Sound

Requires: %name = %version-%release

%description in-modplug
CMus is a small and fast music player using the ncurses library.

This package contains modules plugin (libmodplug).

%description -l ru_RU.UTF-8 in-modplug
CMus - маленький и быстрый музыкальный проигрыватель, использующий
библиотеку ncurses.

Этот пакет содержит расширение для модулей (libmodplug).

%package in-mpc
Summary: MPC plugin for CMus
Group: Sound

Requires: %name = %version-%release

%description in-mpc
CMus is a small and fast music player using the ncurses library.

This package contains plugin for .mpc, .mpp, .mp+ files (libmpcdec).

%description -l ru_RU.UTF-8 in-mpc
CMus - маленький и быстрый музыкальный проигрыватель, использующий
библиотеку ncurses.

Этот пакет содержит расширение для воспроизведения файлов .mpc, .mpp,
.mp+ (libmpcdec).

%package in-mikmod
Summary: libmikmod plugin for CMus (.mod, .x3m, ...)
Group: Sound

Requires: %name = %version-%release

%description in-mikmod
CMus is a small and fast music player using the ncurses library.

This package contains modules plugin (libmikmod).

%description -l ru_RU.UTF-8 in-mikmod
CMus - маленький и быстрый музыкальный проигрыватель, использующий
библиотеку ncurses.

Этот пакет содержит расширение для модулей (libmikmod).

%package in-mp4
Summary: MPEG-4 AAC plugin for CMus (.mp4, .m4a, .m4b)
Group: Sound

Requires: %name = %version-%release

%description in-mp4
CMus is a small and fast music player using the ncurses library.

This package contains plugin for MPEG-4 AAC (.mp4, .m4a, .m4b) files.

%description -l ru_RU.UTF-8 in-mp4
CMus - маленький и быстрый музыкальный проигрыватель, использующий
библиотеку ncurses.

Этот пакет содержит расширение для воспроизведения файлов MPEG-4 AAC
(.mp4, .m4a, .m4b).

%package in-aac
Summary: AAC plugin for CMus (.aac, audio/aac, audio/aacp)
Group: Sound

Requires: %name = %version-%release

%description in-aac
CMus is a small and fast music player using the ncurses library.

This package contains plugin for AAC (.aac, audio/aac, audio/aacp) files.

%description -l ru_RU.UTF-8 in-aac
CMus - маленький и быстрый музыкальный проигрыватель, использующий
библиотеку ncurses.

Этот пакет содержит расширение для воспроизведения файлов AAC (.aac,
audio/aac, audio/aacp).

%package in-wavpack
Summary: WavPack plugin for CMus (.wv, audio/x-wavpack)
Group: Sound

Requires: %name = %version-%release

%description in-wavpack
CMus is a small and fast music player using the ncurses library.

This package contains plugin for WavPack (.wv, audio/x-wavpack) files.

%description -l ru_RU.UTF-8 in-aac
CMus - маленький и быстрый музыкальный проигрыватель, использующий
библиотеку ncurses.

Этот пакет содержит расширение для воспроизведения файлов WavPack (.wv, 
audio/x-wavpack).

%package in-ffmpeg
Summary: FFMPEG plugin for CMus (.shn, .wma)
Group: Sound

Requires: %name = %version-%release

%description in-ffmpeg
CMus is a small and fast music player using the ncurses library.

This package contains plugin for FFMPEG support (.wma files, could extend
to support more).

%package in-cdio
Summary: CDIO plugin for CMus
Group: Sound

Requires: %name = %version-%release

%description in-cdio
CMus is a small and fast music player using the ncurses library.

This package contains plugin for CDIO support.

%description -l ru_RU.UTF-8 in-aac
CMus - маленький и быстрый музыкальный проигрыватель, использующий
библиотеку ncurses.

Этот пакет содержит расширение для поддержки FFMPEG (дает возможность
воспроизведения .wma и других форматов).

%package in-cue
Summary: CUE plugin for CMus
Group: Sound

Requires: %name = %version-%release

%description in-cue
CMus is a small and fast music player using the ncurses library.

This package contains plugin for CUE sheet support.

%description -l ru_RU.UTF-8 in-cue
CMus - маленький и быстрый музыкальный проигрыватель, использующий
библиотеку ncurses.

Этот пакет содержит расширение для поддержки CUE-файлов.


%package out-alsa
Summary: ALSA output plugin for CMus
Group: Sound

Requires: %name = %version-%release

%description out-alsa
CMus is a small and fast music player using the ncurses library.

This package contains ALSA output plugin.

%description -l ru_RU.UTF-8 out-alsa
CMus - маленький и быстрый музыкальный проигрыватель, использующий библиотеку ncurses.

Этот пакет содержит расширение для воспроизведения через ALSA.


%package out-pulse
Summary: PulseAudio output plugin for CMus
Group: Sound

Requires: %name = %version-%release

%description out-pulse
CMus is a small and fast music player using the ncurses library.

This package contains PulseAudio output plugin.

%description -l ru_RU.UTF-8 out-pulse
CMus - маленький и быстрый музыкальный проигрыватель, использующий библиотеку ncurses.

Этот пакет содержит расширение для воспроизведения через PulseAudio.


%package out-ao
Summary: libao output plugin for CMus
Group: Sound

Requires: %name = %version-%release

%description out-ao
CMus is a small and fast music player using the ncurses library.

This package contains libao output plugin.

%description -l ru_RU.UTF-8 out-ao
CMus - маленький и быстрый музыкальный проигрыватель, использующий библиотеку ncurses.

Этот пакет содержит расширение для воспроизведения через libao.


%prep
%setup -q
# %patch0 -p1
# %patch1 -p1
%patch2 -p1

%build
CFLAGS="${CFLAGS:--pipe -Wall -O2 -g}" ; export CFLAGS
CXXFLAGS="${CXXFLAGS:--pipe -Wall -O2 -g}" ; export CXXFLAGS
./configure \
%if %debug
        DEBUG=2 \
%endif
        prefix=%prefix \
        CONFIG_FLAC=y \
        CONFIG_MAD=y \
        CONFIG_MODPLUG=y \
        CONFIG_MPC=y \
        CONFIG_VORBIS=y \
        CONFIG_WAV=y \
        CONFIG_MIKMOD=y \
        CONFIG_AAC=y \
        CONFIG_MP4=y \
        CONFIG_WAVPACK=y \
        CONFIG_FFMPEG=y \
        CONFIG_CUE=y \
        CONFIG_ALSA=y \
        CONFIG_PULSE=y \
        CONFIG_ARTS=n \
        CONFIG_AO=y \
        CONFIG_OSS=y \
        CONFIG_OPUS=y \
        CONFIG_CDDB=y \
        CONFIG_DISCID=y \
        CONFIG_CDIO=y
%make_build
# make man
# make html


%install
make DESTDIR=%buildroot install

# Menu entry
# %__mkdir_p %buildroot%_menudir
# cat > %buildroot%_menudir/%name <<EOF
# ?package(cmus):\
#  	command="%_bindir/%name" needs="text" icon="sound_section.png" \
#   	section="Multimedia/Sound" title="CMus" \
#         longtitle="CMus - C* Music Player"
# EOF
install -d %buildroot%_desktopdir
install -m 644 %SOURCE2 %buildroot%_desktopdir/%name.desktop

mkdir examples
mv cmus-status-display examples


%files
%_bindir/cmus*
%dir %_libexecdir/%name
%dir %_libexecdir/%name/ip
%dir %_libexecdir/%name/op
%_libexecdir/%name/ip/mad.so
%_libexecdir/%name/ip/wav.so
%_libexecdir/%name/op/oss.so
# %_menudir/%name
%_desktopdir/%name.desktop
%_datadir/%name
%exclude %_datadir/doc/%name
%doc AUTHORS README examples contrib
%_man1dir/cmus.1.*
%_man1dir/cmus-remote.1.*
%_man7dir/cmus-tutorial.7.*


%files in-flac
%_libexecdir/%name/ip/flac.so


%files in-vorbis
%_libexecdir/%name/ip/vorbis.so


%files in-modplug
%_libexecdir/%name/ip/modplug.so


%files in-mpc
%_libexecdir/%name/ip/mpc.so


%files in-mikmod
%_libexecdir/%name/ip/mikmod.so


%files in-mp4
%_libexecdir/%name/ip/mp4.so


%files in-aac
%_libexecdir/%name/ip/aac.so


%files in-wavpack
%_libexecdir/%name/ip/wavpack.so


%files in-ffmpeg
%_libexecdir/%name/ip/ffmpeg.so


%files in-cdio
%_libexecdir/%name/ip/cdio.so


%files in-cue
%_libexecdir/%name/ip/cue.so


%files out-alsa
%_libexecdir/%name/op/alsa.so


%files out-pulse
%_libexecdir/%name/op/pulse.so


%files out-ao
%_libexecdir/%name/op/ao.so


%changelog
