Name: codeblocks
%define revision 9158
Version: 16.01
Release: alt0.M70P.1

Summary: Code::Blocks is open source, cross platform free C++ IDE
Summary(ru_RU.UTF-8): Code::Blocks это кросс-платформенная свободная среда разработки для C++ с открытым исходным кодом

License: %gpl3only
Group: Development/C++
Url: http://www.codeblocks.org
Packager: Denis Kirienko <dk@altlinux.ru>

Source0: codeblocks_16.01.tar.gz
Source1: %name-8.02-alt-icons.tar.bz2
Source3: %name.desktop
Source4: %name.po
Source5: %name-default.conf

Patch1: codeblocks-ebuild.conf.patch

BuildPreReq: wxGTK-devel >= 2.8.12 gcc-c++ libgtk+2-devel zip sed grep coreutils bzip2 gettext-tools boost-devel libgamin-devel rpm-build-licenses libhunspell-devel wxGTK-contrib-gizmos-devel
Requires: automake >= 1.7 wxGTK >= 2.8.12 gcc gcc-c++ gdb xterm

%set_verify_elf_skiplist %_datadir/%name/*

%description
Code::Blocks is a free C++ IDE built specifically to meet the most
demanding needs of its users. It was designed, right from the start,
to be extensible and configurable. Built around a plugin framework,
Code::Blocks can be extended with plugin DLLs.
It includes a plugin wizard so you can compile your own plugins!

%description -l ru_RU.UTF-8
Code::Blocks это свободная IDE для C++, которая создана для
удовлетворения множества требований её пользователей.
Она разрабатывалась с самого начала, как расширяемая
и легко настраиваемая. Собранная с поддержкой плагинов
Code::Blocks может быть расширена с помощью подключаемых библиотек.

%package contrib
Summary: Code::Blocks contrib plugins
Summary(ru_RU.UTF-8): Дополнительные плагины для Code::Blocks
Group: Development/C++
Requires: codeblocks = %{version}-%{release}

%description contrib
Additional Code::Blocks plugins.

%description contrib -l ru_RU.UTF-8
Набор дополнительных плагинов для среды разработки Code::Blocks.

%package devel
Summary: Code::Blocks SDK
Group: Development/C++
Requires: codeblocks = %{version}-%{release}

%description devel
Code::Blocks SDK to develop your own plugins.

%description devel -l ru_RU.UTF-8
SDK для создания собственных плагинов к среде разработки Code::Blocks.

%define pkgdata %_datadir/%name

%prep
%setup -q -a 1 -n codeblocks-16.01.release
cp %SOURCE3 src/mime/
cp %SOURCE4 .

%patch1 -p1

# Script update_revision.sh generates file revision.m4 that contains info about svn revision.
# It takes data from .svn directory. Since we haven't this directory in %SOURCE0, we should remove
# this script and create correct file revision.m4 instead.
# rm update_revision.sh
# echo "m4_define([SVN_REV], %{revision})" > revision.m4
# echo "m4_define([SVN_REVISION], %{version})" >> revision.m4
# echo "m4_define([SVN_DATE], `date +'%%F %%T'`)" >> revision.m4

%build
msgfmt %name.po -o %name.mo
./bootstrap
%configure --with-contrib-plugins=all
%make_build

%install
%make_install DESTDIR=%buildroot install
install -m 644 -D alt-icons/16x16/%name.png %buildroot%_miconsdir/%name.png
install -m 644 -D alt-icons/32x32/%name.png %buildroot%_niconsdir/%name.png
install -m 644 -D alt-icons/48x48/%name.png %buildroot%_liconsdir/%name.png
install -m 644 -D alt-icons/64x64/%name.png %buildroot%_iconsdir/hicolor/64x64/apps/%name.png
install -m 644 -D %name.mo %buildroot%pkgdata/locale/ru_RU/%name.mo
install -m 644 -D %SOURCE5 %buildroot%_sysconfdir/skel/.config/codeblocks/default.conf

%files
%doc README COPYING AUTHORS BUGS COMPILERS TODO NEWS
%_bindir/%name
%_bindir/cb_console_runner
%_libdir/libcodeblocks.so.*
%_datadir/applications/%name.desktop
%_datadir/mime/packages/%name.xml
%_mandir/man?/*
%_sysconfdir/skel/.config/codeblocks
%dir %pkgdata
%{pkgdata}/abbreviations.zip
%{pkgdata}/astyle.zip
%{pkgdata}/autosave.zip
%{pkgdata}/classwizard.zip
%{pkgdata}/codecompletion.zip
%{pkgdata}/compiler.zip
%{pkgdata}/debugger.zip
%{pkgdata}/defaultmimehandler.zip
%{pkgdata}/IncrementalSearch.zip
%{pkgdata}/manager_resources.zip
%{pkgdata}/resources.zip
%{pkgdata}/scriptedwizard.zip
%{pkgdata}/start_here.zip
%{pkgdata}/todo.zip
%{pkgdata}/Valgrind.zip
%{pkgdata}/tips.txt
%{pkgdata}/icons
%dir %{pkgdata}/images
%{pkgdata}/images/*.png
%{pkgdata}/images/16x16
%{pkgdata}/images/codecompletion
%{pkgdata}/images/settings
%{pkgdata}/compilers
%{pkgdata}/lexers
%{pkgdata}/locale
%dir %{_libdir}/%{name}
%dir %{_libdir}/%{name}/plugins
%{_libdir}/%{name}/plugins/libabbreviations.*
%{_libdir}/%{name}/plugins/libastyle.*
%{_libdir}/%{name}/plugins/libautosave.*
%{_libdir}/%{name}/plugins/libclasswizard.*
%{_libdir}/%{name}/plugins/libcodecompletion.*
%{_libdir}/%{name}/plugins/libcompiler.*
%{_libdir}/%{name}/plugins/libdebugger.*
%{_libdir}/%{name}/plugins/libdefaultmimehandler.*
%{_libdir}/%{name}/plugins/libIncrementalSearch.*
%{_libdir}/%{name}/plugins/libscriptedwizard.*
%{_libdir}/%{name}/plugins/libtodo.*
%{_libdir}/%{name}/plugins/libValgrind.*
%{pkgdata}/scripts
%{pkgdata}/templates
%_iconsdir/*/*/*/*
%_pixmapsdir/*

%files contrib
%_bindir/cb_share_config
# %_bindir/codesnippets
%_libdir/libwxsmithlib.so.*
%_libdir/%{name}/wxContribItems
%{pkgdata}/AutoVersioning.zip
%{pkgdata}/BrowseTracker.zip
%{pkgdata}/byogames.zip
%{pkgdata}/cb_koders.zip
%{pkgdata}/Cccc.zip
%{pkgdata}/codesnippets.zip
%{pkgdata}/CppCheck.zip
%{pkgdata}/codestat.zip
%{pkgdata}/copystrings.zip
%{pkgdata}/Cscope.zip
%{pkgdata}/DoxyBlocks.zip
%{pkgdata}/dragscroll.zip
%{pkgdata}/EditorTweaks.zip
%{pkgdata}/EditorConfig.zip
%{pkgdata}/envvars.zip
%{pkgdata}/exporter.zip
%{pkgdata}/FileManager.zip
%{pkgdata}/help_plugin.zip
%{pkgdata}/HexEditor.zip
%{pkgdata}/headerfixup.zip
%{pkgdata}/keybinder.zip
%{pkgdata}/lib_finder.zip
%{pkgdata}/MouseSap.zip
%{pkgdata}/NassiShneiderman.zip
%{pkgdata}/occurrenceshighlighting.zip
%{pkgdata}/openfileslist.zip
%{pkgdata}/projectsimporter.zip
%{pkgdata}/ProjectOptionsManipulator.zip
%{pkgdata}/Profiler.zip
%{pkgdata}/RegExTestbed.zip
%{pkgdata}/ReopenEditor.zip
%{pkgdata}/SmartIndent*.zip
%{pkgdata}/SpellChecker.zip
%{pkgdata}/SymTab.zip
%{pkgdata}/ThreadSearch.zip
%{pkgdata}/ToolsPlus.zip
%{pkgdata}/wxsmith.zip
%{pkgdata}/wxSmithAui.zip
%{pkgdata}/wxsmithcontribitems.zip
%{pkgdata}/images/codesnippets
%{pkgdata}/images/DoxyBlocks
%{pkgdata}/images/ThreadSearch
%{pkgdata}/images/wxsmith
%{pkgdata}/lib_finder
%{pkgdata}/SpellChecker
%{_libdir}/%{name}/plugins/libAutoVersioning.*
%{_libdir}/%{name}/plugins/libBrowseTracker.*
%{_libdir}/%{name}/plugins/libbyogames.*
%{_libdir}/%{name}/plugins/libcb_koders.*
%{_libdir}/%{name}/plugins/libCccc.*
%{_libdir}/%{name}/plugins/libcodesnippets.*
%{_libdir}/%{name}/plugins/libcodestat.*
%{_libdir}/%{name}/plugins/libcopystrings.*
%{_libdir}/%{name}/plugins/libCppCheck.*
%{_libdir}/%{name}/plugins/libCscope.*
%{_libdir}/%{name}/plugins/libDoxyBlocks.*
%{_libdir}/%{name}/plugins/libdragscroll.*
%{_libdir}/%{name}/plugins/libEditorTweaks.*
%{_libdir}/%{name}/plugins/libEditorConfig.*
%{_libdir}/%{name}/plugins/libenvvars.*
%{_libdir}/%{name}/plugins/libexporter.*
%{_libdir}/%{name}/plugins/libFileManager.*
%{_libdir}/%{name}/plugins/libhelp_plugin.*
%{_libdir}/%{name}/plugins/libHexEditor.*
%{_libdir}/%{name}/plugins/libheaderfixup.*
%{_libdir}/%{name}/plugins/libkeybinder.*
%{_libdir}/%{name}/plugins/liblib_finder.*
%{_libdir}/%{name}/plugins/libMouseSap.*
%{_libdir}/%{name}/plugins/libNassiShneiderman.*
%{_libdir}/%{name}/plugins/liboccurrenceshighlighting.*
%{_libdir}/%{name}/plugins/libopenfileslist.*
%{_libdir}/%{name}/plugins/libprojectsimporter.*
%{_libdir}/%{name}/plugins/libProjectOptionsManipulator.*
%{_libdir}/%{name}/plugins/libProfiler.*
%{_libdir}/%{name}/plugins/libRegExTestbed.*
%{_libdir}/%{name}/plugins/libReopenEditor.*
%{_libdir}/%{name}/plugins/libSmartIndent*.*
%{_libdir}/%{name}/plugins/libSpellChecker.*
%{_libdir}/%{name}/plugins/libSymTab.*
%{_libdir}/%{name}/plugins/libThreadSearch.*
%{_libdir}/%{name}/plugins/libToolsPlus.*
%{_libdir}/%{name}/plugins/libwxsmith.*
%{_libdir}/%{name}/plugins/libwxSmithAui.*
%{_libdir}/%{name}/plugins/libwxsmithcontribitems.*

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc

%changelog
