%define mate_plugins compiz-annotate compiz-blur compiz-clone compiz-commands compiz-core compiz-cube compiz-dbus compiz-decoration compiz-fade compiz-fs compiz-mateconf compiz-glib compiz-matecompat compiz-ini compiz-inotify compiz-minimize compiz-move compiz-obs compiz-place compiz-png compiz-regex compiz-resize compiz-rotate compiz-scale compiz-screenshot compiz-svg compiz-switcher compiz-video compiz-water compiz-wobbly compiz-zoom gwd
%define default_plugins animation,core,dbus,decoration,expo,glib,matecompat,imgjpeg,move,place,png,regex,resize,scale,session,svg,switcher,text,wall,wobbly,workarounds

Name: compiz
Version: 0.8.8
Release: alt11
Summary: OpenGL window and compositing manager
License: MIT/X11 GPL
Group: System/X11
Url: http://www.compiz-fusion.org/

Obsoletes: compiz-manager
Provides: compiz-manager = %version-%release
Provides: COMPIZ_CORE_ABIVERSION = 20091102

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: gcc-c++ intltool libGLU-devel libXcomposite-devel
BuildRequires: libdbus-glib-devel libmetacity-devel librsvg-devel
BuildRequires: libwnck-devel xsltproc libxslt-devel xorg-xextproto-devel kde4libs-devel kde4base-workspace-devel
BuildRequires: kdebase-devel libdbus-tqt-devel libtqt-devel libpng-devel

BuildRequires: libfuse-devel libstartup-notification-devel

%description
Compiz is an OpenGL compositing manager that use GLX_EXT_texture_from_pixmap
for binding redirected top-level windows to texture objects. It has a flexible
plug-in system and it is designed to run well on most graphics hardware.

%package mate
Summary: Mate Window Manager
Group: Graphical desktop/Other
Requires: %name = %version-%release %name-gtk = %version-%release simple-ccsm

%description mate
Compiz Window Manager for Mate

%package gtk
Summary: Gtk Compiz window decorator
Group: Graphical desktop/GNOME
Requires: %name = %version-%release
Requires: compizconfig-backend-gconf >= 0.8.4

%description gtk
Compiz window decorator for Gtk

%package kde
Summary: KDE Compiz window decorator
Group: Graphical desktop/KDE
Requires: %name = %version-%release
#Requires: compizconfig-backend-kconfig4 >= 0.8.4 simple-ccsm

%description kde
Compiz window decorator for KDE

%package kde4
Summary: KDE4 Compiz window decorator
Group: Graphical desktop/KDE
Requires: %name = %version-%release
Requires: compizconfig-backend-kconfig4 >= 0.8.4 simple-ccsm

%description kde4
Compiz window decorator for KDE4

%package devel
Summary: Development files for Compiz
Group: Development/C
Requires: %name = %version-%release

%description devel
Development files for Compiz

%package -n rpm-build-%name
Summary: RPM macros for sawfish-related packages
Group: Development/Other

%description -n rpm-build-%name
RPM macros for sawfish-related packages

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--with-default-plugins="%default_plugins" \
	--enable-librsvg \
	--enable-gtk \
	--disable-mate \
	--enable-marco \
	--disable-mateconf \
	--enable-mate-keybindings \
	--enable-kde \
	--enable-kde4 \
	--disable-static

%make_build

echo "%%compiz_core_abi_version $(sed -ne 's|^#define[[:space:]]*CORE_ABIVERSION[[:space:]]*\(.*\)|\1|p' include/%name-core.h)" > %name-core.rpmmacros

%install
%make DESTDIR=%buildroot install

rm -f %buildroot%_libdir/%name/*.la

# rpm macros
install -pD -m644 %name-core.rpmmacros %buildroot%_rpmmacrosdir/%name-core

%find_lang %name

%if_enabled mateconf
%post mate
%mateconf_schema_upgrade %mate_plugins

%preun mate
if [ $1 = 0 ]; then
%mateconf_schema_remove %mate_plugins
fi
%endif


%files -f %name.lang
%doc AUTHORS COPYING COPYING.GPL COPYING.MIT README TODO NEWS
%_bindir/%name
%dir %_libdir/%name
%_libdir/*.so.*
%if_enabled mateconf
%exclude %_libdir/%name/libmateconf.so
%endif
%exclude %_libdir/%name/libmatecompat.so
%exclude %_libdir/%name/libglib.so
%exclude %_libdir/%name/libkconfig.so
%_libdir/%name/lib*.so
%_datadir/%name
%exclude %_datadir/%name/kc*
%exclude %_datadir/%name/mateconf.xml
%exclude %_datadir/%name/matecompat.xml
%exclude %_datadir/%name/glib.xml

%if_enabled mate
%files mate
%if_enabled mateconf
%_sysconfdir/mateconf/schemas/*.schemas
%exclude %_sysconfdir/mateconf/schemas/*kconfig.schemas
%_libdir/%name/libmateconf.so
%_datadir/%name/mateconf.xml
%_libdir/window-manager-settings/libcompiz.so
%endif
%_libdir/%name/libmatecompat.so
%_libdir/%name/libglib.so
%_libdir/window-manager-settings/libmarco.so
%_desktopdir/%name.desktop
%_datadir/%name/matecompat.xml
%_datadir/%name/glib.xml
%_datadir/mate-control-center/keybindings/*.xml
%_datadir/mate/wm-properties/%name-wm.desktop
%endif

%files gtk
%_bindir/gtk-window-decorator

%files kde
%_bindir/kde-window-decorator
%_libdir/%name/libkconfig.so
%_K3conf/*
%_K3cfg/*

%files kde4
%_bindir/kde4-window-decorator

%files devel
%_includedir/compiz
%_libdir/*.so
%_pkgconfigdir/*.pc

%files -n rpm-build-%name
%_rpmmacrosdir/%name-core

%changelog
