Name: consolehelper
Version: 0.3.1
Release: alt1

Group: System/Configuration/Other
Summary: A wrapper that helps console users run system programs
License: GPLv2+

Source: %name-%version.tar

Obsoletes: usermode

BuildPreReq: glib-devel libgtk+2-devel libpam-devel pkgconfig

%define conshelpdir %_libexecdir/%name

Provides: %_libexecdir/%name/helper

%description
consolehelper is a tool that makes it easy for console users to run system
programs, doing authentication via PAM (which can be set up to trust all
console users or to ask for a password at the system administrator's
discretion).  When possible, the authentication is done graphically;
otherwise, it is done within the text console from which consolehelper
was started.

consolehelper requires that a PAM configuration for every managed
program exist.  So to make /sbin/foo or /usr/sbin/foo managed, you need
to create a link from /usr/bin/foo to %conshelpdir/helper and create
the file /etc/pam.d/foo, normally using the pam_console(8) PAM module.

%prep
%setup

%build
%make_build libexecdir=%_libexecdir helperdir=%conshelpdir

%install
%makeinstall_std libexecdir=%_libexecdir helperdir=%conshelpdir

# compatibility.
pushd %buildroot
	mkdir -p .%_bindir ./usr/lib/helper
	ln -s `relative %conshelpdir/helper /usr/lib/helper/` \
		./usr/lib/helper/%name
	ln -s `relative %conshelpdir/helper %_bindir/` \
		.%_bindir/%name
popd

%find_lang %name

%pre
/usr/sbin/groupadd -r -f conshelp
%pre_control %name

%post
%post_control %name

%files -f %name.lang
%config /etc/control.d/facilities/%name
%_bindir/*
/usr/lib/helper/*
%dir %conshelpdir
%attr(2711,root,conshelp) %conshelpdir/helper
%attr(710,root,conshelp) %dir %conshelpdir/priv
%attr(4711,root,root) %conshelpdir/priv/auth
%_datadir/pixmaps/*
%_man8dir/*

%changelog
