%define oname apache-couchdb
Name: couchdb
Version: 1.0.2
Release: alt1.1
Packager: Mikhail Pokidko <pma@altlinux.org>
Url: http://couchdb.apache.org/
License: Apache
Group: Databases
Summary: A peer based distributed database system

Source: %name-%version-%release.tar
Source1: couch.init

BuildRequires: erlang erlang-devel erlang-otp-devel libicu-devel libcurl-devel help2man libjs-devel

Requires: libicu-devel erlang erlang-otp

%description
CouchDB is a peer based distributed database system. Any number of CouchDB hosts
(servers and offline-clients) can have independent "replica copies" of the same database,
where applications have full database interactivity (query, add, edit, delete). 
When back online or on a schedule, database changes are replicated bi-directionally. 

CouchDB has built-in conflict detection and management and the replication process is
incremental and fast, copying only documents and individual fields changed since the 
previous replication. Most applications require no special planning to take advantage 
of distributed updates and replication. 

Unlike cumbersome attempts to bolt distributed features on top of the same legacy models 
and databases, it is the result of careful ground-up design, engineering and integration. 
The document, view, security and replication models, the special purpose query language, 
the efficient and robust disk layout are all carefully integrated for a reliable and 
efficient system.

%prep
%setup -q

%build
./bootstrap
%configure --with-js-include=%_includedir/js --localstatedir=/var --libdir=%_libexecdir 
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_sbindir
mv %buildroot%_bindir/%name %buildroot%_sbindir/
mv %buildroot%_prefix/lib/%name/erlang %buildroot%_libexecdir

install -p -m755 -D %SOURCE1 %buildroot%_initdir/%name
mkdir -p %buildroot%_sysconfdir/sysconfig
mv %buildroot%_sysconfdir/default/%name %buildroot%_sysconfdir/sysconfig/

mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_logdir/%name

# fix paths
sed -i s@lib/lib@lib@g %buildroot%_sbindir/%name
sed -i s@%name/erlang@erlang@g %buildroot%_sbindir/%name
sed -i s#HEART_COMMAND=\"/usr/bin#HEART_COMMAND=\"/usr/sbin#g %buildroot%_sbindir/%name
sed -i s#/usr/lib/couchdb#/usr/lib# %buildroot%_sysconfdir/%name/default.ini

%pre
%_sbindir/groupadd -r -f _couchdb &>/dev/null ||:
%_sbindir/useradd -r -g _couchdb -d %_localstatedir/%name -s /dev/null \
	-c "couchdb pseudouser" -M -n _couchdb &>/dev/null ||:

%post
%post_service %name

%preun
%preun_service %name


%files
%dir %_sysconfdir/%name/
%config(noreplace) %attr(0660,root, _couchdb) %_sysconfdir/%name/local.ini
%_sysconfdir/%name/default.ini
%attr(0770,root, _couchdb) %_sysconfdir/%name/default.d/
%attr(0770,root, _couchdb) %_sysconfdir/%name/local.d/
%_sysconfdir/logrotate.d/couchdb
%_initdir/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%_libexecdir/erlang/lib/*
%_bindir/*
%_sbindir/*
%_datadir/%name
%_libexecdir/%name
%attr(0770,root, _couchdb) %_localstatedir/%name
%attr(0770,root, _couchdb) %_logdir/%name
%doc %_defaultdocdir/%name
%_man1dir/*



%changelog
