# -*- coding: utf-8; mode: rpm-spec -*-
# $Id: crossfire.spec,v 1.9 2006/07/15 15:53:50 eugene Exp $

Name: crossfire
Version: 1.11.0
Release: alt1.qa6
Summary: Multiplayer graphical role-playing game
Summary(ru_RU.UTF-8): Многопользовательская графическая ролевая игра
License: GPL
Group: Games/Adventure
Url: http://crossfire.real-time.com

Packager: Eugene Vlasov <eugvv@altlinux.ru>

Source0: %name-%version.tar.gz
Source4: %name.desktop
# Icons taken from crossfire-client
Source5: %name-16x16.png
Source6: %name-32x32.png
Source7: %name-48x48.png

Patch0: %name-1.9.0-bound_cond.patch
Patch1: %name-1.11.0-alt-libpng15.patch

Provides: crossfire-server
Requires: crossfire-maps

BuildPreReq: perl-CGI

# Automatically added by buildreq on Fri Mar 10 2006
BuildRequires: alternatives flex gcc-c++ imake libICE-devel libSM-devel libX11-devel libXaw-devel libXext-devel libXmu-devel libXpm-devel libXt-devel libpng-devel libstdc++-devel ncompress python-base python-dev python-modules-encodings tetex-latex xorg-cf-files xorg-proto-devel zlib-devel


%description
crossfire is a multiplayer graphical arcade and adventure game made for
the X-Windows environment.  It runs on a client/server model.
The client runs with X11, GTK, or  SDL within a gtk window.

It has certain flavours from other games, especially Gauntlet (TM)
and Nethack/Moria.

Any number of players can move around in their own window, finding
and using items and battle monsters.  They can choose to cooperate
or compete in the same "world".

This package contains crossfire server.

%description -l ru_RU.UTF-8
crossfire - многопользовательская графическая аркадная и
приключенческая игра, работающая в среде X-Windows. Делится на
клиентскую и серверную части. Доступны клиентские части с интерфейсом
X11, GTK, или SDL (в окне gtk).

Игра разработана под влиянием некоторых других игр, особенно Gauntlet
(TM) и Nethack/Moria.

Любое количество игроков может перемещатся в созданном ими мире,
находить и использовать предметы, уничтожать монстров. Игроки могут
сотрудничать или конкурировать в пределах одного "мира"

Этот пакет содержит сервер crossfire.


%package doc
Summary: Documentation for the crossfire game
Summary(ru_RU.UTF-8): Документация для игры crossfire
Group: Games/Adventure

Requires: crossfire-client
BuildArch: noarch

%description doc
crossfire is a multiplayer graphical arcade and adventure game made for
the X-Windows environment.  It runs on a client/server model.
The client runs with X11, GTK, or  SDL within a gtk window.

It has certain flavours from other games, especially Gauntlet (TM)
and Nethack/Moria.

Any number of players can move around in their own window, finding
and using items and battle monsters.  They can choose to cooperate
or compete in the same "world".

This package contains documentation for the crossfire game.

%description -l ru_RU.UTF-8 doc
crossfire - многопользовательская графическая аркадная и
приключенческая игра, работающая в среде X-Windows. Делится на
клиентскую и серверную части. Доступны клиентские части с интерфейсом
X11, GTK, или SDL (в окне gtk).

Игра разработана под влиянием некоторых других игр, особенно Gauntlet
(TM) и Nethack/Moria.

Любое количество игроков может перемещатся в созданном ими мире,
находить и использовать предметы, уничтожать монстров. Игроки могут
сотрудничать или конкурировать в пределах одного "мира"

Этот пакет содержит полный комплект документации для игры в crossfire.


%prep
%setup -q
# %patch0 -p1
%patch1 -p2


%build
CFLAGS="${CFLAGS:-%optflags}" ./configure \
	--prefix=%_prefix \
	--mandir=%_mandir \
	--bindir=%_gamesbindir \
	--datadir=%_gamesdatadir \
	--localstatedir=%_localstatedir/games \
	--sysconfdir=%_sysconfdir
%make_build


%install
make DESTDIR=%buildroot install

# Documentation
install -d %buildroot%_defaultdocdir/%name-doc-%version
cp -R doc/* %buildroot%_defaultdocdir/%name-doc-%version
rm -f %buildroot%_defaultdocdir/%name-doc-%version/Developers/Makefile*
rm -rf %buildroot%_defaultdocdir/%name-doc-%version/playbook
rm -f %buildroot%_defaultdocdir/%name-doc-%version/playbook-html/Makefile*
rm -f %buildroot%_defaultdocdir/%name-doc-%version/playbook-html/*-extract
rm -f %buildroot%_defaultdocdir/%name-doc-%version/playbook-html/sorter
for shtm in \
    %buildroot%_defaultdocdir/%name-doc-%version/playbook-html/*.shtml;\
    do mv $shtm `echo $shtm|sed -e 's/\.shtml/\.html/'`;\
done
rm -rf %buildroot%_defaultdocdir/%name-doc-%version/scripts
rm -f %buildroot%_defaultdocdir/%name-doc-%version/spell-docs/Makefile*
rm -rf %buildroot%_defaultdocdir/%name-doc-%version/spoiler
rm -f %buildroot%_defaultdocdir/%name-doc-%version/spoiler-html/Makefile*
rm -f %buildroot%_defaultdocdir/%name-doc-%version/spoiler-html/*-extract
rm -f %buildroot%_defaultdocdir/%name-doc-%version/Makefile*
rm -f %buildroot%_defaultdocdir/%name-doc-%version/*.pl
gzip -f -9 ChangeLog

# Desktop entry
install -d %buildroot%_desktopdir
install -m 644 %SOURCE4 %buildroot%_desktopdir/%name.desktop
install -d %buildroot%_miconsdir
install -d %buildroot%_niconsdir
install -d %buildroot%_liconsdir
install -m 644 %SOURCE5 %buildroot%_miconsdir/%name.png
install -m 644 %SOURCE6 %buildroot%_niconsdir/%name.png
install -m 644 %SOURCE7 %buildroot%_liconsdir/%name.png

install -d %buildroot%_localstatedir/games/%name/datafiles

%files
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/*
%_gamesbindir/*
%attr(2711, root, games) %_gamesbindir/%name
%_libexecdir/%name
%_man6dir/*
%dir %attr(775, games, games) %_localstatedir/games/%name
%config(noreplace) %attr(664, games, games) %_localstatedir/games/%name/*
%dir %attr(775, games, games) %_localstatedir/games/%name/maps
%dir %attr(775, games, games) %_localstatedir/games/%name/datafiles
%dir %attr(775, games, games) %_localstatedir/games/%name/unique-items
%dir %attr(775, games, games) %_localstatedir/games/%name/players
%dir %attr(775, games, games) %_localstatedir/games/%name/template-maps
%_gamesdatadir/%name
%doc AUTHORS ChangeLog.gz DEVELOPERS NEWS README TODO
%_desktopdir/%name.desktop
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png

%files doc
%_defaultdocdir/%name-doc-%version


%changelog
