# SPEC file for cryptsetup utility: setup crypto disks using
# /dev/mapper interface in 2.6.x kernels

%define _root_sbindir /sbin

Name: cryptsetup
Version: 1.4.2
Release: alt2

Summary: utility to setup a encrypted disks with LUKS support
Summary(ru_RU.UTF-8): утилита управления зашифрованными дисковыми разделами с поддержкой LUKS

License: %gpl2only
Group: System/Kernel and hardware
URL: http://code.google.com/p/cryptsetup/

Source0: %name-%version.tar
Source1: %name.README.ALT.utf-8
Source2: debian.tar
Patch0: %name-%version-%release.patch

Requires: lib%name = %version-%release

BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Sun Nov 15 2009
BuildRequires: libdevmapper-devel libgcrypt-devel libpopt-devel libuuid-devel
BuildRequires: libudev-devel libselinux-devel

# Rename package from cryptsetup-luks-1.0.6-alt0.pre2 to cryptsetup-1.0.6-alt1
Provides:  cryptsetup-luks = %version
Obsoletes: cryptsetup-luks < %version-%release

%description
LUKS ( Linux Unified Key Setup ) is the upcoming standard for 
Linux disk encryption. By providing a standard on-disk-format, 
it does not only facilitate compatibility among distributions,
but also provide secure management of multiple user passwords.
In contrast to existing solution,  LUKS stores all  necessary 
setup information  in the partition header, enabling the user
to transport or migrate his data seamlessly.

This package contains cryptsetup utility to setup a encrypted 
disks based on  dm-crypt  module for 2.6 kernel, with support 
for LUKS infrastructure. Also cryptsetup can handle old 2.4.x
cryptoloop devices.

%description -l ru_RU.UTF-8
LUKS ( Linux Unified Key Setup ) - разрабатываемый стандарт 
для шифрования дисков в Linux. Определяя стандартный формат
хранения  информации на дисках,  он не только  способствует 
совместимости  между различными  дистрибутивами,  но  также 
предоставляет возможность управлять безопасностью доступа к 
данным  путём  использования  нескольких   пользовательских
паролей. По сравнению с существующими решениями, в LUKS вся
необходимая  информация по  настройке параметров шифрования 
хранится в заголовке  раздела диска, облегчая пользователям
перемещение или миграцию данных.

Данный пакет содержит  утилиту  cryptsetup  для  управления 
зашифрованными  дисками, основанными на модуле dm-crypt для
ядер Linux 2.6.x,  с поддержкой  инфраструктуры LUKS. Также 
cryptsetup может  управлять старыми дисками,  использующими 
модуль cryptoloop ядер 2.4.x. 

%package -n lib%name
Group: System/Libraries
Summary: Cryptsetup shared library

%description -n lib%name
This package contains the cryptsetup shared library, libcryptsetup.

%package -n lib%name-devel
Summary: development files for cryptsetup-luks
Summary(ru_RU.UTF-8): файлы для разработки программ с использованием cryptsetup-luks
Group: Development/C
Requires: lib%name = %version-%release
Provides:  %name-devel = %version-%release
Obsoletes: %name-devel < %version-%release

%description -n lib%name-devel
LUKS ( Linux Unified Key Setup ) is the upcoming standard for 
Linux disk encryption. By providing a standard on-disk-format, 
it does not only facilitate compatibility among distributions,
but also provide secure management of multiple user passwords.
In contrast to existing solution,  LUKS stores all  necessary 
setup information  in the partition header, enabling the user
to transport or migrate his data seamlessly.

This package includes  the  development libraries  and header 
files needed for developing applications  that use LUKS.  You
need it only  if  You  plan to  develop or  compile some LUKS 
applications.

%description -n lib%name-devel -l ru_RU.UTF-8
LUKS ( Linux Unified Key Setup ) - разрабатываемый стандарт 
для шифрования дисков в Linux. Определяя стандартный формат
хранения  информации на дисках,  он не только  способствует 
совместимости  между различными  дистрибутивами,  но  также 
предоставляет возможность управлять безопасностью доступа к 
данным  путём  использования  нескольких   пользовательских
паролей. По сравнению с существующими решениями, в LUKS вся
необходимая  информация по  настройке параметров шифрования 
хранится в заголовке  раздела диска, облегчая пользователям
перемещение или миграцию данных.

Данный  пакет  содержит  библиотеки  и  заголовочные  файлы,
необходимые для разработки использующих LUKS приложений.  Он
необходим Вам  только  если Вы планируете  разрабатывать или
компилировать какие-либо приложения с поддержкой LUKS.

%prep
%setup -n %name-%version -a2
%patch0 -p1

cp -- %SOURCE1 README.ALT.utf-8

# Replacing license file with reference
mv -f -- COPYING COPYING.orig
ln -s -- $(relative %_licensedir/GPL-2 %_docdir/%name/COPYING) COPYING

%build
NOCONFIGURE=1 ./autogen.sh
%configure --sbindir=%_root_sbindir --libdir=/%_lib
%make

gcc debian/askpass.c -o debian/askpass

%install
%make DESTDIR=%buildroot install
# move libcryptsetup.so to %%_libdir
pushd %buildroot/%_lib
rm libcryptsetup.so
mkdir -p %buildroot/%_libdir
ln -s ../../%_lib/$(ls libcryptsetup.so.?.?.?) %buildroot/%_libdir/libcryptsetup.so
mv %buildroot/%_lib/pkgconfig %buildroot/%_libdir
popd
mkdir -p %buildroot/%_sbindir
ln -s ../../sbin/%name %buildroot/%_sbindir/%name

install -Dpm 755 debian/cryptdisks-early.init %buildroot%_sysconfdir/rc.d/scripts/cryptdisks-early
install -Dpm 755 debian/cryptdisks.init %buildroot%_sysconfdir/rc.d/scripts/cryptdisks
mkdir -p %buildroot/lib/%name
install -Dpm 755 debian/cryptdisks.functions %buildroot%_sysconfdir/rc.d/init.d/cryptdisks.functions
install -Dpm 600 debian/cryptdisks.default %buildroot%_sysconfdir/sysconfig/cryptdisks
mkdir -p %buildroot/lib/%name/checks
install -Dpm 755 debian/checks/blkid %buildroot/lib/%name/checks/blkid
install -Dpm 755 debian/checks/un_blkid %buildroot/lib/%name/checks/un_blkid
install -Dpm 755 debian/askpass %buildroot/lib/%name/askpass

%find_lang %name


%files -f %name.lang
%doc docs/*
%doc AUTHORS FAQ README
%doc --no-dereference COPYING
%doc README.ALT.utf-8
%_root_sbindir/%name
%_sbindir/%name
%_man8dir/*
%attr(600,root,root) %config(noreplace) %_sysconfdir/sysconfig/cryptdisks
%_sysconfdir/rc.d/scripts/cryptdisks-early
%_sysconfdir/rc.d/scripts/cryptdisks
%dir /lib/%name
%_sysconfdir/rc.d/init.d/cryptdisks.functions
/lib/%name/askpass
%dir /lib/%name/checks
/lib/%name/checks/*

%files -n lib%name
/%_lib/lib%name.so.*

%files -n lib%name-devel
%_includedir/lib%name.h
%_libdir/lib%name.so
%_pkgconfigdir/*

%changelog
